/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.api;

import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OpenAIProvider {
    OpenAI("gpt-4o-mini", "https://api.openai.com/v1"),
    Grok("grok-3-mini", "https://api.x.ai/v1"),
    DeepSeek("deepseek-chat", "https://api.deepseek.com/v1"),
    DouBao("deepseek-v3-250324", "https://ark.cn-beijing.volces.com/api/v3"),
    Gemini("gemini-2.0-flash", "https://generativelanguage.googleapis.com/v1beta/openai"),
    Kimi("moonshot-v1-8k", "https://api.moonshot.cn/v1"),
    Qwen("qwen-turbo", "https://dashscope.aliyuncs.com/compatible-mode/v1"),
    Custom(null, null){

        @Override
        public OpenAIProvider withCustomValues(@NotNull String model, @NonNull String baseURL) {
            if (baseURL == null) {
                throw new NullPointerException("baseURL is marked non-null but is null");
            }
            return this.withCustomValues(model, baseURL, OpenAIProvider.defaultModelsPath, OpenAIProvider.defaultChatCompletionPath);
        }

        @Override
        public OpenAIProvider withCustomValues(@NonNull String model, @NonNull String baseURL, @NonNull String modelsPath, @NonNull String chatCompletionPath) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            if (baseURL == null) {
                throw new NullPointerException("baseURL is marked non-null but is null");
            }
            if (modelsPath == null) {
                throw new NullPointerException("modelsPath is marked non-null but is null");
            }
            if (chatCompletionPath == null) {
                throw new NullPointerException("chatCompletionPath is marked non-null but is null");
            }
            this.defaultModel = model;
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            this.baseURL = baseURL;
            if (!modelsPath.isEmpty()) {
                this.modelsPath = modelsPath;
            }
            if (!chatCompletionPath.isEmpty()) {
                this.chatCompletionPath = chatCompletionPath;
            }
            return this;
        }
    };

    private static final String defaultModelsPath = "/models";
    private static final String defaultChatCompletionPath = "/chat/completions";
    protected String baseURL;
    protected String defaultModel;
    protected String modelsPath;
    protected String chatCompletionPath;

    private OpenAIProvider(String model, String baseURL) {
        this(model, baseURL, defaultModelsPath, defaultChatCompletionPath);
    }

    private OpenAIProvider(String model, String baseURL, String modelsPath, String chatCompletionPath) {
        this.defaultModel = model;
        this.baseURL = baseURL;
        this.modelsPath = modelsPath;
        this.chatCompletionPath = chatCompletionPath;
    }

    public OpenAIProvider withCustomValues(@NonNull String model, @NonNull String baseURL) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (baseURL == null) {
            throw new NullPointerException("baseURL is marked non-null but is null");
        }
        throw new UnsupportedOperationException("Only Custom provider can be configured");
    }

    public OpenAIProvider withCustomValues(@NonNull String model, @NonNull String baseURL, @NonNull String modelsPath, @NonNull String chatCompletionPath) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (baseURL == null) {
            throw new NullPointerException("baseURL is marked non-null but is null");
        }
        if (modelsPath == null) {
            throw new NullPointerException("modelsPath is marked non-null but is null");
        }
        if (chatCompletionPath == null) {
            throw new NullPointerException("chatCompletionPath is marked non-null but is null");
        }
        throw new UnsupportedOperationException("Only Custom provider can be configured");
    }

    @Generated
    public String getBaseURL() {
        return this.baseURL;
    }

    @Generated
    public String getDefaultModel() {
        return this.defaultModel;
    }

    @Generated
    public String getModelsPath() {
        return this.modelsPath;
    }

    @Generated
    public String getChatCompletionPath() {
        return this.chatCompletionPath;
    }
}

