/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.aika.chatjs.ChatJS;
import dev.aika.chatjs.ChatJSUtil;
import dev.aika.chatjs.api.OpenAIClient;
import dev.aika.chatjs.api.resources.ModelObject;
import dev.aika.chatjs.kubejs.OpenAIWrapper;
import dev.aika.chatjs.server.ChatJSEventHandler;
import dev.aika.chatjs.server.SecretManager;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ChatJSCommands {
    private static final Logger log = ChatJS.LOGGER;
    private static final Marker marker = MarkerFactory.getMarker((String)"ChatJSCommands");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        Predicate<CommandSourceStack> op = source -> source.m_81377_().m_129792_() || source.m_6761_(2);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chatjs").then(Commands.m_82127_((String)"reload").executes(ChatJSCommands::reload))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set_apikey").requires(op)).then(Commands.m_82129_((String)"apikey", (ArgumentType)StringArgumentType.string()).executes(ChatJSCommands::setApiKey)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"models").requires(op)).executes(ChatJSCommands::models)));
    }

    private static int reload(CommandContext<CommandSourceStack> ctx) {
        try {
            SecretManager.INSTANCE.load();
            ChatJS.CONFIG.load();
            ChatJSEventHandler.clientInit();
        }
        catch (IOException e) {
            log.error(marker, "Failed to load secret file", (Throwable)e);
            throw new CommandRuntimeException((Component)Component.m_237110_((String)"command.chatjs.msg.failed", (Object[])new Object[]{e.getMessage()}));
        }
        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237115_((String)"command.chatjs.msg.execution_success"));
        return 1;
    }

    private static int setApiKey(CommandContext<CommandSourceStack> ctx) {
        String apikey = StringArgumentType.getString(ctx, (String)"apikey");
        SecretManager.INSTANCE.setProperty("apikey", apikey);
        OpenAIWrapper.setApiKey(apikey);
        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237115_((String)"command.chatjs.msg.execution_success"));
        return 1;
    }

    private static int models(CommandContext<CommandSourceStack> ctx) {
        List<ModelObject> result;
        OpenAIClient client = new OpenAIClient().setProvider(ChatJSUtil.getProvider()).setApiKey(ChatJSUtil.getApiKey()).setTimeout(10.0);
        try {
            result = client.models();
        }
        catch (Exception e) {
            throw new CommandRuntimeException((Component)Component.m_237110_((String)"command.chatjs.msg.failed", (Object[])new Object[]{e.getMessage()}));
        }
        StringBuilder sb = new StringBuilder();
        for (ModelObject m : result) {
            if (ChatJSUtil.getProvider().getDefaultModel().equals(m.id)) {
                sb.append("   > ");
            } else {
                sb.append("   | ");
            }
            sb.append(m.id).append("\n");
        }
        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237110_((String)"command.chatjs.msg.models", (Object[])new Object[]{sb.substring(0, sb.toString().length() - 1)}));
        return 1;
    }
}

