/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.aika.chatjs.ChatJS;
import dev.aika.chatjs.ChatJSUtil;
import dev.aika.chatjs.command.ChatJSCommands;
import dev.aika.chatjs.kubejs.OpenAIWrapper;
import dev.aika.chatjs.server.SecretManager;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ChatJSEventHandler {
    private static final Logger log = ChatJS.LOGGER;
    private static final Marker marker = MarkerFactory.getMarker((String)"ChatJSEventHandler");

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(ChatJSEventHandler::serverStarting);
        LifecycleEvent.SERVER_STOPPING.register(ChatJSEventHandler::serverStopping);
        PlayerEvent.PLAYER_JOIN.register(ChatJSEventHandler::onPlayerLoggedIn);
        CommandRegistrationEvent.EVENT.register(ChatJSEventHandler::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ignoredRegistry, Commands.CommandSelection ignoredSelection) {
        ChatJSCommands.register(dispatcher);
    }

    private static void serverStarting(MinecraftServer server) {
        File secretFile = new File(server.m_129843_(LevelResource.f_78182_).toFile(), "chatjs.secret.properties");
        try {
            SecretManager.INSTANCE.load(secretFile);
            ChatJSEventHandler.clientInit();
        }
        catch (IOException e) {
            log.error(marker, "Failed to load secret file", (Throwable)e);
        }
    }

    private static void serverStopping(MinecraftServer server) {
        try {
            SecretManager.INSTANCE.save();
            OpenAIWrapper.setApiKey(null);
        }
        catch (IOException e) {
            log.error(marker, "Failed to save secret file", (Throwable)e);
        }
    }

    public static void clientInit() {
        OpenAIWrapper.setClient(client -> client.setProvider(ChatJSUtil.getProvider()).setApiKey(ChatJSUtil.getApiKey()).setRPS(((Number)ChatJS.CONFIG.get("http_client.rps")).doubleValue()).setTimeout(((Number)ChatJS.CONFIG.get("http_client.request_timeout")).doubleValue()));
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        if (((Boolean)ChatJS.CONFIG.get("apikey_not_set_warning")).booleanValue() && SecretManager.INSTANCE.getProperty("apikey") == null && (Objects.requireNonNull(player.m_20194_()).m_129792_() || player.m_20310_(2))) {
            player.m_213846_((Component)Component.m_237115_((String)"message.chatjs.apikey_not_set_warning"));
        }
    }
}

