/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.client.gui;

import dev.aika.chatjs.ChatJS;
import dev.aika.chatjs.api.OpenAIProvider;
import dev.aika.chatjs.server.ServerEvents;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Requirement;
import me.shedaniel.clothconfig2.api.ValueHolder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public final class ClothConfigScreen {
    public static Screen create(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)"config.chatjs.title")).setSavingRunnable(ClothConfigScreen::save);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((Component)Component.translatable((String)"config.chatjs.general"));
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"config.chatjs.general.apikey_not_set_warning"), ((Boolean)ChatJS.CONFIG.get("apikey_not_set_warning")).booleanValue()).setDefaultValue(ClothConfigScreen.getDefault("apikey_not_set_warning")).setSaveConsumer(ClothConfigScreen.saveValue("apikey_not_set_warning")).build());
        EnumListEntry provider = entryBuilder.startEnumSelector((Component)Component.translatable((String)"config.chatjs.general.provider"), OpenAIProvider.class, (Enum)OpenAIProvider.valueOf((String)ChatJS.CONFIG.get("provider"))).setDefaultValue(() -> OpenAIProvider.valueOf((String)ChatJS.CONFIG.getDefault("provider"))).setSaveConsumer(value -> ChatJS.CONFIG.set("provider", value.name())).setEnumNameProvider(v -> Component.translatableWithFallback((String)("config.chatjs.general.provider.@" + v.name()), (String)v.name())).build();
        general.addEntry((AbstractConfigListEntry)provider);
        SubCategoryBuilder customProvider = ((SubCategoryBuilder)entryBuilder.startSubCategory((Component)Component.translatable((String)"config.chatjs.general.custom_provider")).setDisplayRequirement(Requirement.isValue((ValueHolder)provider, (Object)((Object)OpenAIProvider.Custom), (Object[])new OpenAIProvider[0]))).setExpanded(true);
        customProvider.add((AbstractConfigListEntry)ClothConfigScreen.createStrFieldEntry(entryBuilder, "custom_provider.model"));
        customProvider.add((AbstractConfigListEntry)ClothConfigScreen.createStrFieldEntry(entryBuilder, "custom_provider.base_url"));
        customProvider.add((AbstractConfigListEntry)ClothConfigScreen.createStrFieldEntry(entryBuilder, "custom_provider.models_path"));
        customProvider.add((AbstractConfigListEntry)ClothConfigScreen.createStrFieldEntry(entryBuilder, "custom_provider.chat_completion_path"));
        general.addEntry((AbstractConfigListEntry)customProvider.build());
        ConfigCategory httpClient = builder.getOrCreateCategory((Component)Component.translatable((String)"config.chatjs.http_client"));
        httpClient.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)Component.translatable((String)"config.chatjs.http_client.rps"), Double.parseDouble(ChatJS.CONFIG.get("http_client.rps").toString())).setDefaultValue(() -> Double.parseDouble(ChatJS.CONFIG.getDefault("http_client.rps").toString())).setSaveConsumer(ClothConfigScreen.saveValue("http_client.rps")).build());
        httpClient.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)Component.translatable((String)"config.chatjs.http_client.request_timeout"), Double.parseDouble(ChatJS.CONFIG.get("http_client.request_timeout").toString())).setDefaultValue(() -> Double.parseDouble(ChatJS.CONFIG.getDefault("http_client.request_timeout").toString())).setSaveConsumer(ClothConfigScreen.saveValue("http_client.request_timeout")).build());
        return builder.build();
    }

    private static <T> Supplier<T> getDefault(String path) {
        return () -> ChatJS.CONFIG.getDefault(path);
    }

    private static <T> Consumer<T> saveValue(String path) {
        return value -> ChatJS.CONFIG.set(path, value);
    }

    private static StringListEntry createStrFieldEntry(ConfigEntryBuilder entryBuilder, String path) {
        return entryBuilder.startStrField((Component)Component.translatable((String)("config.chatjs.general." + path)), (String)ChatJS.CONFIG.get(path)).setDefaultValue(ClothConfigScreen.getDefault(path)).setSaveConsumer(ClothConfigScreen.saveValue(path)).build();
    }

    private static void save() {
        ChatJS.CONFIG.save();
        ServerEvents.clientInit();
    }
}

