/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.client.gui;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class MissingClothConfigScreen
extends Screen {
    private static final String CLOTH_CONFIG_MODRINTH = "https://modrinth.com/mod/9s6osm5g";
    private static final String CLOTH_CONFIG_CURSEFORGE = "https://www.curseforge.com/minecraft/mc-mods/cloth-config";
    private final Component message = Component.translatable((String)"gui.chatjs.missing_cloth_config.message");
    private final Component curseforgeButton = Component.translatable((String)"gui.chatjs.missing_cloth_config.curseforge_download");
    private final Component modrinthButton = Component.translatable((String)"gui.chatjs.missing_cloth_config.modrinth_download");
    private final Screen parent;

    public MissingClothConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"gui.chatjs.missing_cloth_config.title"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        int posX = (this.width - 200) / 2;
        int posY = this.height / 2 - 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.curseforgeButton, (Button.OnPress)this.openLink(CLOTH_CONFIG_CURSEFORGE)).bounds(posX, posY += this.font.wordWrapHeight((FormattedText)this.message, 300), 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.modrinthButton, (Button.OnPress)this.openLink(CLOTH_CONFIG_MODRINTH)).bounds(posX + 100, posY, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, this::onBack).bounds(posX, posY + 25, 200, 20).build());
    }

    private void onBack(Button ignoredButton) {
        Minecraft.getInstance().setScreen(this.parent);
    }

    private Button.OnPress openLink(String link) {
        return b -> {
            if (this.minecraft == null) {
                return;
            }
            this.minecraft.setScreen((Screen)new ConfirmLinkScreen(v -> {
                if (v) {
                    Util.getPlatform().openUri(link);
                }
                this.minecraft.setScreen((Screen)this);
            }, link, true));
        };
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, this.height / 2 - 60, -1);
        MultiLineLabel.create((Font)this.font, (Component)this.message, (int)300).renderCentered(graphics, this.width / 2, this.height / 2 - 30);
    }
}

