/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.aika.chatjs.ChatJS;
import dev.aika.chatjs.ChatJSUtil;
import dev.aika.chatjs.command.ChatJSCommands;
import dev.aika.chatjs.kubejs.OpenAIWrapper;
import dev.aika.chatjs.server.SecretManager;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class ServerEvents {
    private static final Logger log = ChatJS.LOGGER;
    private static final Marker marker = MarkerFactory.getMarker((String)"ServerEvents");

    public static void clientInit() {
        OpenAIWrapper.setClient(client -> client.setProvider(ChatJSUtil.getProvider()).setApiKey(ChatJSUtil.getApiKey()).setRPS(((Number)ChatJS.CONFIG.get("http_client.rps")).doubleValue()).setTimeout(((Number)ChatJS.CONFIG.get("http_client.request_timeout")).doubleValue()));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ChatJSCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        File secretFile = new File(event.getServer().getWorldPath(LevelResource.ROOT).toFile(), "chatjs.secret.properties");
        try {
            SecretManager.INSTANCE.load(secretFile);
            ServerEvents.clientInit();
        }
        catch (IOException e) {
            log.error(marker, "Failed to load secret file", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        try {
            SecretManager.INSTANCE.save();
            OpenAIWrapper.setApiKey(null);
        }
        catch (IOException e) {
            log.error(marker, "Failed to save secret file", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((Boolean)ChatJS.CONFIG.get("apikey_not_set_warning")).booleanValue() && SecretManager.INSTANCE.getProperty("apikey") == null && (Objects.requireNonNull(player2.getServer()).isSingleplayer() || player2.hasPermissions(2))) {
                player2.sendSystemMessage((Component)Component.translatable((String)"message.chatjs.apikey_not_set_warning"));
            }
        }
    }
}

