/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.server;

import dev.aika.chatjs.ChatJS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public enum SecretManager {
    INSTANCE;

    private static final Logger log;
    private static final Marker marker;
    private final Lock lock = new ReentrantLock();
    private final Properties properties = new Properties();
    public File secretFile;

    public String getProperty(String key) {
        this.lock.lock();
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            log.warn(marker, "Secret {} is null or empty", (Object)key);
        }
        this.lock.unlock();
        return value;
    }

    public void setProperty(String key, String value) {
        this.lock.lock();
        this.properties.setProperty(key.trim(), value.trim());
        this.lock.unlock();
    }

    public void load(File file) throws IOException {
        this.lock.lock();
        this.secretFile = file;
        if (!this.secretFile.exists()) {
            Files.createFile(this.secretFile.toPath(), new FileAttribute[0]);
        }
        this.properties.load(new FileInputStream(this.secretFile));
        this.lock.unlock();
    }

    public void load() throws IOException {
        if (this.secretFile == null) {
            throw new IOException("Secret file is null");
        }
        this.load(this.secretFile);
    }

    public void save() throws IOException {
        if (this.secretFile == null) {
            throw new IOException("Secret file is null");
        }
        this.lock.lock();
        this.properties.store(new FileOutputStream(this.secretFile), null);
        this.properties.clear();
        this.lock.unlock();
    }

    static {
        log = ChatJS.LOGGER;
        marker = MarkerFactory.getMarker((String)"SecretManager");
    }
}

