/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs;

import dev.aika.chatjs.ChatJS;
import dev.aika.chatjs.api.OpenAIProvider;
import dev.aika.chatjs.server.SecretManager;
import lombok.Generated;

public final class ChatJSUtil {
    public static OpenAIProvider getProvider() {
        OpenAIProvider provider = OpenAIProvider.valueOf((String)ChatJS.CONFIG.get("provider"));
        if (provider == OpenAIProvider.Custom) {
            provider = OpenAIProvider.Custom.withCustomValues((String)ChatJS.CONFIG.get("custom_provider.model"), (String)ChatJS.CONFIG.get("custom_provider.base_url"), (String)ChatJS.CONFIG.get("custom_provider.models_path"), (String)ChatJS.CONFIG.get("custom_provider.chat_completion_path"));
        }
        return provider;
    }

    public static String getApiKey() {
        String apikey = SecretManager.INSTANCE.getProperty("apikey");
        if (apikey == null || apikey.isEmpty()) {
            ChatJS.LOGGER.warn("apikey not set");
            return null;
        }
        return apikey;
    }

    @Generated
    private ChatJSUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

