/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.aika.chatjs.ChatJS;
import dev.aika.chatjs.ChatJSUtil;
import dev.aika.chatjs.api.OpenAIClient;
import dev.aika.chatjs.api.resources.ModelObject;
import dev.aika.chatjs.kubejs.OpenAIWrapper;
import dev.aika.chatjs.server.ChatJSEventHandler;
import dev.aika.chatjs.server.SecretManager;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ChatJSCommands {
    private static final Logger log = ChatJS.LOGGER;
    private static final Marker marker = MarkerFactory.getMarker((String)"ChatJSCommands");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        Predicate<class_2168> op = source -> source.method_9211().method_3724() || source.method_9259(2);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chatjs").then(class_2170.method_9247((String)"reload").executes(ChatJSCommands::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set_apikey").requires(op)).then(class_2170.method_9244((String)"apikey", (ArgumentType)StringArgumentType.string()).executes(ChatJSCommands::setApiKey)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"models").requires(op)).executes(ChatJSCommands::models)));
    }

    private static int reload(CommandContext<class_2168> ctx) {
        try {
            SecretManager.INSTANCE.load();
            ChatJS.CONFIG.load();
            ChatJSEventHandler.clientInit();
        }
        catch (IOException e) {
            log.error(marker, "Failed to load secret file", (Throwable)e);
            throw new class_2164((class_2561)class_2561.method_43469((String)"command.chatjs.msg.failed", (Object[])new Object[]{e.getMessage()}));
        }
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.chatjs.msg.execution_success"));
        return 1;
    }

    private static int setApiKey(CommandContext<class_2168> ctx) {
        String apikey = StringArgumentType.getString(ctx, (String)"apikey");
        SecretManager.INSTANCE.setProperty("apikey", apikey);
        OpenAIWrapper.setApiKey(apikey);
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.chatjs.msg.execution_success"));
        return 1;
    }

    private static int models(CommandContext<class_2168> ctx) {
        List<ModelObject> result;
        OpenAIClient client = new OpenAIClient().setProvider(ChatJSUtil.getProvider()).setApiKey(ChatJSUtil.getApiKey()).setTimeout(10.0);
        try {
            result = client.models();
        }
        catch (Exception e) {
            throw new class_2164((class_2561)class_2561.method_43469((String)"command.chatjs.msg.failed", (Object[])new Object[]{e.getMessage()}));
        }
        StringBuilder sb = new StringBuilder();
        for (ModelObject m : result) {
            if (ChatJSUtil.getProvider().getDefaultModel().equals(m.id)) {
                sb.append("   > ");
            } else {
                sb.append("   | ");
            }
            sb.append(m.id).append("\n");
        }
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.chatjs.msg.models", (Object[])new Object[]{sb.substring(0, sb.toString().length() - 1)}));
        return 1;
    }
}

