/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.config;

import dev.aika.chatjs.ChatJS;
import dev.aika.chatjs.libs.nightconfig.core.CommentedConfig;
import dev.aika.chatjs.libs.nightconfig.core.UnmodifiableConfig;
import dev.aika.chatjs.libs.nightconfig.toml.TomlParser;
import dev.aika.chatjs.libs.nightconfig.toml.TomlWriter;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ChatJSConfig {
    private static final Logger log = ChatJS.LOGGER;
    private static final Marker marker = MarkerFactory.getMarker((String)"ChatJSConfig");
    private final File configFile = new File(Platform.getConfigFolder().toFile(), "chatjs.server.toml");
    private final TomlParser parser = new TomlParser();
    private final TomlWriter writer = new TomlWriter();
    private final CommentedConfig defaultConfig;
    private CommentedConfig config;

    public ChatJSConfig() {
        try (InputStream stream = this.getClass().getResourceAsStream("/assets/chatjs/default-config.toml");){
            this.defaultConfig = (CommentedConfig)this.parser.parse(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read the default config", e);
        }
    }

    public ChatJSConfig load() {
        if (!this.configFile.exists()) {
            this.save(this.defaultConfig);
        }
        this.config = this.parser.parse(new FileReader(this.configFile));
        log.info("Loaded config");
        return this;
    }

    public void save() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null");
        }
        this.save(this.config);
        log.info(marker, "Saved config");
    }

    private void save(CommentedConfig conf) {
        StringWriter sw = new StringWriter();
        this.writer.write((UnmodifiableConfig)conf, sw);
        Files.write(this.configFile.toPath(), sw.toString().getBytes(), new OpenOption[0]);
    }

    public <T> T get(String path) {
        if (this.defaultConfig != null && !this.config.contains(path)) {
            return this.getDefault(path);
        }
        if (this.config == null) {
            return null;
        }
        return this.config.get(path);
    }

    public <T> T getDefault(String path) {
        if (this.defaultConfig == null) {
            return null;
        }
        return this.defaultConfig.get(path);
    }

    public <T> void set(String path, T value) {
        if (this.config == null) {
            return;
        }
        this.config.set(path, value);
    }
}

