/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.aika.chatjs.ChatJS;
import dev.aika.chatjs.ChatJSUtil;
import dev.aika.chatjs.command.ChatJSCommands;
import dev.aika.chatjs.kubejs.OpenAIWrapper;
import dev.aika.chatjs.server.SecretManager;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ChatJSEventHandler {
    private static final Logger log = ChatJS.LOGGER;
    private static final Marker marker = MarkerFactory.getMarker((String)"ChatJSEventHandler");

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(ChatJSEventHandler::serverStarting);
        LifecycleEvent.SERVER_STOPPING.register(ChatJSEventHandler::serverStopping);
        CommandRegistrationEvent.EVENT.register(ChatJSEventHandler::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 ignoredRegistry, class_2170.class_5364 ignoredSelection) {
        ChatJSCommands.register(dispatcher);
    }

    private static void serverStarting(MinecraftServer server) {
        File secretFile = new File(server.method_27050(class_5218.field_24188).toFile(), "chatjs.secret.properties");
        try {
            SecretManager.INSTANCE.load(secretFile);
            ChatJSEventHandler.clientInit();
        }
        catch (IOException e) {
            log.error(marker, "Failed to load secret file", (Throwable)e);
        }
    }

    private static void serverStopping(MinecraftServer server) {
        try {
            SecretManager.INSTANCE.save();
            OpenAIWrapper.setApiKey(null);
        }
        catch (IOException e) {
            log.error(marker, "Failed to save secret file", (Throwable)e);
        }
    }

    public static void clientInit() {
        OpenAIWrapper.setClient(client -> client.setProvider(ChatJSUtil.getProvider()).setApiKey(ChatJSUtil.getApiKey()).setRPS(((Number)ChatJS.CONFIG.get("http_client.rps")).doubleValue()).setTimeout(((Number)ChatJS.CONFIG.get("http_client.request_timeout")).doubleValue()));
    }
}

