/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sPlayerWarps;

import dev.losterixx.sPlayerWarps.Main;
import dev.losterixx.sPlayerWarps.commands.PlayerWarpCommand;
import dev.losterixx.sPlayerWarps.listener.UpdateCheckerListener;
import dev.losterixx.sPlayerWarps.other.Cache;
import dev.losterixx.sPlayerWarps.other.PWManager;
import dev.losterixx.sapi.SAPI;
import dev.losterixx.sapi.utils.config.ConfigExtras;
import dev.losterixx.sapi.utils.config.ConfigManager;
import dev.losterixx.sapi.utils.scheduling.SchedulerUtil;
import dev.losterixx.sapi.utils.update.UpdateChecker;
import dev.losterixx.utils.bStats.Metrics;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Ldev/losterixx/sPlayerWarps/Main;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "getMiniMessage", "()Lnet/kyori/adventure/text/minimessage/MiniMessage;", "onEnable", "", "onDisable", "isLatestVersion", "", "Companion", "S-PlayerWarps"})
public final class Main
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MiniMessage miniMessage = SAPI.INSTANCE.getMiniMessage();
    private static Main instance;
    @NotNull
    public static final String DEFAULT_PREFIX = "<#D1E332><b>S-PlayerWarps</b> <dark_gray>\u26a1 <gray>";

    @NotNull
    public final MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    public void onEnable() {
        this.getLogger().info("Plugin is being initialized...");
        instance = this;
        SAPI.INSTANCE.init(Companion.getInstance());
        String[] stringArray = new String[]{"data", "cache"};
        ConfigExtras.INSTANCE.loadConfigFiles(stringArray);
        ConfigManager.INSTANCE.createConfig("mainMenu", "menus/mainMenu.yml", "menus");
        ConfigManager.INSTANCE.createConfig("ownWarpsMenu", "menus/ownWarpsMenu.yml", "menus");
        ConfigManager.INSTANCE.createConfig("editWarpMenu", "menus/editWarpMenu.yml", "menus");
        ConfigExtras.loadLangFiles$default(ConfigExtras.INSTANCE, null, null, 3, null);
        this.getLogger().info("Loaded " + ConfigManager.INSTANCE.getAllConfigs().size() + " configs!");
        PWManager.INSTANCE.loadAllFromDisk();
        this.getLogger().info("Loaded " + PWManager.INSTANCE.getAllWarps().size() + " player warps.");
        this.getLogger().info("Loaded " + Cache.INSTANCE.loadCache() + " player names to cache.");
        PWManager.INSTANCE.startSavingTask();
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, (LifecycleEventHandler)onEnable.1.INSTANCE);
        this.getServer().getPluginManager().registerEvents((Listener)PlayerWarpCommand.INSTANCE, (Plugin)Companion.getInstance());
        this.getServer().getPluginManager().registerEvents((Listener)Cache.INSTANCE, (Plugin)Companion.getInstance());
        this.getServer().getPluginManager().registerEvents((Listener)new UpdateCheckerListener(), (Plugin)Companion.getInstance());
        Metrics metrics = new Metrics((Plugin)this, 27788);
        if (ConfigManager.INSTANCE.getConfig("config").getBoolean("updateChecker.consoleMessage").booleanValue()) {
            SchedulerUtil.INSTANCE.runAsync(() -> Main.onEnable$lambda$0(this));
        }
        this.getLogger().info("Plugin has been initialized successfully!");
    }

    public void onDisable() {
        this.getLogger().info("Plugin is shutting down...");
        BukkitTask bukkitTask = PWManager.INSTANCE.getSaveTask();
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        try {
            PWManager.INSTANCE.saveAllToDisk();
            Cache.INSTANCE.saveCache();
            this.getLogger().info("Data has been saved.");
        }
        catch (Exception e) {
            this.getLogger().warning("Error while saving player warps: " + e.getMessage());
        }
        this.getLogger().info("Plugin has been disabled!");
    }

    public final boolean isLatestVersion() {
        String string = this.getPluginMeta().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        String currentVersion = string;
        String latestVersion = UpdateChecker.INSTANCE.getLatestGitHubRelease("Losterixx", "S-PlayerWarps");
        return latestVersion != null && Intrinsics.areEqual(latestVersion, currentVersion);
    }

    private static final Unit onEnable$lambda$0(Main this$0) {
        if (!this$0.isLatestVersion()) {
            this$0.getLogger().warning("You are not using the latest version of S-PlayerWarps! Please update to the latest version.");
            this$0.getLogger().warning("Latest version: " + UpdateChecker.INSTANCE.getLatestGitHubRelease("Losterixx", "S-PlayerWarps"));
            this$0.getLogger().warning("Your version: " + this$0.getPluginMeta().getVersion());
        } else {
            this$0.getLogger().info("You are using the latest version of S-PlayerWarps!");
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/losterixx/sPlayerWarps/Main$Companion;", "", "<init>", "()V", "value", "Ldev/losterixx/sPlayerWarps/Main;", "instance", "getInstance", "()Ldev/losterixx/sPlayerWarps/Main;", "DEFAULT_PREFIX", "", "S-PlayerWarps"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Main getInstance() {
            Main main = instance;
            if (main != null) {
                return main;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

