/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sPlayerWarps.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.losterixx.sPlayerWarps.Main;
import dev.losterixx.sPlayerWarps.libs.boostedyaml.YamlDocument;
import dev.losterixx.sPlayerWarps.other.PWManager;
import dev.losterixx.sPlayerWarps.other.PlayerWarp;
import dev.losterixx.sPlayerWarps.other.ui.GuiManager;
import dev.losterixx.sapi.utils.config.ConfigManager;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/losterixx/sPlayerWarps/commands/PlayerWarpCommand;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "main", "Ldev/losterixx/sPlayerWarps/Main;", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "config", "Ldev/losterixx/sPlayerWarps/libs/boostedyaml/YamlDocument;", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "prefix", "", "getPrefix", "()Ljava/lang/String;", "messages", "getMessages", "pendingTeleports", "", "Ljava/util/UUID;", "Lkotlin/Pair;", "Lorg/bukkit/scheduler/BukkitTask;", "Lorg/bukkit/Location;", "normalizeSoundKey", "soundName", "get", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "onMove", "", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "S-PlayerWarps"})
@SourceDebugExtension(value={"SMAP\nPlayerWarpCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerWarpCommand.kt\ndev/losterixx/sPlayerWarps/commands/PlayerWarpCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n1563#2:276\n1634#2,3:277\n774#2:280\n865#2,2:281\n1869#2,2:283\n*S KotlinDebug\n*F\n+ 1 PlayerWarpCommand.kt\ndev/losterixx/sPlayerWarps/commands/PlayerWarpCommand\n*L\n131#1:276\n131#1:277,3\n132#1:280\n132#1:281,2\n134#1:283,2\n*E\n"})
public final class PlayerWarpCommand
implements Listener {
    @NotNull
    public static final PlayerWarpCommand INSTANCE = new PlayerWarpCommand();
    @NotNull
    private static final Main main = Main.Companion.getInstance();
    @NotNull
    private static final MiniMessage mm = main.getMiniMessage();
    @NotNull
    private static final Map<UUID, Pair<BukkitTask, Location>> pendingTeleports = new LinkedHashMap();

    private PlayerWarpCommand() {
    }

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final String getPrefix() {
        String string = this.getConfig().getString("prefix");
        if (string == null) {
            string = "<#D1E332><b>S-PlayerWarps</b> <dark_gray>\u26a1 <gray>";
        }
        return string;
    }

    private final YamlDocument getMessages() {
        String string = this.getConfig().getString("langFile", "english");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ConfigManager.INSTANCE.getConfig(string);
    }

    private final String normalizeSoundKey(String soundName) {
        String string = soundName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return string;
    }

    @NotNull
    public final LiteralArgumentBuilder<CommandSourceStack> get() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"playerwarp").requires(PlayerWarpCommand::get$lambda$0)).executes(PlayerWarpCommand::get$lambda$1)).then(((LiteralArgumentBuilder)Commands.literal((String)"help").requires(PlayerWarpCommand::get$lambda$2)).executes(PlayerWarpCommand::get$lambda$3))).then(((LiteralArgumentBuilder)Commands.literal((String)"create").requires(PlayerWarpCommand::get$lambda$4)).then(Commands.argument((String)"identifier", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(PlayerWarpCommand::get$lambda$5)))).then(((LiteralArgumentBuilder)Commands.literal((String)"teleport").requires(PlayerWarpCommand::get$lambda$6)).then(Commands.argument((String)"identifier", (ArgumentType)((ArgumentType)StringArgumentType.string())).suggests(PlayerWarpCommand::get$lambda$7).executes(PlayerWarpCommand::get$lambda$8)))).then(((LiteralArgumentBuilder)Commands.literal((String)"menu").requires(PlayerWarpCommand::get$lambda$9)).executes(PlayerWarpCommand::get$lambda$10));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    @EventHandler
    public final void onMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Location location = event.getFrom();
        Intrinsics.checkNotNullExpressionValue(location, "getFrom(...)");
        Location from = location;
        Location location2 = event.getTo();
        Intrinsics.checkNotNullExpressionValue(location2, "getTo(...)");
        Location to = location2;
        Pair<BukkitTask, Location> pair = pendingTeleports.get(player2.getUniqueId());
        if (pair == null) {
            return;
        }
        Pair<BukkitTask, Location> stored = pair;
        if (!this.getConfig().getBoolean("playerwarps.teleportation.delay.cancelOnMove", (Boolean)true).booleanValue()) {
            return;
        }
        if (from.distanceSquared(to) < 0.02) {
            return;
        }
        BukkitTask task2 = stored.component1();
        if (!task2.isCancelled()) {
            task2.cancel();
        }
        pendingTeleports.remove(player2.getUniqueId());
        if (this.getConfig().getBoolean("sounds.cancelSound.enabled", (Boolean)true).booleanValue()) {
            String string = this.getConfig().getString("sounds.cancelSound.sound", "ENTITY_VILLAGER_NO");
            Intrinsics.checkNotNull(string);
            String cancelSoundName = string;
            float cancelVolume = (float)this.getConfig().getDouble("sounds.cancelSound.volume", (Double)1.0).doubleValue();
            float cancelPitch = (float)this.getConfig().getDouble("sounds.cancelSound.pitch", (Double)1.0).doubleValue();
            try {
                player2.playSound(player2.getLocation(), this.normalizeSoundKey(cancelSoundName), cancelVolume, cancelPitch);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        player2.sendMessage(mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.playerwarp.teleport.canceled"))));
    }

    private static final boolean get$lambda$0(CommandSourceStack ctx) {
        return ctx.getSender() instanceof Player && ctx.getSender().hasPermission("s-playerwarps.command.playerwarp.use");
    }

    private static final int get$lambda$1(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player sender = (Player)commandSender;
        if (sender.hasPermission("s-playerwarps.command.playerwarp.menu")) {
            sender.performCommand("playerwarp menu");
        } else {
            sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("commands.playerwarp.usage"))));
        }
        return 1;
    }

    private static final boolean get$lambda$2(CommandSourceStack ctx) {
        return ctx.getSender().hasPermission("s-playerwarps.command.playerwarp.help");
    }

    private static final int get$lambda$3(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player sender = (Player)commandSender;
        sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("commands.playerwarp.usage"))));
        return 1;
    }

    private static final boolean get$lambda$4(CommandSourceStack ctx) {
        return ctx.getSender().hasPermission("s-playerwarps.command.playerwarp.create");
    }

    private static final int get$lambda$5(CommandContext ctx) {
        Integer n;
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player sender = (Player)commandSender;
        Integer configuredMax = INSTANCE.getConfig().getInt("playerwarps.maxWarpsPerPlayer", (Integer)5);
        if (configuredMax > 0) {
            n = configuredMax;
        } else if (configuredMax < 0) {
            n = Integer.MAX_VALUE;
        } else {
            int permLimit = 0;
            for (int i = 100; 0 < i; --i) {
                if (!sender.hasPermission("s-playerwarps.limit." + i)) continue;
                permLimit = i;
                break;
            }
            n = permLimit;
        }
        Integer maxWarpsPerPlayer = n;
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        if (PWManager.INSTANCE.getPlayerWarpsByOwner(uUID).size() >= maxWarpsPerPlayer) {
            sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("commands.playerwarp.create.maxWarpsReached"))));
            return 1;
        }
        String identifier = StringArgumentType.getString((CommandContext)ctx, (String)"identifier");
        String string = INSTANCE.getConfig().getString("playerwarps.identifier.regex", "^[A-Za-z0-9_]+$");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        Regex identifierRegex = new Regex(string);
        Integer minLen = INSTANCE.getConfig().getInt("playerwarps.identifier.minLength", (Integer)4);
        Integer maxLen = INSTANCE.getConfig().getInt("playerwarps.identifier.maxLength", (Integer)16);
        Intrinsics.checkNotNull(identifier);
        if (!identifierRegex.matches(identifier)) {
            String string2 = INSTANCE.getPrefix();
            String string3 = INSTANCE.getMessages().getString("commands.playerwarp.create.identifierRegex");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            sender.sendMessage(mm.deserialize((Object)(string2 + StringsKt.replace$default(string3, "%warp%", identifier, false, 4, null))));
            return 1;
        }
        Intrinsics.checkNotNull(minLen);
        int n2 = minLen;
        Intrinsics.checkNotNull(maxLen);
        int n3 = maxLen;
        int n4 = identifier.length();
        if (!(n2 <= n4 ? n4 <= n3 : false)) {
            String string4 = INSTANCE.getPrefix();
            String string5 = INSTANCE.getMessages().getString("commands.playerwarp.create.identifierLength");
            Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
            sender.sendMessage(mm.deserialize((Object)(string4 + StringsKt.replace$default(string5, "%warp%", identifier, false, 4, null))));
            return 1;
        }
        if (PWManager.INSTANCE.existsPlayerWarp(identifier)) {
            String string6 = INSTANCE.getPrefix();
            String string7 = INSTANCE.getMessages().getString("commands.playerwarp.create.alreadyExists");
            Intrinsics.checkNotNullExpressionValue(string7, "getString(...)");
            sender.sendMessage(mm.deserialize((Object)(string6 + StringsKt.replace$default(string7, "%warp%", identifier, false, 4, null))));
            return 1;
        }
        UUID uUID2 = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        Location location = sender.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Material material = Material.getMaterial((String)INSTANCE.getConfig().getString("playerwarps.defaultWarpIcon"));
        if (material == null) {
            material = Material.COMPASS;
        }
        PWManager.INSTANCE.addPlayerWarp(new PlayerWarp(identifier, uUID2, location, null, material, 0, null, 104, null));
        String string8 = INSTANCE.getPrefix();
        String string9 = INSTANCE.getMessages().getString("commands.playerwarp.create.success");
        Intrinsics.checkNotNullExpressionValue(string9, "getString(...)");
        sender.sendMessage(mm.deserialize((Object)(string8 + StringsKt.replace$default(string9, "%warp%", identifier, false, 4, null))));
        return 1;
    }

    private static final boolean get$lambda$6(CommandSourceStack ctx) {
        return ctx.getSender().hasPermission("s-playerwarps.command.playerwarp.teleport");
    }

    private static final CompletableFuture get$lambda$7(CommandContext ctx, SuggestionsBuilder builder) {
        String string;
        try {
            String string2 = StringArgumentType.getString((CommandContext)ctx, (String)"identifier");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            string = string3;
        }
        catch (IllegalArgumentException e) {
            string = "";
        }
        String input = string;
        return CompletableFuture.supplyAsync(() -> PlayerWarpCommand.get$lambda$7$0(input)).thenApply(arg_0 -> PlayerWarpCommand.get$lambda$7$2(arg_0 -> PlayerWarpCommand.get$lambda$7$1(builder, arg_0), arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private static final List get$lambda$7$0(String $input) {
        $this$map$iv = PWManager.INSTANCE.getAllWarps();
        $i$f$map = false;
        var3_3 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var8_8 = (PlayerWarp)item$iv$iv;
            var10_10 = destination$iv$iv;
            $i$a$-map-PlayerWarpCommand$get$8$1$1 = false;
            var10_10.add(it.getIdentifier());
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filter-PlayerWarpCommand$get$8$1$2 = false;
            v0 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(v0, "toLowerCase(...)");
            if (StringsKt.startsWith$default(v0, $input, false, 2, null)) ** GOTO lbl-1000
            v1 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(v1, "toLowerCase(...)");
            if (Intrinsics.areEqual(v1, $input) || ((CharSequence)$input).length() == 0) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Suggestions get$lambda$7$1(SuggestionsBuilder $builder, List filteredWarps) {
        Intrinsics.checkNotNull(filteredWarps);
        Iterable $this$forEach$iv = filteredWarps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            $builder.suggest(it);
        }
        return $builder.build();
    }

    private static final Suggestions get$lambda$7$2(Function1 $tmp0, Object p0) {
        return (Suggestions)$tmp0.invoke(p0);
    }

    private static final int get$lambda$8(CommandContext ctx) {
        String identifier;
        Player sender;
        block13: {
            block12: {
                CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
                Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Player");
                sender = (Player)commandSender;
                identifier = StringArgumentType.getString((CommandContext)ctx, (String)"identifier");
                String string = INSTANCE.getConfig().getString("playerwarps.identifier.regex", "^[a-z_]+$");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                Regex identifierRegex = new Regex(string);
                Integer minLen = INSTANCE.getConfig().getInt("playerwarps.identifier.minLength", (Integer)4);
                Integer maxLen = INSTANCE.getConfig().getInt("playerwarps.identifier.maxLength", (Integer)16);
                Intrinsics.checkNotNull(identifier);
                if (!identifierRegex.matches(identifier)) break block12;
                Intrinsics.checkNotNull(minLen);
                int n = minLen;
                Intrinsics.checkNotNull(maxLen);
                int n2 = maxLen;
                int n3 = identifier.length();
                if ((n <= n3 ? n3 <= n2 : false) && PWManager.INSTANCE.existsPlayerWarp(identifier)) break block13;
            }
            String string = INSTANCE.getPrefix();
            String string2 = INSTANCE.getMessages().getString("commands.playerwarp.teleport.notFound");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string2, "%warp%", identifier, false, 4, null))));
            return 1;
        }
        PlayerWarp playerWarp = PWManager.INSTANCE.getPlayerWarp(identifier);
        if (playerWarp == null) {
            PlayerWarpCommand $this$get_u24lambda_u248_u240 = INSTANCE;
            boolean bl = false;
            String string = $this$get_u24lambda_u248_u240.getPrefix();
            String string3 = $this$get_u24lambda_u248_u240.getMessages().getString("commands.playerwarp.teleport.notFound");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string3, "%warp%", identifier, false, 4, null))));
            return 1;
        }
        PlayerWarp playerWarp2 = playerWarp;
        Pair<BukkitTask, Location> pair = pendingTeleports.get(sender.getUniqueId());
        if (pair != null) {
            Pair<BukkitTask, Location> $this$get_u24lambda_u248_u240 = pair;
            boolean bl = false;
            BukkitTask existingTask = $this$get_u24lambda_u248_u240.component1();
            existingTask.cancel();
            pendingTeleports.remove(sender.getUniqueId());
        }
        Boolean delayEnabled = INSTANCE.getConfig().getBoolean("playerwarps.teleportation.delay.enabled", (Boolean)true);
        Integer delaySeconds = INSTANCE.getConfig().getInt("playerwarps.teleportation.delay.delay", (Integer)3);
        if (!delayEnabled.booleanValue() || delaySeconds <= 0) {
            String string = INSTANCE.getPrefix();
            String string4 = INSTANCE.getMessages().getString("commands.playerwarp.teleport.teleporting");
            Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
            sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string4, "%warp%", identifier, false, 4, null))));
            playerWarp2.teleport(sender);
            String string5 = INSTANCE.getPrefix();
            String string6 = INSTANCE.getMessages().getString("commands.playerwarp.teleport.success");
            Intrinsics.checkNotNullExpressionValue(string6, "getString(...)");
            sender.sendMessage(mm.deserialize((Object)(string5 + StringsKt.replace$default(string6, "%warp%", identifier, false, 4, null))));
            if (INSTANCE.getConfig().getBoolean("sounds.teleportSound.enabled", (Boolean)true).booleanValue()) {
                String string7 = INSTANCE.getConfig().getString("sounds.teleportSound.sound", "ENTITY_ENDERMAN_TELEPORT");
                Intrinsics.checkNotNull(string7);
                String soundName = string7;
                float volume = (float)INSTANCE.getConfig().getDouble("sounds.teleportSound.volume", (Double)1.0).doubleValue();
                float pitch = (float)INSTANCE.getConfig().getDouble("sounds.teleportSound.pitch", (Double)1.0).doubleValue();
                try {
                    sender.playSound(sender.getLocation(), INSTANCE.normalizeSoundKey(soundName), volume, pitch);
                }
                catch (Exception e) {
                    main.getLogger().warning("Error while playing sound " + soundName + ": " + e.getMessage());
                }
            }
        } else {
            String string = INSTANCE.getPrefix();
            String string8 = INSTANCE.getMessages().getString("commands.playerwarp.teleport.teleporting");
            Intrinsics.checkNotNullExpressionValue(string8, "getString(...)");
            sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string8, "%warp%", identifier, false, 4, null))));
            Ref.ObjectRef remaining = new Ref.ObjectRef();
            remaining.element = delaySeconds;
            BukkitTask bukkitTask = main.getServer().getScheduler().runTaskTimer((Plugin)main, () -> PlayerWarpCommand.get$lambda$8$2(sender, remaining, playerWarp2, identifier), 0L, 20L);
            Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimer(...)");
            BukkitTask task2 = bukkitTask;
            pendingTeleports.put(sender.getUniqueId(), new Pair<BukkitTask, Location>(task2, sender.getLocation()));
        }
        return 1;
    }

    private static final void get$lambda$8$2(Player $sender, Ref.ObjectRef $remaining, PlayerWarp $playerWarp, String $identifier) {
        if (!$sender.isOnline()) {
            pendingTeleports.remove($sender.getUniqueId());
            return;
        }
        $remaining.element = ((Number)$remaining.element).intValue() - 1;
        if (((Number)$remaining.element).intValue() <= 0) {
            BukkitTask bukkitTask;
            $playerWarp.teleport($sender);
            String string = INSTANCE.getPrefix();
            String string2 = INSTANCE.getMessages().getString("commands.playerwarp.teleport.success");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            Intrinsics.checkNotNull($identifier);
            $sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string2, "%warp%", $identifier, false, 4, null))));
            if (INSTANCE.getConfig().getBoolean("sounds.teleportSound.enabled", (Boolean)true).booleanValue()) {
                String string3 = INSTANCE.getConfig().getString("sounds.teleportSound.sound", "ENTITY_ENDERMAN_TELEPORT");
                Intrinsics.checkNotNull(string3);
                String soundName = string3;
                float volume = (float)INSTANCE.getConfig().getDouble("sounds.teleportSound.volume", (Double)1.0).doubleValue();
                float pitch = (float)INSTANCE.getConfig().getDouble("sounds.teleportSound.pitch", (Double)1.0).doubleValue();
                try {
                    $sender.playSound($sender.getLocation(), INSTANCE.normalizeSoundKey(soundName), volume, pitch);
                }
                catch (Exception e) {
                    main.getLogger().warning("Error while playing sound " + soundName + ": " + e.getMessage());
                }
            }
            if ((bukkitTask = pendingTeleports.get($sender.getUniqueId())) != null && (bukkitTask = bukkitTask.getFirst()) != null) {
                bukkitTask.cancel();
            }
            pendingTeleports.remove($sender.getUniqueId());
        } else if (INSTANCE.getConfig().getBoolean("sounds.delaySound.enabled", (Boolean)true).booleanValue()) {
            String string = INSTANCE.getConfig().getString("sounds.delaySound.sound", "BLOCK_NOTE_BLOCK_BASS");
            Intrinsics.checkNotNull(string);
            String delaySoundName = string;
            float delaySoundVolume = (float)INSTANCE.getConfig().getDouble("sounds.delaySound.volume", (Double)1.0).doubleValue();
            float delaySoundPitch = (float)INSTANCE.getConfig().getDouble("sounds.delaySound.pitch", (Double)1.0).doubleValue();
            try {
                $sender.playSound($sender.getLocation(), INSTANCE.normalizeSoundKey(delaySoundName), delaySoundVolume, delaySoundPitch);
            }
            catch (Exception e) {
                main.getLogger().warning("Error while playing sound " + delaySoundName + ": " + e.getMessage());
            }
        }
    }

    private static final boolean get$lambda$9(CommandSourceStack ctx) {
        return ctx.getSender().hasPermission("s-playerwarps.command.playerwarp.menu");
    }

    private static final int get$lambda$10(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player sender = (Player)commandSender;
        GuiManager.INSTANCE.openMainMenu(sender);
        return 1;
    }
}

