/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sPlayerWarps.other;

import dev.losterixx.sPlayerWarps.Main;
import dev.losterixx.sPlayerWarps.libs.boostedyaml.YamlDocument;
import dev.losterixx.sPlayerWarps.libs.boostedyaml.block.implementation.Section;
import dev.losterixx.sapi.utils.config.ConfigManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Ldev/losterixx/sPlayerWarps/other/Cache;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "main", "Ldev/losterixx/sPlayerWarps/Main;", "cache", "Ldev/losterixx/sPlayerWarps/libs/boostedyaml/YamlDocument;", "getCache", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "nameCache", "", "Ljava/util/UUID;", "", "getNameCache", "()Ljava/util/Map;", "loadCache", "", "saveCache", "", "onPlayerJoin", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "S-PlayerWarps"})
public final class Cache
implements Listener {
    @NotNull
    public static final Cache INSTANCE = new Cache();
    @NotNull
    private static final Main main = Main.Companion.getInstance();
    @NotNull
    private static final Map<UUID, String> nameCache = new LinkedHashMap();

    private Cache() {
    }

    private final YamlDocument getCache() {
        return ConfigManager.INSTANCE.getConfig("cache");
    }

    @NotNull
    public final Map<UUID, String> getNameCache() {
        return nameCache;
    }

    public final int loadCache() {
        Section section;
        YamlDocument cfg = this.getCache();
        try {
            section = cfg.getSection("players");
        }
        catch (Exception e) {
            section = null;
        }
        Section playersSection = section;
        if (playersSection == null) {
            return 0;
        }
        int count2 = 0;
        for (String key : playersSection.getRoutesAsStrings(false)) {
            if (cfg.getString("players." + key + ".name") == null) continue;
            try {
                String name;
                UUID uuid = UUID.fromString(key);
                nameCache.put(uuid, name);
                ++count2;
            }
            catch (Exception exception) {}
        }
        return count2;
    }

    public final void saveCache() {
        this.getCache().remove("players");
        for (Map.Entry<UUID, String> entry : nameCache.entrySet()) {
            UUID uuid = entry.getKey();
            String name = entry.getValue();
            this.getCache().set("players." + uuid + ".name", (Object)name);
        }
        ConfigManager.INSTANCE.saveConfig("cache");
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String name = string;
        String previous = nameCache.get(uuid);
        if (previous == null || !Intrinsics.areEqual(previous, name)) {
            nameCache.put(uuid, name);
        }
    }
}

