/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sPlayerWarps.other;

import dev.losterixx.sPlayerWarps.Main;
import dev.losterixx.sPlayerWarps.libs.boostedyaml.YamlDocument;
import dev.losterixx.sPlayerWarps.libs.boostedyaml.block.implementation.Section;
import dev.losterixx.sPlayerWarps.other.PlayerWarp;
import dev.losterixx.sapi.utils.config.ConfigManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0016J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u000fJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Ldev/losterixx/sPlayerWarps/other/PWManager;", "", "<init>", "()V", "main", "Ldev/losterixx/sPlayerWarps/Main;", "config", "Ldev/losterixx/sPlayerWarps/libs/boostedyaml/YamlDocument;", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "data", "getData", "cache", "", "", "Ldev/losterixx/sPlayerWarps/other/PlayerWarp;", "value", "Lorg/bukkit/scheduler/BukkitTask;", "saveTask", "getSaveTask", "()Lorg/bukkit/scheduler/BukkitTask;", "loadAllFromDisk", "", "saveAllToDisk", "startSavingTask", "getAllWarps", "", "addPlayerWarp", "playerWarp", "removePlayerWarp", "getPlayerWarp", "identifier", "existsPlayerWarp", "", "getPlayerWarpsByOwner", "owner", "Ljava/util/UUID;", "S-PlayerWarps"})
@SourceDebugExtension(value={"SMAP\nPWManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PWManager.kt\ndev/losterixx/sPlayerWarps/other/PWManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1#2:131\n1563#3:132\n1634#3,3:133\n1563#3:136\n1634#3,3:137\n774#3:140\n865#3,2:141\n*S KotlinDebug\n*F\n+ 1 PWManager.kt\ndev/losterixx/sPlayerWarps/other/PWManager\n*L\n45#1:132\n45#1:133,3\n75#1:136\n75#1:137,3\n127#1:140\n127#1:141,2\n*E\n"})
public final class PWManager {
    @NotNull
    public static final PWManager INSTANCE = new PWManager();
    @NotNull
    private static final Main main = Main.Companion.getInstance();
    @NotNull
    private static final Map<String, PlayerWarp> cache = new ConcurrentHashMap();
    @Nullable
    private static BukkitTask saveTask;

    private PWManager() {
    }

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getData() {
        return ConfigManager.INSTANCE.getConfig("data");
    }

    @Nullable
    public final BukkitTask getSaveTask() {
        return saveTask;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadAllFromDisk() {
        cache.clear();
        Section section = this.getData().getSection("warps");
        if (section == null) {
            return;
        }
        Section warpsSection = section;
        for (String key : warpsSection.getRoutesAsStrings(false)) {
            Collection<UUID> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            UUID owner;
            World world;
            String worldName;
            Section locSection;
            Material material;
            Section warpSection;
            Object $this$loadAllFromDisk_u24lambda_u240;
            if (warpsSection.getSection(key) == null) continue;
            Object object = this;
            try {
                $this$loadAllFromDisk_u24lambda_u240 = object;
                boolean bl = false;
                String string = warpSection.getString("owner");
                if (string == null) continue;
                $this$loadAllFromDisk_u24lambda_u240 = Result.constructor-impl(UUID.fromString(string));
            }
            catch (Throwable bl) {
                $this$loadAllFromDisk_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object = $this$loadAllFromDisk_u24lambda_u240;
            if ((UUID)(Result.isFailure-impl(object) ? null : object) == null) continue;
            String displayName = warpSection.getString("displayName");
            List<String> uniqueUses = warpSection.getStringList("uniqueUses", CollectionsKt.emptyList());
            Integer totalUses = warpSection.getInt("totalUses");
            Material material2 = Material.getMaterial((String)warpSection.getString("material"));
            if (material2 == null) {
                material2 = material = Material.ENDER_PEARL;
            }
            if (warpSection.getSection("loc") == null || locSection.getString("world") == null) continue;
            Double x = locSection.getDouble("x");
            Double y = locSection.getDouble("y");
            Double z = locSection.getDouble("z");
            float yaw = (float)locSection.getDouble("yaw").doubleValue();
            float pitch = (float)locSection.getDouble("pitch").doubleValue();
            if (main.getServer().getWorld(worldName) == null) continue;
            Intrinsics.checkNotNull(x);
            double d = x;
            Intrinsics.checkNotNull(y);
            double d2 = y;
            Intrinsics.checkNotNull(z);
            Location location = new Location(world, d, d2, z.doubleValue(), yaw, pitch);
            Map<String, PlayerWarp> map2 = cache;
            Intrinsics.checkNotNull(key);
            Intrinsics.checkNotNull(totalUses);
            int n = totalUses;
            Intrinsics.checkNotNull(uniqueUses);
            Object object2 = uniqueUses;
            int n2 = n;
            Material material3 = material;
            String string = displayName;
            Location location2 = location;
            UUID uUID = owner;
            String string2 = key;
            boolean $i$f$map = false;
            void var22_24 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string3 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(UUID.fromString((String)it));
            }
            collection = (List)destination$iv$iv;
            List<UUID> list = CollectionsKt.toMutableList((Collection)collection);
            int n3 = n2;
            Material material4 = material3;
            String string4 = string;
            Location location3 = location2;
            UUID uUID2 = uUID;
            String string5 = string2;
            object2 = new PlayerWarp(string5, uUID2, location3, string4, material4, n3, list);
            map2.put(key, (PlayerWarp)object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveAllToDisk() {
        Map<String, PlayerWarp> snapshot = MapsKt.toMap(cache);
        YamlDocument yamlDocument = ConfigManager.INSTANCE.getConfig("data");
        if (yamlDocument == null) {
            return;
        }
        YamlDocument data = yamlDocument;
        data.remove("warps");
        if (snapshot.isEmpty()) {
            data.save();
            return;
        }
        for (Map.Entry<String, PlayerWarp> entry : snapshot.entrySet()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String identifier = entry.getKey();
            PlayerWarp playerWarp = entry.getValue();
            String id = playerWarp.component1();
            UUID owner = playerWarp.component2();
            Location location = playerWarp.component3();
            String displayName = playerWarp.component4();
            Material material = playerWarp.component5();
            int totalUses = playerWarp.component6();
            List<UUID> uniqueUses = playerWarp.component7();
            Object object = location.getWorld();
            if (object == null || (object = object.getName()) == null) continue;
            Object worldName = object;
            if (data.getSection("warps." + identifier) == null) {
                data.createSection("warps." + identifier);
            }
            data.set("warps." + identifier + ".owner", (Object)owner.toString());
            data.set("warps." + identifier + ".loc.world", worldName);
            data.set("warps." + identifier + ".loc.x", (Object)location.getX());
            data.set("warps." + identifier + ".loc.y", (Object)location.getY());
            data.set("warps." + identifier + ".loc.z", (Object)location.getZ());
            data.set("warps." + identifier + ".loc.yaw", (Object)Float.valueOf(location.getYaw()));
            data.set("warps." + identifier + ".loc.pitch", (Object)Float.valueOf(location.getPitch()));
            data.set("warps." + identifier + ".displayName", (Object)displayName);
            data.set("warps." + identifier + ".material", (Object)material.name());
            data.set("warps." + identifier + ".totalUses", (Object)totalUses);
            Iterable iterable = uniqueUses;
            String string = "warps." + identifier + ".uniqueUses";
            YamlDocument yamlDocument2 = data;
            boolean $i$f$map = false;
            void var17_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UUID uUID = (UUID)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            collection = (List)destination$iv$iv;
            yamlDocument2.set(string, (Object)collection);
        }
        data.save();
    }

    public final void startSavingTask() {
        YamlDocument config = ConfigManager.INSTANCE.getConfig("config");
        Integer delaySeconds = config.getInt("saving.delay", (Integer)1200);
        Intrinsics.checkNotNull(delaySeconds);
        long initialDelayTicks = (long)(3 + delaySeconds) * 20L;
        long periodTicks = (long)delaySeconds.intValue() * 20L;
        saveTask = config.getBoolean("saving.async", (Boolean)true) != false ? main.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)Main.Companion.getInstance(), PWManager::startSavingTask$lambda$0, initialDelayTicks, periodTicks) : main.getServer().getScheduler().runTaskTimer((Plugin)Main.Companion.getInstance(), PWManager::startSavingTask$lambda$1, initialDelayTicks, periodTicks);
    }

    @NotNull
    public final List<PlayerWarp> getAllWarps() {
        return CollectionsKt.toList((Iterable)cache.values());
    }

    public final void addPlayerWarp(@NotNull PlayerWarp playerWarp) {
        Intrinsics.checkNotNullParameter(playerWarp, "playerWarp");
        cache.put(playerWarp.getIdentifier(), playerWarp);
    }

    public final void removePlayerWarp(@NotNull PlayerWarp playerWarp) {
        Intrinsics.checkNotNullParameter(playerWarp, "playerWarp");
        cache.remove(playerWarp.getIdentifier());
    }

    @Nullable
    public final PlayerWarp getPlayerWarp(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        return cache.get(identifier);
    }

    public final boolean existsPlayerWarp(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        return cache.containsKey(identifier);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerWarp> getPlayerWarpsByOwner(@NotNull UUID owner) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(owner, "owner");
        Iterable $this$filter$iv = cache.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerWarp it = (PlayerWarp)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOwner(), owner)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void startSavingTask$lambda$0() {
        try {
            INSTANCE.saveAllToDisk();
        }
        catch (Exception e) {
            main.getLogger().warning("Error while saving player warps async: " + e.getMessage());
        }
    }

    private static final void startSavingTask$lambda$1() {
        try {
            INSTANCE.saveAllToDisk();
        }
        catch (Exception e) {
            main.getLogger().warning("Error while saving player warps: " + e.getMessage());
        }
    }
}

