/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sPlayerWarps.other.ui;

import dev.losterixx.sPlayerWarps.Main;
import dev.losterixx.sPlayerWarps.libs.boostedyaml.YamlDocument;
import dev.losterixx.sPlayerWarps.other.PWManager;
import dev.losterixx.sPlayerWarps.other.PlayerWarp;
import dev.losterixx.sPlayerWarps.other.ui.GuiManager;
import dev.losterixx.sapi.utils.config.ConfigManager;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.dialog.DialogResponseView;
import io.papermc.paper.registry.RegistryBuilderFactory;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldev/losterixx/sPlayerWarps/other/ui/DialogManager;", "", "<init>", "()V", "main", "Ldev/losterixx/sPlayerWarps/Main;", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "config", "Ldev/losterixx/sPlayerWarps/libs/boostedyaml/YamlDocument;", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "messages", "getMessages", "openDisplaynameDialog", "", "player", "Lorg/bukkit/entity/Player;", "warpIdentifier", "", "openIconDialog", "openDeleteDialog", "openCreateDialog", "S-PlayerWarps"})
@SourceDebugExtension(value={"SMAP\nDialogManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogManager.kt\ndev/losterixx/sPlayerWarps/other/ui/DialogManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1563#2:278\n1634#2,3:279\n1563#2:282\n1634#2,3:283\n1563#2:286\n1634#2,3:287\n1563#2:290\n1634#2,3:291\n*S KotlinDebug\n*F\n+ 1 DialogManager.kt\ndev/losterixx/sPlayerWarps/other/ui/DialogManager\n*L\n27#1:278\n27#1:279,3\n88#1:282\n88#1:283,3\n162#1:286\n162#1:287,3\n215#1:290\n215#1:291,3\n*E\n"})
public final class DialogManager {
    @NotNull
    public static final DialogManager INSTANCE = new DialogManager();
    @NotNull
    private static final Main main = Main.Companion.getInstance();
    @NotNull
    private static final MiniMessage mm = main.getMiniMessage();

    private DialogManager() {
    }

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getMessages() {
        String string = this.getConfig().getString("langFile", "english");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ConfigManager.INSTANCE.getConfig(string);
    }

    /*
     * WARNING - void declaration
     */
    public final void openDisplaynameDialog(@NotNull Player player, @NotNull String warpIdentifier) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(warpIdentifier, "warpIdentifier");
        List<String> textsList = this.getMessages().getStringList("dialogs.displayname.texts", CollectionsKt.listOf("Enter new displayname:"));
        Intrinsics.checkNotNull(textsList);
        Iterable $this$map$iv = textsList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DialogBody.plainMessage((Component)mm.deserialize((Object)it)));
        }
        List plainMessagesList = (List)destination$iv$iv;
        Dialog dialog = Dialog.create(arg_0 -> DialogManager.openDisplaynameDialog$lambda$1(plainMessagesList, warpIdentifier, arg_0));
        Intrinsics.checkNotNullExpressionValue(dialog, "create(...)");
        Dialog dialog2 = dialog;
        player.showDialog((DialogLike)dialog2);
    }

    /*
     * WARNING - void declaration
     */
    public final void openIconDialog(@NotNull Player player, @NotNull String warpIdentifier) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(warpIdentifier, "warpIdentifier");
        List<String> textsList = this.getMessages().getStringList("dialogs.icon.texts", CollectionsKt.listOf("Write the name of the material you want to set as icon."));
        Intrinsics.checkNotNull(textsList);
        Iterable $this$map$iv = textsList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DialogBody.plainMessage((Component)mm.deserialize((Object)it)));
        }
        List plainMessagesList = (List)destination$iv$iv;
        Dialog dialog = Dialog.create(arg_0 -> DialogManager.openIconDialog$lambda$1(plainMessagesList, warpIdentifier, arg_0));
        Intrinsics.checkNotNullExpressionValue(dialog, "create(...)");
        Dialog dialog2 = dialog;
        player.showDialog((DialogLike)dialog2);
    }

    /*
     * WARNING - void declaration
     */
    public final void openDeleteDialog(@NotNull Player player, @NotNull String warpIdentifier) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(warpIdentifier, "warpIdentifier");
        List<String> textsList = this.getMessages().getStringList("dialogs.delete.texts", CollectionsKt.listOf("Are you sure?"));
        Intrinsics.checkNotNull(textsList);
        Iterable $this$map$iv = textsList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DialogBody.plainMessage((Component)mm.deserialize((Object)it)));
        }
        List plainMessagesList = (List)destination$iv$iv;
        Dialog dialog = Dialog.create(arg_0 -> DialogManager.openDeleteDialog$lambda$1(plainMessagesList, warpIdentifier, arg_0));
        Intrinsics.checkNotNullExpressionValue(dialog, "create(...)");
        Dialog dialog2 = dialog;
        player.showDialog((DialogLike)dialog2);
    }

    /*
     * WARNING - void declaration
     */
    public final void openCreateDialog(@NotNull Player player) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        List<String> textsList = this.getMessages().getStringList("dialogs.create.texts", CollectionsKt.listOf("Enter the identifier of your new PlayerWarp:"));
        Intrinsics.checkNotNull(textsList);
        Iterable $this$map$iv = textsList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DialogBody.plainMessage((Component)mm.deserialize((Object)it)));
        }
        List plainMessagesList = (List)destination$iv$iv;
        Dialog dialog = Dialog.create(arg_0 -> DialogManager.openCreateDialog$lambda$1(plainMessagesList, arg_0));
        Intrinsics.checkNotNullExpressionValue(dialog, "create(...)");
        Dialog dialog2 = dialog;
        player.showDialog((DialogLike)dialog2);
    }

    private static final void openDisplaynameDialog$lambda$1(List $plainMessagesList, String $warpIdentifier, RegistryBuilderFactory builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        DialogRegistryEntry.Builder builder2 = (DialogRegistryEntry.Builder)builder.empty();
        DialogBase.Builder builder3 = DialogBase.builder((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.displayname.title", "Change Displayname"))).body($plainMessagesList);
        TextDialogInput.Builder builder4 = DialogInput.text((String)"displayname", (Component)((Component)Component.empty())).width(250).labelVisible(true);
        Integer n = INSTANCE.getConfig().getInt("playerwarps.displayNameMaxLength", (Integer)40);
        Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
        builder2.base(builder3.inputs(CollectionsKt.listOf(builder4.maxLength(((Number)n).intValue()).build())).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.displayname.buttons.confirm")), (Component)((Component)Component.empty()), (int)100, (DialogAction)((DialogAction)DialogAction.customClick((arg_0, arg_1) -> DialogManager.openDisplaynameDialog$lambda$1$0($warpIdentifier, arg_0, arg_1), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build())))), (ActionButton)ActionButton.create((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.displayname.buttons.cancel")), (Component)((Component)Component.empty()), (int)100, (DialogAction)((DialogAction)DialogAction.customClick((arg_0, arg_1) -> DialogManager.openDisplaynameDialog$lambda$1$1($warpIdentifier, arg_0, arg_1), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()))))));
    }

    private static final void openDisplaynameDialog$lambda$1$0(String $warpIdentifier, DialogResponseView view, Audience audience) {
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(audience, "audience");
        if (!(audience instanceof Player)) {
            return;
        }
        String string = view.getText("displayname");
        if (string == null) {
            return;
        }
        String displayname = string;
        PlayerWarp playerWarp = PWManager.INSTANCE.getPlayerWarp($warpIdentifier);
        if (playerWarp == null) {
            return;
        }
        PlayerWarp warp = playerWarp;
        warp.setDisplayName(displayname);
        audience.closeDialog();
        GuiManager.INSTANCE.openEditWarpMenu((Player)audience, $warpIdentifier);
    }

    private static final void openDisplaynameDialog$lambda$1$1(String $warpIdentifier, DialogResponseView view, Audience audience) {
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(audience, "audience");
        if (!(audience instanceof Player)) {
            return;
        }
        audience.closeDialog();
        GuiManager.INSTANCE.openEditWarpMenu((Player)audience, $warpIdentifier);
    }

    private static final void openIconDialog$lambda$1(List $plainMessagesList, String $warpIdentifier, RegistryBuilderFactory builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.icon.title", "Change Icon"))).body($plainMessagesList).inputs(CollectionsKt.listOf(DialogInput.text((String)"material", (Component)((Component)Component.empty())).width(250).labelVisible(true).maxLength(50).build())).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.icon.buttons.confirm")), (Component)((Component)Component.empty()), (int)100, (DialogAction)((DialogAction)DialogAction.customClick((arg_0, arg_1) -> DialogManager.openIconDialog$lambda$1$0($warpIdentifier, arg_0, arg_1), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build())))), (ActionButton)ActionButton.create((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.icon.buttons.cancel")), (Component)((Component)Component.empty()), (int)100, (DialogAction)((DialogAction)DialogAction.customClick((arg_0, arg_1) -> DialogManager.openIconDialog$lambda$1$1($warpIdentifier, arg_0, arg_1), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()))))));
    }

    private static final void openIconDialog$lambda$1$0(String $warpIdentifier, DialogResponseView view, Audience audience) {
        Material material;
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(audience, "audience");
        if (!(audience instanceof Player)) {
            return;
        }
        String string = view.getText("material");
        if (string == null) {
            return;
        }
        String materialName = string;
        PlayerWarp playerWarp = PWManager.INSTANCE.getPlayerWarp($warpIdentifier);
        if (playerWarp == null) {
            return;
        }
        PlayerWarp warp = playerWarp;
        String string2 = materialName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        String materialId = StringsKt.replace$default(string2, " ", "_", false, 4, null);
        try {
            material = Material.getMaterial((String)materialId);
        }
        catch (IllegalArgumentException e) {
            material = null;
        }
        Material material2 = material;
        if (material2 == null) {
            audience.sendMessage(mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.icon.messages.invalidMaterial", "<red>Invalid material name!")));
            audience.closeDialog();
            return;
        }
        warp.setMaterial(material2);
        audience.closeDialog();
        GuiManager.INSTANCE.openEditWarpMenu((Player)audience, $warpIdentifier);
    }

    private static final void openIconDialog$lambda$1$1(String $warpIdentifier, DialogResponseView view, Audience audience) {
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(audience, "audience");
        if (!(audience instanceof Player)) {
            return;
        }
        audience.closeDialog();
        GuiManager.INSTANCE.openEditWarpMenu((Player)audience, $warpIdentifier);
    }

    private static final void openDeleteDialog$lambda$1(List $plainMessagesList, String $warpIdentifier, RegistryBuilderFactory builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.delete.title", "Delete PlayerWarp"))).body($plainMessagesList).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.delete.buttons.confirm")), (Component)((Component)Component.empty()), (int)100, (DialogAction)((DialogAction)DialogAction.customClick((arg_0, arg_1) -> DialogManager.openDeleteDialog$lambda$1$0($warpIdentifier, arg_0, arg_1), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build())))), (ActionButton)ActionButton.create((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.delete.buttons.cancel")), (Component)((Component)Component.empty()), (int)100, (DialogAction)((DialogAction)DialogAction.customClick((arg_0, arg_1) -> DialogManager.openDeleteDialog$lambda$1$1($warpIdentifier, arg_0, arg_1), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()))))));
    }

    private static final void openDeleteDialog$lambda$1$0(String $warpIdentifier, DialogResponseView view, Audience audience) {
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(audience, "audience");
        if (!(audience instanceof Player)) {
            return;
        }
        PlayerWarp playerWarp = PWManager.INSTANCE.getPlayerWarp($warpIdentifier);
        if (playerWarp == null) {
            return;
        }
        PlayerWarp warp = playerWarp;
        PWManager.INSTANCE.removePlayerWarp(warp);
        audience.closeDialog();
        GuiManager.INSTANCE.openOwnWarpsMenu((Player)audience);
    }

    private static final void openDeleteDialog$lambda$1$1(String $warpIdentifier, DialogResponseView view, Audience audience) {
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(audience, "audience");
        if (!(audience instanceof Player)) {
            return;
        }
        audience.closeDialog();
        GuiManager.INSTANCE.openEditWarpMenu((Player)audience, $warpIdentifier);
    }

    private static final void openCreateDialog$lambda$1(List $plainMessagesList, RegistryBuilderFactory builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        DialogRegistryEntry.Builder builder2 = (DialogRegistryEntry.Builder)builder.empty();
        DialogBase.Builder builder3 = DialogBase.builder((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.create.title", "Create PlayerWarp"))).body($plainMessagesList);
        TextDialogInput.Builder builder4 = DialogInput.text((String)"identifier", (Component)((Component)Component.empty())).width(250).labelVisible(true);
        Integer n = INSTANCE.getConfig().getInt("playerwarps.identifier.maxLength", (Integer)16);
        Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
        builder2.base(builder3.inputs(CollectionsKt.listOf(builder4.maxLength(((Number)n).intValue()).build())).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.create.buttons.confirm")), (Component)((Component)Component.empty()), (int)100, (DialogAction)((DialogAction)DialogAction.customClick(DialogManager::openCreateDialog$lambda$1$0, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build())))), (ActionButton)ActionButton.create((Component)mm.deserialize((Object)INSTANCE.getMessages().getString("dialogs.create.buttons.cancel")), (Component)((Component)Component.empty()), (int)100, (DialogAction)((DialogAction)DialogAction.customClick(DialogManager::openCreateDialog$lambda$1$1, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()))))));
    }

    private static final void openCreateDialog$lambda$1$0(DialogResponseView view, Audience audience) {
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(audience, "audience");
        if (!(audience instanceof Player)) {
            return;
        }
        String string = view.getText("identifier");
        if (string == null) {
            return;
        }
        String identifier = string;
        ((Player)audience).performCommand("playerwarp create " + identifier);
        audience.closeDialog();
        if (PWManager.INSTANCE.existsPlayerWarp(identifier)) {
            PlayerWarp playerWarp = PWManager.INSTANCE.getPlayerWarp(identifier);
            if (Intrinsics.areEqual(playerWarp != null ? playerWarp.getOwner() : null, ((Player)audience).getUniqueId())) {
                GuiManager.INSTANCE.openEditWarpMenu((Player)audience, identifier);
            }
        }
    }

    private static final void openCreateDialog$lambda$1$1(DialogResponseView view, Audience audience) {
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(audience, "audience");
        if (!(audience instanceof Player)) {
            return;
        }
        audience.closeDialog();
        GuiManager.INSTANCE.openOwnWarpsMenu((Player)audience);
    }
}

