/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sapi.utils.builder;

import dev.losterixx.sPlayerWarps.libs.boostedyaml.block.implementation.Section;
import dev.losterixx.sPlayerWarps.libs.gui.builder.item.PaperItemBuilder;
import dev.losterixx.sPlayerWarps.libs.gui.guis.GuiItem;
import dev.losterixx.sapi.SAPI;
import dev.losterixx.sapi.utils.sapi.SLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/losterixx/sapi/utils/builder/ItemBuilder;", "", "<init>", "()V", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "buildGuiItemFromConfig", "Ldev/losterixx/sPlayerWarps/libs/gui/guis/GuiItem;", "configSection", "Ldev/losterixx/sPlayerWarps/libs/boostedyaml/block/implementation/Section;", "buildItemFromConfig", "S-API"})
@SourceDebugExtension(value={"SMAP\nItemBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemBuilder.kt\ndev/losterixx/sapi/utils/builder/ItemBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1563#2:253\n1634#2,3:254\n1563#2:257\n1634#2,3:258\n*S KotlinDebug\n*F\n+ 1 ItemBuilder.kt\ndev/losterixx/sapi/utils/builder/ItemBuilder\n*L\n34#1:253\n34#1:254,3\n150#1:257\n150#1:258,3\n*E\n"})
public final class ItemBuilder {
    @NotNull
    public static final ItemBuilder INSTANCE = new ItemBuilder();
    @NotNull
    private static final MiniMessage mm = SAPI.INSTANCE.getMiniMessage();

    private ItemBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GuiItem buildGuiItemFromConfig(@NotNull Section configSection) {
        Object flagList;
        Object enchantLevel22;
        String[] $this$mapTo$iv$iv;
        Material material;
        Intrinsics.checkNotNullParameter(configSection, "configSection");
        String materialName = configSection.getString("material");
        try {
            Intrinsics.checkNotNull(materialName);
            String string = materialName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            Material material2 = Material.getMaterial((String)string);
            if (material2 == null) {
                ItemBuilder itemBuilder = this;
                boolean bl = false;
                SLogger.INSTANCE.sapiWarning("Invalid material '" + materialName + "' in GUI config.");
                return null;
            }
            material = material2;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Material material3 = material;
        PaperItemBuilder paperItemBuilder = PaperItemBuilder.from(material3);
        Integer n = configSection.getInt("amount", (Integer)1);
        Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
        PaperItemBuilder paperItemBuilder2 = (PaperItemBuilder)((PaperItemBuilder)paperItemBuilder.amount(((Number)n).intValue())).name(mm.deserialize((Object)configSection.getString("name", "config error")).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        List<String> list = configSection.getStringList("lore");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        Iterable iterable = list;
        PaperItemBuilder paperItemBuilder3 = paperItemBuilder2;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        boolean $i$f$mapTo = false;
        Enchantment enchantment = $this$mapTo$iv$iv.iterator();
        while (enchantment.hasNext()) {
            void line;
            Object item$iv$iv = enchantment.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(mm.deserialize((Object)line).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        }
        PaperItemBuilder paperItemBuilder4 = (PaperItemBuilder)paperItemBuilder3.lore((List)destination$iv$iv);
        Boolean bl = configSection.getBoolean("glow", (Boolean)false);
        Intrinsics.checkNotNullExpressionValue(bl, "getBoolean(...)");
        PaperItemBuilder paperItemBuilder5 = (PaperItemBuilder)paperItemBuilder4.glow(bl);
        Boolean bl2 = configSection.getBoolean("unbreakable", (Boolean)false);
        Intrinsics.checkNotNullExpressionValue(bl2, "getBoolean(...)");
        Object b = paperItemBuilder5.unbreakable(bl2);
        Intrinsics.checkNotNullExpressionValue(b, "unbreakable(...)");
        PaperItemBuilder item = (PaperItemBuilder)b;
        if (configSection.getStringList("enchants") != null) {
            for (String string : configSection.getStringList("enchants")) {
                String enchantName;
                Intrinsics.checkNotNull(string);
                $this$mapTo$iv$iv = new String[]{":"};
                List parts = StringsKt.split$default((CharSequence)string, $this$mapTo$iv$iv, false, 0, 6, null);
                if (parts.size() != 2) {
                    SLogger.INSTANCE.sapiWarning("Invalid enchant format '" + string + "' in GUI config.");
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(((String)parts.get(0)).toUpperCase(Locale.ROOT), "toUpperCase(...)");
                Integer n2 = StringsKt.toIntOrNull((String)parts.get(1));
                if (n2 == null) {
                    ItemBuilder $this$buildGuiItemFromConfig_u24lambda_u242 = this;
                    boolean bl3 = false;
                    SLogger.INSTANCE.sapiWarning("Invalid enchant level in '" + string + "' in GUI config.");
                    continue;
                }
                int enchantLevel22 = n2;
                try {
                    if (Enchantment.getByName((String)enchantName) == null) {
                        ItemBuilder $this$buildGuiItemFromConfig_u24lambda_u243 = this;
                        boolean bl4 = false;
                        SLogger.INSTANCE.sapiWarning("Invalid enchant name '" + enchantName + "' in GUI config.");
                        continue;
                    }
                }
                catch (IllegalArgumentException e) {
                    SLogger.INSTANCE.sapiWarning("Invalid enchant name '" + enchantName + "' in GUI config.");
                    continue;
                }
                Enchantment enchantment2 = enchantment;
                item.enchant(enchantment2, enchantLevel22);
            }
        }
        if (configSection.getString("color") != null) {
            String string = configSection.getString("color");
            Intrinsics.checkNotNull(string);
            String[] stringArray = new String[]{","};
            List parts = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            if (parts.size() != 3) {
                SLogger.INSTANCE.sapiWarning("Invalid color format '" + configSection.getString("color") + "' in GUI config.");
            } else {
                Integer n3 = StringsKt.toIntOrNull((String)parts.get(0));
                Integer g = StringsKt.toIntOrNull((String)parts.get(1));
                Integer b2 = StringsKt.toIntOrNull((String)parts.get(2));
                if (n3 == null || g == null || b2 == null) {
                    SLogger.INSTANCE.sapiWarning("Invalid color values in '" + configSection.getString("color") + "' in GUI config.");
                } else {
                    enchantLevel22 = item.color(Color.fromRGB((int)n3, (int)g, (int)b2));
                    Intrinsics.checkNotNull(enchantLevel22);
                }
            }
        }
        if (configSection.getString("flags") != null) {
            flagList = new ItemFlag[]{};
            for (String flagString : configSection.getStringList("flags")) {
                ItemFlag itemFlag;
                String flagName;
                Intrinsics.checkNotNull(flagString);
                Intrinsics.checkNotNullExpressionValue(flagString.toUpperCase(Locale.ROOT), "toUpperCase(...)");
                try {
                    itemFlag = ItemFlag.valueOf((String)flagName);
                }
                catch (IllegalArgumentException e) {
                    SLogger.INSTANCE.sapiWarning("Invalid item flag '" + flagName + "' in GUI config.");
                    continue;
                }
                enchantLevel22 = itemFlag;
            }
            item.flags(Arrays.copyOf(flagList, ((ItemFlag[])flagList).length));
        }
        if (configSection.getInt("customModelData") != null) {
            if (configSection.getInt("customModelData") < 0) {
                SLogger.INSTANCE.sapiWarning("Custom model data cannot be negative in GUI config.");
            } else {
                Integer n4 = configSection.getInt("customModelData");
                Intrinsics.checkNotNullExpressionValue(n4, "getInt(...)");
                flagList = item.model(((Number)n4).intValue());
                Intrinsics.checkNotNull(flagList);
            }
        }
        if (configSection.getString("itemModel") != null) {
            ItemMeta meta;
            String string = configSection.getString("itemModel");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String[] stringArray = new String[]{":"};
            flagList = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            String string2 = (String)flagList.get(0);
            String key = (String)flagList.get(1);
            ItemStack itemStack = item.build();
            Intrinsics.checkNotNullExpressionValue(itemStack, "build(...)");
            ItemStack newItem = itemStack;
            ItemMeta itemMeta = meta = newItem.getItemMeta();
            Intrinsics.checkNotNull(itemMeta);
            itemMeta.setItemModel(new NamespacedKey(string2, key));
            newItem.setItemMeta(meta);
            PaperItemBuilder paperItemBuilder6 = PaperItemBuilder.from(newItem);
            Intrinsics.checkNotNullExpressionValue(paperItemBuilder6, "from(...)");
            item = paperItemBuilder6;
        }
        if (configSection.getString("playerProfile") != null) {
            if (item.build().getType() != Material.PLAYER_HEAD) {
                SLogger.INSTANCE.sapiWarning("Setting playerProfile can only be set on PLAYER_HEAD items in GUI config.");
            } else {
                String profileString = configSection.getString("playerProfile");
                ItemStack itemStack = item.build();
                Intrinsics.checkNotNullExpressionValue(itemStack, "build(...)");
                ItemStack itemStack2 = itemStack;
                ItemMeta itemMeta = itemStack2.getItemMeta();
                Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
                SkullMeta meta = (SkullMeta)itemMeta;
                try {
                    meta.setPlayerProfile(SAPI.INSTANCE.getPlugin().getServer().getOfflinePlayer(profileString).getPlayerProfile());
                }
                catch (Exception e) {
                    SLogger.INSTANCE.sapiWarning("Could not set player profile '" + profileString + "' in GUI config: " + e.getMessage());
                }
                itemStack2.setItemMeta((ItemMeta)meta);
                PaperItemBuilder paperItemBuilder7 = PaperItemBuilder.from(itemStack2);
                Intrinsics.checkNotNullExpressionValue(paperItemBuilder7, "from(...)");
                item = paperItemBuilder7;
            }
        }
        return item.asGuiItem();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GuiItem buildItemFromConfig(@NotNull Section configSection) {
        Object flagList;
        Object enchantLevel22;
        String[] $this$mapTo$iv$iv;
        Material material;
        Intrinsics.checkNotNullParameter(configSection, "configSection");
        String materialName = configSection.getString("material");
        try {
            Intrinsics.checkNotNull(materialName);
            String string = materialName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            Material material2 = Material.getMaterial((String)string);
            if (material2 == null) {
                ItemBuilder itemBuilder = this;
                boolean bl = false;
                SLogger.INSTANCE.sapiWarning("Invalid material '" + materialName + "' in GUI config.");
                return null;
            }
            material = material2;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Material material3 = material;
        PaperItemBuilder paperItemBuilder = PaperItemBuilder.from(material3);
        Integer n = configSection.getInt("amount", (Integer)1);
        Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
        PaperItemBuilder paperItemBuilder2 = (PaperItemBuilder)((PaperItemBuilder)paperItemBuilder.amount(((Number)n).intValue())).name(mm.deserialize((Object)configSection.getString("name", "config error")).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        List<String> list = configSection.getStringList("lore");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        Iterable iterable = list;
        PaperItemBuilder paperItemBuilder3 = paperItemBuilder2;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        boolean $i$f$mapTo = false;
        Enchantment enchantment = $this$mapTo$iv$iv.iterator();
        while (enchantment.hasNext()) {
            void line;
            Object item$iv$iv = enchantment.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(mm.deserialize((Object)line).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        }
        PaperItemBuilder paperItemBuilder4 = (PaperItemBuilder)paperItemBuilder3.lore((List)destination$iv$iv);
        Boolean bl = configSection.getBoolean("glow", (Boolean)false);
        Intrinsics.checkNotNullExpressionValue(bl, "getBoolean(...)");
        PaperItemBuilder paperItemBuilder5 = (PaperItemBuilder)paperItemBuilder4.glow(bl);
        Boolean bl2 = configSection.getBoolean("unbreakable", (Boolean)false);
        Intrinsics.checkNotNullExpressionValue(bl2, "getBoolean(...)");
        Object b = paperItemBuilder5.unbreakable(bl2);
        Intrinsics.checkNotNullExpressionValue(b, "unbreakable(...)");
        PaperItemBuilder item = (PaperItemBuilder)b;
        if (configSection.getStringList("enchants") != null) {
            for (String string : configSection.getStringList("enchants")) {
                String enchantName;
                Intrinsics.checkNotNull(string);
                $this$mapTo$iv$iv = new String[]{":"};
                List parts = StringsKt.split$default((CharSequence)string, $this$mapTo$iv$iv, false, 0, 6, null);
                if (parts.size() != 2) {
                    SLogger.INSTANCE.sapiWarning("Invalid enchant format '" + string + "' in GUI config.");
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(((String)parts.get(0)).toUpperCase(Locale.ROOT), "toUpperCase(...)");
                Integer n2 = StringsKt.toIntOrNull((String)parts.get(1));
                if (n2 == null) {
                    ItemBuilder $this$buildItemFromConfig_u24lambda_u242 = this;
                    boolean bl3 = false;
                    SLogger.INSTANCE.sapiWarning("Invalid enchant level in '" + string + "' in GUI config.");
                    continue;
                }
                int enchantLevel22 = n2;
                try {
                    if (Enchantment.getByName((String)enchantName) == null) {
                        ItemBuilder $this$buildItemFromConfig_u24lambda_u243 = this;
                        boolean bl4 = false;
                        SLogger.INSTANCE.sapiWarning("Invalid enchant name '" + enchantName + "' in GUI config.");
                        continue;
                    }
                }
                catch (IllegalArgumentException e) {
                    SLogger.INSTANCE.sapiWarning("Invalid enchant name '" + enchantName + "' in GUI config.");
                    continue;
                }
                Enchantment enchantment2 = enchantment;
                item.enchant(enchantment2, enchantLevel22);
            }
        }
        if (configSection.getString("color") != null) {
            String string = configSection.getString("color");
            Intrinsics.checkNotNull(string);
            String[] stringArray = new String[]{","};
            List parts = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            if (parts.size() != 3) {
                SLogger.INSTANCE.sapiWarning("Invalid color format '" + configSection.getString("color") + "' in GUI config.");
            } else {
                Integer n3 = StringsKt.toIntOrNull((String)parts.get(0));
                Integer g = StringsKt.toIntOrNull((String)parts.get(1));
                Integer b2 = StringsKt.toIntOrNull((String)parts.get(2));
                if (n3 == null || g == null || b2 == null) {
                    SLogger.INSTANCE.sapiWarning("Invalid color values in '" + configSection.getString("color") + "' in GUI config.");
                } else {
                    enchantLevel22 = item.color(Color.fromRGB((int)n3, (int)g, (int)b2));
                    Intrinsics.checkNotNull(enchantLevel22);
                }
            }
        }
        if (configSection.getString("flags") != null) {
            flagList = new ItemFlag[]{};
            for (String flagString : configSection.getStringList("flags")) {
                ItemFlag itemFlag;
                String flagName;
                Intrinsics.checkNotNull(flagString);
                Intrinsics.checkNotNullExpressionValue(flagString.toUpperCase(Locale.ROOT), "toUpperCase(...)");
                try {
                    itemFlag = ItemFlag.valueOf((String)flagName);
                }
                catch (IllegalArgumentException e) {
                    SLogger.INSTANCE.sapiWarning("Invalid item flag '" + flagName + "' in GUI config.");
                    continue;
                }
                enchantLevel22 = itemFlag;
            }
            item.flags(Arrays.copyOf(flagList, ((ItemFlag[])flagList).length));
        }
        if (configSection.getInt("customModelData") != null) {
            if (configSection.getInt("customModelData") < 0) {
                SLogger.INSTANCE.sapiWarning("Custom model data cannot be negative in GUI config.");
            } else {
                Integer n4 = configSection.getInt("customModelData");
                Intrinsics.checkNotNullExpressionValue(n4, "getInt(...)");
                flagList = item.model(((Number)n4).intValue());
                Intrinsics.checkNotNull(flagList);
            }
        }
        if (configSection.getString("itemModel") != null) {
            ItemMeta meta;
            String string = configSection.getString("itemModel");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String[] stringArray = new String[]{":"};
            flagList = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            String string2 = (String)flagList.get(0);
            String key = (String)flagList.get(1);
            ItemStack itemStack = item.build();
            Intrinsics.checkNotNullExpressionValue(itemStack, "build(...)");
            ItemStack newItem = itemStack;
            ItemMeta itemMeta = meta = newItem.getItemMeta();
            Intrinsics.checkNotNull(itemMeta);
            itemMeta.setItemModel(new NamespacedKey(string2, key));
            newItem.setItemMeta(meta);
            PaperItemBuilder paperItemBuilder6 = PaperItemBuilder.from(newItem);
            Intrinsics.checkNotNullExpressionValue(paperItemBuilder6, "from(...)");
            item = paperItemBuilder6;
        }
        if (configSection.getString("playerProfile") != null) {
            if (item.build().getType() != Material.PLAYER_HEAD) {
                SLogger.INSTANCE.sapiWarning("Setting playerProfile can only be set on PLAYER_HEAD items in GUI config.");
            } else {
                String profileString = configSection.getString("playerProfile");
                ItemStack itemStack = item.build();
                Intrinsics.checkNotNullExpressionValue(itemStack, "build(...)");
                ItemStack itemStack2 = itemStack;
                ItemMeta itemMeta = itemStack2.getItemMeta();
                Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
                SkullMeta meta = (SkullMeta)itemMeta;
                try {
                    meta.setPlayerProfile(SAPI.INSTANCE.getPlugin().getServer().getOfflinePlayer(profileString).getPlayerProfile());
                }
                catch (Exception e) {
                    SLogger.INSTANCE.sapiWarning("Could not set player profile '" + profileString + "' in GUI config: " + e.getMessage());
                }
                itemStack2.setItemMeta((ItemMeta)meta);
                PaperItemBuilder paperItemBuilder7 = PaperItemBuilder.from(itemStack2);
                Intrinsics.checkNotNullExpressionValue(paperItemBuilder7, "from(...)");
                item = paperItemBuilder7;
            }
        }
        return item.asGuiItem();
    }
}

