/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sapi.utils.config;

import dev.losterixx.sPlayerWarps.libs.boostedyaml.YamlDocument;
import dev.losterixx.sapi.SAPI;
import dev.losterixx.sapi.utils.config.ConfigManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\t2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\b\b\u0002\u0010\u0011\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/losterixx/sapi/utils/config/ConfigExtras;", "", "<init>", "()V", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "logger", "Ljava/util/logging/Logger;", "loadConfigFiles", "", "configs", "", "", "([Ljava/lang/String;)V", "loadLangFiles", "defaultLangFiles", "", "langFolder", "S-API"})
@SourceDebugExtension(value={"SMAP\nConfigExtras.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigExtras.kt\ndev/losterixx/sapi/utils/config/ConfigExtras\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1869#2,2:50\n*S KotlinDebug\n*F\n+ 1 ConfigExtras.kt\ndev/losterixx/sapi/utils/config/ConfigExtras\n*L\n36#1:50,2\n*E\n"})
public final class ConfigExtras {
    @NotNull
    public static final ConfigExtras INSTANCE = new ConfigExtras();
    @NotNull
    private static final JavaPlugin plugin = SAPI.INSTANCE.getPlugin();
    @NotNull
    private static final Logger logger;

    private ConfigExtras() {
    }

    public final void loadConfigFiles(String ... configs) {
        Intrinsics.checkNotNullParameter(configs, "configs");
        YamlDocument config = ConfigManager.createConfig$default(ConfigManager.INSTANCE, "config", "config.yml", null, 4, null);
        for (String configFile : configs) {
            ConfigManager.createConfig$default(ConfigManager.INSTANCE, configFile, configFile + ".yml", null, 4, null);
        }
        ConfigExtras.loadLangFiles$default(this, null, null, 3, null);
        String langFile = ConfigManager.INSTANCE.getConfig("config").getString("langFile", null);
        if (langFile == null) {
            logger.warning("No language file specified in config.yml! Defaulting to english.yml.");
            config.set("langFile", (Object)"english");
            ConfigManager.INSTANCE.saveConfig("config");
        }
        Intrinsics.checkNotNull(langFile);
        ConfigManager.INSTANCE.createConfig(langFile, "lang/" + langFile + ".yml", "lang");
        logger.info("Using language file: " + langFile + ".yml");
    }

    public final void loadLangFiles(@NotNull List<String> defaultLangFiles, @NotNull String langFolder) {
        Intrinsics.checkNotNullParameter(defaultLangFiles, "defaultLangFiles");
        Intrinsics.checkNotNullParameter(langFolder, "langFolder");
        Path langDirectory = plugin.getDataFolder().toPath().resolve("lang");
        if (!Files.exists(langDirectory, new LinkOption[0])) {
            Files.createDirectories(langDirectory, new FileAttribute[0]);
        }
        Iterable $this$forEach$iv = defaultLangFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileName = (String)element$iv;
            boolean bl = false;
            String langConfig = StringsKt.removeSuffix(fileName, (CharSequence)".yml");
            ConfigManager.INSTANCE.createConfig(langConfig, langFolder + "/" + fileName, langFolder);
        }
        Files.list(langDirectory).filter(arg_0 -> ConfigExtras.loadLangFiles$lambda$2(ConfigExtras::loadLangFiles$lambda$1, arg_0)).forEach(arg_0 -> ConfigExtras.loadLangFiles$lambda$4(arg_0 -> ConfigExtras.loadLangFiles$lambda$3(langFolder, arg_0), arg_0));
    }

    public static /* synthetic */ void loadLangFiles$default(ConfigExtras configExtras, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            String[] stringArray = new String[]{"english.yml", "german.yml"};
            list = CollectionsKt.listOf(stringArray);
        }
        if ((n & 2) != 0) {
            string = "lang";
        }
        configExtras.loadLangFiles(list, string);
    }

    private static final boolean loadLangFiles$lambda$1(Path it) {
        return StringsKt.endsWith$default(((Object)it).toString(), ".yml", false, 2, null);
    }

    private static final boolean loadLangFiles$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit loadLangFiles$lambda$3(String $langFolder, Path langFile) {
        String langConfig = StringsKt.removeSuffix(((Object)langFile.getFileName()).toString(), (CharSequence)".yml");
        if (!ConfigManager.INSTANCE.existsConfig(langConfig)) {
            ConfigManager.INSTANCE.createConfig(langConfig, $langFolder + "/" + langFile.getFileName(), $langFolder);
        }
        return Unit.INSTANCE;
    }

    private static final void loadLangFiles$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = plugin.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        ConfigExtras.logger = logger;
    }
}

