/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sapi.utils.numutils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00112\b\b\u0002\u0010\f\u001a\u00020\u0005J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000eJ\"\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\"\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000e2\b\b\u0002\u0010\u001c\u001a\u00020\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/losterixx/sapi/utils/numutils/FormatNums;", "", "<init>", "()V", "defaultDecimalFormat", "Ljava/text/DecimalFormat;", "formatNumber", "", "number", "", "locale", "Ljava/util/Locale;", "format", "", "", "", "formatNumberSimple", "", "formatTimeHMS", "seconds", "showHours", "", "formatTimeDHMS", "formatPercentage", "value", "decimals", "formatBytes", "bytes", "si", "S-API"})
public final class FormatNums {
    @NotNull
    public static final FormatNums INSTANCE = new FormatNums();
    @NotNull
    private static final DecimalFormat defaultDecimalFormat = new DecimalFormat("#,##0.###");

    private FormatNums() {
    }

    @NotNull
    public final String formatNumber(double number, @NotNull Locale locale, @Nullable DecimalFormat format) {
        NumberFormat numberFormat;
        Intrinsics.checkNotNullParameter(locale, "locale");
        DecimalFormat decimalFormat = format;
        if (decimalFormat != null) {
            numberFormat = decimalFormat;
        } else {
            NumberFormat numberFormat2 = NumberFormat.getNumberInstance(locale);
            numberFormat = numberFormat2;
            Intrinsics.checkNotNull(numberFormat2, "null cannot be cast to non-null type java.text.NumberFormat");
        }
        NumberFormat nf = numberFormat;
        String string = nf.format(number);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    public static /* synthetic */ String formatNumber$default(FormatNums formatNums, double d, Locale locale, DecimalFormat decimalFormat, int n, Object object) {
        if ((n & 2) != 0) {
            Locale locale2 = Locale.GERMAN;
            Intrinsics.checkNotNullExpressionValue(locale2, "GERMAN");
            locale = locale2;
        }
        if ((n & 4) != 0) {
            decimalFormat = null;
        }
        return formatNums.formatNumber(d, locale, decimalFormat);
    }

    @NotNull
    public final String formatNumber(float number, @NotNull Locale locale, @Nullable DecimalFormat format) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        return this.formatNumber((double)number, locale, format);
    }

    public static /* synthetic */ String formatNumber$default(FormatNums formatNums, float f, Locale locale, DecimalFormat decimalFormat, int n, Object object) {
        if ((n & 2) != 0) {
            Locale locale2 = Locale.GERMAN;
            Intrinsics.checkNotNullExpressionValue(locale2, "GERMAN");
            locale = locale2;
        }
        if ((n & 4) != 0) {
            decimalFormat = null;
        }
        return formatNums.formatNumber(f, locale, decimalFormat);
    }

    @NotNull
    public final String formatNumber(long number, @NotNull Locale locale, @Nullable DecimalFormat format) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        return this.formatNumber((double)number, locale, format);
    }

    public static /* synthetic */ String formatNumber$default(FormatNums formatNums, long l, Locale locale, DecimalFormat decimalFormat, int n, Object object) {
        if ((n & 2) != 0) {
            Locale locale2 = Locale.GERMAN;
            Intrinsics.checkNotNullExpressionValue(locale2, "GERMAN");
            locale = locale2;
        }
        if ((n & 4) != 0) {
            decimalFormat = null;
        }
        return formatNums.formatNumber(l, locale, decimalFormat);
    }

    @NotNull
    public final String formatNumber(int number, @NotNull Locale locale, @Nullable DecimalFormat format) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        return this.formatNumber((double)number, locale, format);
    }

    public static /* synthetic */ String formatNumber$default(FormatNums formatNums, int n, Locale locale, DecimalFormat decimalFormat, int n2, Object object) {
        if ((n2 & 2) != 0) {
            Locale locale2 = Locale.GERMAN;
            Intrinsics.checkNotNullExpressionValue(locale2, "GERMAN");
            locale = locale2;
        }
        if ((n2 & 4) != 0) {
            decimalFormat = null;
        }
        return formatNums.formatNumber(n, locale, decimalFormat);
    }

    @NotNull
    public final String formatNumberSimple(@NotNull Number number, @NotNull DecimalFormat format) {
        Intrinsics.checkNotNullParameter(number, "number");
        Intrinsics.checkNotNullParameter(format, "format");
        String string = format.format(number);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    public static /* synthetic */ String formatNumberSimple$default(FormatNums formatNums, Number number, DecimalFormat decimalFormat, int n, Object object) {
        if ((n & 2) != 0) {
            decimalFormat = defaultDecimalFormat;
        }
        return formatNums.formatNumberSimple(number, decimalFormat);
    }

    @NotNull
    public final String formatTimeHMS(long seconds, boolean showHours) {
        String string;
        long hrs = TimeUnit.SECONDS.toHours(seconds);
        long mins = TimeUnit.SECONDS.toMinutes(seconds) % (long)60;
        long secs = seconds % (long)60;
        if (showHours || hrs > 0L) {
            String string2 = "%02d:%02d:%02d";
            Object[] objectArray = new Object[]{hrs, mins, secs};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        } else {
            String string4 = "%02d:%02d";
            Object[] objectArray = new Object[]{mins, secs};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
        }
        return string;
    }

    public static /* synthetic */ String formatTimeHMS$default(FormatNums formatNums, long l, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return formatNums.formatTimeHMS(l, bl);
    }

    @NotNull
    public final String formatTimeDHMS(long seconds) {
        long days = TimeUnit.SECONDS.toDays(seconds);
        long hrs = TimeUnit.SECONDS.toHours(seconds) % (long)24;
        long mins = TimeUnit.SECONDS.toMinutes(seconds) % (long)60;
        long secs = seconds % (long)60;
        return days + "d " + hrs + "h " + mins + "m " + secs + "s";
    }

    @NotNull
    public final String formatPercentage(double value, int decimals, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        double factor = Math.pow(10.0, decimals);
        double rounded = (double)((int)(value * factor)) / factor;
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        return nf.format(rounded) + "%";
    }

    public static /* synthetic */ String formatPercentage$default(FormatNums formatNums, double d, int n, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            Locale locale2 = Locale.GERMAN;
            Intrinsics.checkNotNullExpressionValue(locale2, "GERMAN");
            locale = locale2;
        }
        return formatNums.formatPercentage(d, n, locale);
    }

    @NotNull
    public final String formatBytes(long bytes, boolean si, int decimals) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char c = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1);
        Object object = si ? "" : "i";
        String pre = c + (String)object;
        object = "%." + decimals + "f %sB";
        Object[] objectArray = new Object[]{(double)bytes / Math.pow(unit, exp), pre};
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    public static /* synthetic */ String formatBytes$default(FormatNums formatNums, long l, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return formatNums.formatBytes(l, bl, n);
    }
}

