/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.initially.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrbysco.initially.handler.InitialHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class InitialCommand {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.literal((String)"initially");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"give").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(InitialCommand::giveInitial)));
        dispatcher.register(root);
    }

    private static int giveInitial(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            InitialHandler.giveInitially((Player)player);
            MutableComponent text = Component.translatable((String)"commands.initially.give.success", (Object[])new Object[]{player.getName().getContents()}).withStyle(ChatFormatting.GOLD);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> text, false);
        }
        return 0;
    }
}

