/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.initially.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mrbysco.initially.Initially;
import com.mrbysco.initially.config.InitialConfig;
import com.mrbysco.initially.config.object.ItemObject;
import com.mrbysco.initially.handler.InitialHandler;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.neoforged.fml.loading.FMLPaths;

public class ConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File INITIAL_FOLDER = new File(String.valueOf(FMLPaths.CONFIGDIR.get().toFile()) + "/initially");
    public static final File INITIAL_FILE = new File(INITIAL_FOLDER, "Initially.json");

    public static void initializeConfig() {
        if (!INITIAL_FOLDER.exists() || !INITIAL_FILE.exists()) {
            if (!INITIAL_FOLDER.mkdirs()) {
                Initially.LOGGER.error("Failed to create the config folder: {}", (Object)INITIAL_FOLDER.getAbsolutePath());
            }
            ArrayList<ItemObject> items = new ArrayList<ItemObject>(41);
            items.add(new ItemObject(40, "offhand", "", "", 1));
            items.add(new ItemObject(39, "head", "", "", 1));
            items.add(new ItemObject(38, "chest", "", "", 1));
            items.add(new ItemObject(37, "legs", "", "", 1));
            items.add(new ItemObject(36, "feet", "", "", 1));
            for (int i = 0; i < 36; ++i) {
                items.add(new ItemObject(i, "", "", 1));
            }
            InitialConfig initialConfig = new InitialConfig(items);
            try (FileWriter writer = new FileWriter(INITIAL_FILE);){
                GSON.toJson((Object)initialConfig, (Appendable)writer);
                writer.flush();
            }
            catch (IOException e) {
                Initially.LOGGER.trace("Failed to save config", (Throwable)e);
            }
        }
    }

    public static void loadInitialConfig() {
        InitialHandler.itemList.clear();
        String fileName = INITIAL_FILE.getName();
        try (FileReader json = new FileReader(INITIAL_FILE);){
            InitialConfig initialConfig = (InitialConfig)GSON.fromJson((Reader)json, InitialConfig.class);
            if (initialConfig != null) {
                InitialHandler.itemList.addAll(initialConfig.initialList());
            } else {
                Initially.LOGGER.error("Could not load initial item from {}.", (Object)fileName);
            }
        }
        catch (Exception e) {
            Initially.LOGGER.error("Unable to load file {}. Please make sure it's a valid json.", (Object)fileName);
            Initially.LOGGER.trace("Exception: ", (Throwable)e);
        }
    }
}

