/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.initially.handler;

import com.mojang.brigadier.StringReader;
import com.mrbysco.initially.Initially;
import com.mrbysco.initially.config.object.ItemObject;
import com.mrbysco.initially.util.InitialData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class InitialHandler {
    public static final List<ItemObject> itemList = new ArrayList<ItemObject>();
    private static final String initialGiven = "initially:initialGiven";

    @SubscribeEvent
    public void firstJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide()) {
            CompoundTag playerData = player.getPersistentData();
            InitialData initialData = InitialData.get(player.level());
            if (playerData.getBooleanOr(initialGiven, false)) {
                initialData.setGiven(player.getUUID());
                initialData.setDirty();
                playerData.remove(initialGiven);
            }
            if (!initialData.hasBeenGiven(player.getUUID())) {
                InitialHandler.giveInitially(player);
                initialData.setGiven(player.getUUID());
                initialData.setDirty();
            }
        }
    }

    public static void giveInitially(Player player) {
        for (ItemObject object : itemList) {
            Optional optionalItem;
            ResourceLocation location;
            if (object.itemLocation().isEmpty() || (location = ResourceLocation.tryParse((String)object.itemLocation())) == null || !(optionalItem = BuiltInRegistries.ITEM.getOptional(location)).isPresent()) continue;
            Item item = (Item)optionalItem.get();
            Inventory inventory = player.getInventory();
            int slot = object.slot();
            ItemStack stack = new ItemStack((ItemLike)item, object.count());
            if (!object.components().isEmpty()) {
                ItemParser parser = new ItemParser((HolderLookup.Provider)player.level().registryAccess());
                try {
                    ItemParser.ItemResult result = parser.parse(new StringReader(object.itemLocation() + object.components()));
                    stack.applyComponents(result.components());
                }
                catch (Exception e) {
                    Initially.LOGGER.trace("Exception: ", (Throwable)e);
                }
            }
            if (inventory.getItem(slot).isEmpty()) {
                inventory.setItem(slot, stack);
                continue;
            }
            if (player.addItem(stack)) continue;
            ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), stack);
            player.level().addFreshEntity((Entity)itemEntity);
        }
    }
}

