/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.utils.value.IntValue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import pro.mikey.justhammers.HammerTags;
import pro.mikey.justhammers.HammersPlatform;
import pro.mikey.justhammers.config.SimpleJsonConfig;

public class HammerItem
extends PickaxeItem {
    private final int depth;
    private final int radius;

    public HammerItem(Item.Properties rootProperties, ToolMaterial tier, int radius, int depth, int level) {
        super(HammerItem.wrapMaterial(tier, HammerItem.computeDurability(tier, level)), 1.0f, -2.8f, HammerItem.computeProperties(tier, rootProperties));
        this.depth = depth;
        this.radius = radius;
    }

    private static Item.Properties computeProperties(ToolMaterial tier, Item.Properties properties) {
        if (tier == ToolMaterial.NETHERITE) {
            properties.fireResistant();
        }
        return properties;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"justhammers.tooltip.size", (Object[])new Object[]{this.radius, this.radius, this.depth}).withStyle(ChatFormatting.GRAY));
        if (SimpleJsonConfig.INSTANCE.disabledDurabilityTooltip.get().getAsBoolean()) {
            return;
        }
        int damage = Math.max(0, itemStack.getDamageValue());
        int maxDamage = itemStack.getMaxDamage();
        int durabilityPercentage = (int)((float)(maxDamage - damage) / (float)maxDamage * 100.0f);
        ChatFormatting color = ChatFormatting.GREEN;
        if (durabilityPercentage <= 50) {
            color = durabilityPercentage <= 25 ? ChatFormatting.RED : ChatFormatting.YELLOW;
        }
        int remaining = Math.max(0, durabilityPercentage / 20);
        MutableComponent percentComponent = Component.literal((String)(HammerItem.prettyDurability(damage) + "/" + HammerItem.prettyDurability(maxDamage) + " ")).append((Component)Component.literal((String)"*".repeat(remaining)).withStyle(color)).append((Component)Component.literal((String)"*".repeat(5 - remaining)).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(" (" + durabilityPercentage + "%)")).withStyle(ChatFormatting.GRAY));
        list.add((Component)percentComponent);
    }

    private static String prettyDurability(int durability) {
        String output;
        int unitIndex;
        String[] units = new String[]{"", "k", "m"};
        double displayDurability = durability;
        int n = unitIndex = durability > 0 ? (int)(Math.log10(durability) / 3.0) : 0;
        if (unitIndex >= units.length) {
            unitIndex = units.length - 1;
        }
        if ((output = String.format("%.2f", displayDurability /= Math.pow(1000.0, unitIndex))).endsWith(".00")) {
            output = output.substring(0, output.length() - 3);
        }
        return output + units[unitIndex];
    }

    private static int computeDurability(ToolMaterial tier, int level) {
        int baseModified = 0;
        if (level > 1) {
            baseModified = ToolMaterial.NETHERITE.durability();
        }
        return baseModified + ((int)((float)tier.durability() * 2.5f) + 200 * level) * level;
    }

    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        if (SimpleJsonConfig.INSTANCE.allowHammerBreaking.get().getAsBoolean()) {
            return super.getDestroySpeed(itemStack, blockState);
        }
        if (itemStack.getMaxDamage() - itemStack.getDamageValue() <= 1) {
            return -1.0f;
        }
        return super.getDestroySpeed(itemStack, blockState);
    }

    public void causeAoe(Level level, BlockPos pos, BlockState state, ItemStack hammer, LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        if (level.isClientSide || state.getDestroySpeed((BlockGetter)level, pos) == 0.0f) {
            return;
        }
        if (livingEntity.isShiftKeyDown()) {
            return;
        }
        HitResult pick = livingEntity.pick(20.0, 0.0f, false);
        if (!(pick instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)pick;
        this.findAndBreakNearBlocks(blockHitResult, pos, hammer, level, livingEntity);
    }

    public void findAndBreakNearBlocks(BlockHitResult pick, BlockPos blockPos, ItemStack hammerStack, Level level, LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Direction direction = pick.getDirection();
        BoundingBox boundingBox = HammerItem.getAreaOfEffect(blockPos, direction, this.radius, this.depth);
        if (!player.isCreative() && hammerStack.getDamageValue() >= hammerStack.getMaxDamage() - 1) {
            return;
        }
        int damage = 0;
        Iterator iterator = BlockPos.betweenClosedStream((BoundingBox)boundingBox).iterator();
        HashSet<BlockPos> removedPos = new HashSet<BlockPos>();
        while (iterator.hasNext()) {
            boolean correctToolForDrops;
            boolean correctForDrops;
            Tool toolComponent;
            boolean isBroken;
            BlockPos pos = (BlockPos)iterator.next();
            if (pick.getBlockPos().equals((Object)pos)) continue;
            boolean bl = isBroken = hammerStack.getDamageValue() + (damage + 1) >= hammerStack.getMaxDamage() - 1;
            if (SimpleJsonConfig.INSTANCE.allowHammerBreaking.get().getAsBoolean()) {
                boolean bl2 = isBroken = hammerStack.getDamageValue() + (damage + 1) >= hammerStack.getMaxDamage();
            }
            if (!player.isCreative() && isBroken) break;
            BlockState targetState = level.getBlockState(pos);
            if (pos == blockPos || removedPos.contains(pos) || !this.canDestroy(targetState, level, pos) || (toolComponent = (Tool)hammerStack.get(DataComponents.TOOL)) == null || !(correctForDrops = toolComponent.isCorrectForDrops(targetState)) || targetState.is(HammerTags.HAMMER_NO_SMASHY)) continue;
            final int[] xp = new int[]{HammersPlatform.getBlockXpAmount(pos, targetState, level, (Entity)livingEntity, hammerStack)};
            EventResult eventResult = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, targetState, (ServerPlayer)livingEntity, xp[0] == -1 ? null : new IntValue(){

                public void accept(int value) {
                    xp[0] = value;
                }

                public int getAsInt() {
                    return xp[0];
                }
            });
            if (eventResult.isFalse()) continue;
            int outputXpLevel = xp[0];
            if (!player.isCreative() && (correctToolForDrops = player.hasCorrectToolForDrops(targetState))) {
                targetState.spawnAfterBreak((ServerLevel)level, pos, hammerStack, true);
                List drops = Block.getDrops((BlockState)targetState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)livingEntity, (ItemStack)hammerStack);
                List<ItemEntity> dropEntities = drops.stream().map(e -> new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), e)).collect(Collectors.toList());
                boolean result = HammersPlatform.blockDropsEvent((ServerLevel)level, pos, targetState, level.getBlockEntity(pos), dropEntities, (Entity)livingEntity, hammerStack);
                if (!result) {
                    dropEntities.stream().map(ItemEntity::getItem).forEach(e -> Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)pick.getDirection(), (ItemStack)e));
                }
                if (outputXpLevel != -1 && ((ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
                    ExperienceOrb.award((ServerLevel)((ServerLevel)level), (Vec3)Vec3.atCenterOf((Vec3i)blockPos), (int)outputXpLevel);
                }
            }
            removedPos.add(pos);
            targetState.getBlock().destroy((LevelAccessor)level, pos, targetState);
            BlockState newState = Blocks.AIR.defaultBlockState();
            boolean setResult = level.setBlock(pos, newState, 3);
            if (setResult) {
                level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, blockPos, GameEvent.Context.of((Entity)livingEntity, (BlockState)newState));
                player.awardStat(Stats.BLOCK_MINED.get((Object)targetState.getBlock()));
                player.causeFoodExhaustion(0.005f);
            }
            ++damage;
        }
        if (damage != 0 && !player.isCreative()) {
            hammerStack.hurtAndBreak(damage, livingEntity, EquipmentSlot.MAINHAND);
        }
    }

    public static BoundingBox getAreaOfEffect(BlockPos blockPos, Direction direction, int radius, int depth) {
        int size = radius / 2;
        int offset = size - 1;
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> new BoundingBox(blockPos.getX() - size, blockPos.getY() - (direction == Direction.UP ? depth - 1 : 0), blockPos.getZ() - size, blockPos.getX() + size, blockPos.getY() + (direction == Direction.DOWN ? depth - 1 : 0), blockPos.getZ() + size);
            case Direction.NORTH, Direction.SOUTH -> new BoundingBox(blockPos.getX() - size, blockPos.getY() - size + offset, blockPos.getZ() - (direction == Direction.SOUTH ? depth - 1 : 0), blockPos.getX() + size, blockPos.getY() + size + offset, blockPos.getZ() + (direction == Direction.NORTH ? depth - 1 : 0));
            case Direction.WEST, Direction.EAST -> new BoundingBox(blockPos.getX() - (direction == Direction.EAST ? depth - 1 : 0), blockPos.getY() - size + offset, blockPos.getZ() - size, blockPos.getX() + (direction == Direction.WEST ? depth - 1 : 0), blockPos.getY() + size + offset, blockPos.getZ() + size);
        };
    }

    private boolean canDestroy(BlockState targetState, Level level, BlockPos pos) {
        if (targetState.getDestroySpeed((BlockGetter)level, pos) <= 0.0f) {
            return false;
        }
        if (targetState.is(HammerTags.HAMMER_NO_SMASHY)) {
            return false;
        }
        return level.getBlockEntity(pos) == null;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getRadius() {
        return this.radius;
    }

    boolean allowContinuingBlockBreaking(Player player, ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    private static ToolMaterial wrapMaterial(ToolMaterial toolMaterial, int durability) {
        return new ToolMaterial(toolMaterial.incorrectBlocksForDrops(), durability, toolMaterial.speed(), toolMaterial.attackDamageBonus(), toolMaterial.enchantmentValue(), toolMaterial.repairItems());
    }
}

