/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import pro.mikey.justhammers.HammerItem;
import pro.mikey.justhammers.Hammers;
import pro.mikey.justhammers.utils.DeferredResource;

public interface HammerItems {
    public static final Function<String, Item.Properties> DEFAULT_PROPERTIES = name -> new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Hammers.id(name)));
    public static final List<DeferredResource<Item, ? extends Item>> ITEMS = new ArrayList<DeferredResource<Item, ? extends Item>>();
    public static final List<DeferredResource<Item, HammerItem>> HAMMERS = new ArrayList<DeferredResource<Item, HammerItem>>();
    public static final DeferredResource<Item, HammerItem> STONE_HAMMER = HammerItems.registerHammer("stone", ToolMaterial.STONE, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> IRON_HAMMER = HammerItems.registerHammer("iron", ToolMaterial.IRON, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> GOLD_HAMMER = HammerItems.registerHammer("gold", ToolMaterial.GOLD, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> DIAMOND_HAMMER = HammerItems.registerHammer("diamond", ToolMaterial.DIAMOND, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> NETHERITE_HAMMER = HammerItems.registerHammer("netherite", ToolMaterial.NETHERITE, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> STONE_IMPACT_HAMMER = HammerItems.registerHammer("stone_impact", ToolMaterial.STONE, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> IRON_IMPACT_HAMMER = HammerItems.registerHammer("iron_impact", ToolMaterial.IRON, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> GOLD_IMPACT_HAMMER = HammerItems.registerHammer("gold_impact", ToolMaterial.GOLD, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> DIAMOND_IMPACT_HAMMER = HammerItems.registerHammer("diamond_impact", ToolMaterial.DIAMOND, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> NETHERITE_IMPACT_HAMMER = HammerItems.registerHammer("netherite_impact", ToolMaterial.NETHERITE, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> STONE_FIVE_HAMMER = HammerItems.registerHammer("stone_reinforced", ToolMaterial.STONE, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> IRON_FIVE_HAMMER = HammerItems.registerHammer("iron_reinforced", ToolMaterial.IRON, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> GOLD_FIVE_HAMMER = HammerItems.registerHammer("gold_reinforced", ToolMaterial.GOLD, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> DIAMOND_FIVE_HAMMER = HammerItems.registerHammer("diamond_reinforced", ToolMaterial.DIAMOND, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> NETHERITE_FIVE_HAMMER = HammerItems.registerHammer("netherite_reinforced", ToolMaterial.NETHERITE, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> STONE_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("stone_reinforced_impact", ToolMaterial.STONE, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> IRON_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("iron_reinforced_impact", ToolMaterial.IRON, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> GOLD_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("gold_reinforced_impact", ToolMaterial.GOLD, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> DIAMOND_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("diamond_reinforced_impact", ToolMaterial.DIAMOND, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> NETHERITE_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("netherite_reinforced_impact", ToolMaterial.NETHERITE, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> STONE_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("stone_destructor", ToolMaterial.STONE, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, HammerItem> IRON_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("iron_destructor", ToolMaterial.IRON, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, HammerItem> GOLD_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("gold_destructor", ToolMaterial.GOLD, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, HammerItem> DIAMOND_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("diamond_destructor", ToolMaterial.DIAMOND, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, HammerItem> NETHERITE_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("netherite_destructor", ToolMaterial.NETHERITE, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, Item> IMPACT_CORE = HammerItems.register("impact_core", () -> new Item(DEFAULT_PROPERTIES.apply("impact_core")));
    public static final DeferredResource<Item, Item> REINFORCED_CORE = HammerItems.register("reinforced_core", () -> new Item(DEFAULT_PROPERTIES.apply("reinforced_core")));
    public static final DeferredResource<Item, Item> REINFORCED_IMPACT_CORE = HammerItems.register("reinforced_impact_core", () -> new Item(DEFAULT_PROPERTIES.apply("reinforced_impact_core")));
    public static final DeferredResource<Item, Item> DESTRUCTOR_CORE = HammerItems.register("destructor_core", () -> new Item(DEFAULT_PROPERTIES.apply("destructor_core")));

    private static DeferredResource<Item, HammerItem> registerHammer(String name, ToolMaterial material, SizeOption size, int level) {
        DeferredResource<Item, HammerItem> register = HammerItems.register(name + "_hammer", () -> new HammerItem(DEFAULT_PROPERTIES.apply(name + "_hammer"), material, size.radius, size.depth, level));
        HAMMERS.add(register);
        return register;
    }

    private static <T extends Item> DeferredResource<Item, T> register(String name, Supplier<T> supplier) {
        DeferredResource entry = new DeferredResource(name, supplier);
        ITEMS.add(entry);
        return entry;
    }

    public static void init() {
    }

    public static enum SizeOption {
        THREE_THREE(3, 1),
        FIVE_FIVE(5, 1),
        THREE_THREE_THREE(3, 3),
        FIVE_FIVE_THREE(5, 3),
        FIVE_FIVE_FIVE(5, 5);

        final int radius;
        final int depth;

        private SizeOption(int radius, int depth) {
            this.radius = radius;
            this.depth = depth;
        }
    }
}

