/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import pro.mikey.justhammers.HammerTags;
import pro.mikey.justhammers.Hammers;
import pro.mikey.justhammers.config.SimpleJsonConfig;

public class HammerItem
extends class_1810 {
    private final int depth;
    private final int radius;

    public HammerItem(class_1832 tier, int radius, int depth, int level) {
        super((class_1832)new WrappedTier(tier, HammerItem.computeDurability(tier, level)), HammerItem.computeProperties(tier, level));
        this.depth = depth;
        this.radius = radius;
    }

    private static class_1792.class_1793 computeProperties(class_1832 tier, int level) {
        class_1792.class_1793 itemProperties = new class_1792.class_1793().method_7895(HammerItem.computeDurability(tier, level)).method_57348(class_1810.method_57346((class_1832)tier, (float)1.0f, (float)-2.8f)).method_57349(class_9334.field_50077, (Object)tier.method_58418(class_3481.field_33715));
        if (tier == class_1834.field_22033) {
            itemProperties.method_24359();
        }
        return itemProperties;
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> list, class_1836 tooltipFlag) {
        list.add((class_2561)class_2561.method_43469((String)"justhammers.tooltip.size", (Object[])new Object[]{this.radius, this.radius, this.depth}).method_27692(class_124.field_1080));
        if (SimpleJsonConfig.INSTANCE.disabledDurabilityTooltip.get().getAsBoolean()) {
            return;
        }
        int damage = Math.max(0, itemStack.method_7919());
        int maxDamage = itemStack.method_7936();
        int durabilityPercentage = (int)((float)(maxDamage - damage) / (float)maxDamage * 100.0f);
        class_124 color = class_124.field_1060;
        if (durabilityPercentage <= 50) {
            color = durabilityPercentage <= 25 ? class_124.field_1061 : class_124.field_1054;
        }
        int remaining = Math.max(0, durabilityPercentage / 20);
        class_5250 percentComponent = class_2561.method_43470((String)(HammerItem.prettyDurability(damage) + "/" + HammerItem.prettyDurability(maxDamage) + " ")).method_10852((class_2561)class_2561.method_43470((String)"*".repeat(remaining)).method_27692(color)).method_10852((class_2561)class_2561.method_43470((String)"*".repeat(5 - remaining)).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(" (" + durabilityPercentage + "%)")).method_27692(class_124.field_1080));
        list.add((class_2561)percentComponent);
    }

    private static String prettyDurability(int durability) {
        String output;
        int unitIndex;
        String[] units = new String[]{"", "k", "m"};
        double displayDurability = durability;
        int n = unitIndex = durability > 0 ? (int)(Math.log10(durability) / 3.0) : 0;
        if (unitIndex >= units.length) {
            unitIndex = units.length - 1;
        }
        if ((output = String.format("%.2f", displayDurability /= Math.pow(1000.0, unitIndex))).endsWith(".00")) {
            output = output.substring(0, output.length() - 3);
        }
        return output + units[unitIndex];
    }

    private static int computeDurability(class_1832 tier, int level) {
        int baseModified = 0;
        if (level > 1) {
            baseModified = class_1834.field_22033.method_8025();
        }
        return baseModified + ((int)((float)tier.method_8025() * 2.5f) + 200 * level) * level;
    }

    public float method_58404(class_1799 itemStack, class_2680 blockState) {
        if (SimpleJsonConfig.INSTANCE.allowHammerBreaking.get().getAsBoolean()) {
            return super.method_58404(itemStack, blockState);
        }
        if (itemStack.method_7936() - itemStack.method_7919() <= 1) {
            return -1.0f;
        }
        return super.method_58404(itemStack, blockState);
    }

    public void causeAoe(class_1937 level, class_2338 pos, class_2680 state, class_1799 hammer, class_1309 livingEntity) {
        if (!(livingEntity instanceof class_3222)) {
            return;
        }
        if (level.field_9236 || state.method_26214((class_1922)level, pos) == 0.0f) {
            return;
        }
        if (livingEntity.method_5715()) {
            return;
        }
        class_239 pick = livingEntity.method_5745(20.0, 0.0f, false);
        if (!(pick instanceof class_3965)) {
            return;
        }
        class_3965 blockHitResult = (class_3965)pick;
        this.findAndBreakNearBlocks(blockHitResult, pos, hammer, level, livingEntity);
    }

    public void findAndBreakNearBlocks(class_3965 pick, class_2338 blockPos, class_1799 hammerStack, class_1937 level, class_1309 livingEntity) {
        if (!(livingEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)livingEntity;
        class_2350 direction = pick.method_17780();
        class_3341 boundingBox = HammerItem.getAreaOfEffect(blockPos, direction, this.radius, this.depth);
        if (!player.method_7337() && hammerStack.method_7919() >= hammerStack.method_7936() - 1) {
            return;
        }
        int damage = 0;
        Iterator iterator = class_2338.method_23627((class_3341)boundingBox).iterator();
        HashSet<class_2338> removedPos = new HashSet<class_2338>();
        while (iterator.hasNext()) {
            boolean correctToolForDrops;
            class_6862 incorrectBlocksForDrops;
            boolean isBroken;
            class_2338 pos = (class_2338)iterator.next();
            if (pick.method_17777().equals((Object)pos)) continue;
            boolean bl = isBroken = hammerStack.method_7919() + (damage + 1) >= hammerStack.method_7936() - 1;
            if (SimpleJsonConfig.INSTANCE.allowHammerBreaking.get().getAsBoolean()) {
                boolean bl2 = isBroken = hammerStack.method_7919() + (damage + 1) >= hammerStack.method_7936();
            }
            if (!player.method_7337() && isBroken) break;
            class_2680 targetState = level.method_8320(pos);
            if (pos == blockPos || removedPos.contains(pos) || !this.canDestroy(targetState, level, pos) || targetState.method_26164(incorrectBlocksForDrops = this.method_8022().method_58419())) continue;
            int xp = Hammers.XPLAT.getBlockXpAmount(pos, targetState, level, (class_1297)livingEntity, hammerStack);
            boolean canContinue = Hammers.XPLAT.fireBlockBrokenEvent((class_3218)level, pos, targetState, (class_1657)player);
            if (!canContinue) continue;
            if (!player.method_7337() && (correctToolForDrops = player.method_7305(targetState))) {
                targetState.method_26180((class_3218)level, pos, hammerStack, true);
                List drops = class_2248.method_9609((class_2680)targetState, (class_3218)((class_3218)level), (class_2338)pos, (class_2586)level.method_8321(pos), (class_1297)livingEntity, (class_1799)hammerStack);
                List<class_1542> dropEntities = drops.stream().map(e -> new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), e)).collect(Collectors.toList());
                boolean result = Hammers.XPLAT.fireBlockDropsEvent((class_3218)level, pos, targetState, level.method_8321(pos), dropEntities, (class_1297)livingEntity, hammerStack);
                if (!result) {
                    dropEntities.stream().map(class_1542::method_6983).forEach(e -> class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)pick.method_17780(), (class_1799)e));
                }
                if (xp != -1 && level.method_8450().method_8355(class_1928.field_19392)) {
                    class_1303.method_31493((class_3218)((class_3218)level), (class_243)class_243.method_24953((class_2382)blockPos), (int)xp);
                }
            }
            removedPos.add(pos);
            targetState.method_26204().method_9585((class_1936)level, pos, targetState);
            class_2680 newState = class_2246.field_10124.method_9564();
            boolean setResult = level.method_8652(pos, newState, 3);
            if (setResult) {
                level.method_43276((class_6880)class_5712.field_28165, blockPos, class_5712.class_7397.method_43286((class_1297)livingEntity, (class_2680)newState));
                player.method_7259(class_3468.field_15427.method_14956((Object)targetState.method_26204()));
                player.method_7322(0.005f);
            }
            ++damage;
        }
        if (damage != 0 && !player.method_7337()) {
            hammerStack.method_7970(damage, livingEntity, class_1304.field_6173);
        }
    }

    public static class_3341 getAreaOfEffect(class_2338 blockPos, class_2350 direction, int radius, int depth) {
        int size = radius / 2;
        int offset = size - 1;
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033, class_2350.field_11036 -> new class_3341(blockPos.method_10263() - size, blockPos.method_10264() - (direction == class_2350.field_11036 ? depth - 1 : 0), blockPos.method_10260() - size, blockPos.method_10263() + size, blockPos.method_10264() + (direction == class_2350.field_11033 ? depth - 1 : 0), blockPos.method_10260() + size);
            case class_2350.field_11043, class_2350.field_11035 -> new class_3341(blockPos.method_10263() - size, blockPos.method_10264() - size + offset, blockPos.method_10260() - (direction == class_2350.field_11035 ? depth - 1 : 0), blockPos.method_10263() + size, blockPos.method_10264() + size + offset, blockPos.method_10260() + (direction == class_2350.field_11043 ? depth - 1 : 0));
            case class_2350.field_11039, class_2350.field_11034 -> new class_3341(blockPos.method_10263() - (direction == class_2350.field_11034 ? depth - 1 : 0), blockPos.method_10264() - size + offset, blockPos.method_10260() - size, blockPos.method_10263() + (direction == class_2350.field_11039 ? depth - 1 : 0), blockPos.method_10264() + size + offset, blockPos.method_10260() + size);
        };
    }

    private boolean canDestroy(class_2680 targetState, class_1937 level, class_2338 pos) {
        if (!targetState.method_26227().method_15769()) {
            return false;
        }
        if (targetState.method_26214((class_1922)level, pos) <= 0.0f) {
            return false;
        }
        if (targetState.method_26164(HammerTags.HAMMER_NO_SMASHY)) {
            return false;
        }
        return level.method_8321(pos) == null;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getRadius() {
        return this.radius;
    }

    boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return true;
    }

    private record WrappedTier(class_1832 tier, int durability) implements class_1832
    {
        public int method_8025() {
            return this.durability;
        }

        public float method_8027() {
            return this.tier.method_8027();
        }

        public float method_8028() {
            return this.tier.method_8028();
        }

        @NotNull
        public class_6862<class_2248> method_58419() {
            return this.tier.method_58419();
        }

        public int method_8026() {
            return this.tier.method_8026();
        }

        @NotNull
        public class_1856 method_8023() {
            return this.tier.method_8023();
        }
    }
}

