/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import pro.mikey.justhammers.HammerItem;
import pro.mikey.justhammers.HammerTags;

public class SelectionOutlineRender {
    public static void render(ClientLevel world, Camera camera, PoseStack poseStack, MultiBufferSource consumers) {
        if (world == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isShiftKeyDown()) {
            return;
        }
        ItemStack heldItem = player.getMainHandItem();
        ItemStack offHandItem = player.getOffhandItem();
        if (heldItem.isEmpty() && offHandItem.isEmpty()) {
            return;
        }
        if (!(heldItem.getItem() instanceof HammerItem) && !(offHandItem.getItem() instanceof HammerItem)) {
            return;
        }
        HitResult blockHitResult = Minecraft.getInstance().hitResult;
        if (blockHitResult == null || blockHitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        Item item = heldItem.getItem() instanceof HammerItem ? heldItem.getItem() : offHandItem.getItem();
        ItemStack itemStack = heldItem.getItem() instanceof HammerItem ? heldItem : offHandItem;
        HammerItem hammer = (HammerItem)item;
        BlockPos blockPos = ((BlockHitResult)blockHitResult).getBlockPos();
        Direction direction = ((BlockHitResult)blockHitResult).getDirection();
        BlockState block = world.getBlockState(blockPos);
        Tool toolComponent = (Tool)itemStack.get(DataComponents.TOOL);
        if (toolComponent == null) {
            return;
        }
        boolean correctForDrops = toolComponent.isCorrectForDrops(block);
        if (!correctForDrops || block.is(HammerTags.HAMMER_NO_SMASHY)) {
            return;
        }
        BoundingBox boundingBox = HammerItem.getAreaOfEffect(blockPos, direction, hammer.getRadius(), hammer.getDepth());
        poseStack.pushPose();
        poseStack.translate(-camera.getPosition().x(), -camera.getPosition().y(), -camera.getPosition().z());
        Iterator blockPosStream = BlockPos.betweenClosedStream((BoundingBox)boundingBox).iterator();
        while (blockPosStream.hasNext()) {
            BlockPos pos = (BlockPos)blockPosStream.next();
            if (pos.equals((Object)blockPos)) continue;
            BlockState blockState = world.getBlockState(pos);
            FluidState fluidState = blockState.getFluidState();
            if (blockState.isAir() || !fluidState.isEmpty()) continue;
            VoxelShape renderShape = blockState.getVisualShape((BlockGetter)world, pos, CollisionContext.empty());
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            ShapeRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)consumers.getBuffer(RenderType.lines()), (VoxelShape)renderShape, (double)0.0, (double)0.0, (double)0.0, (int)0x59000000);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

