/*
 * Decompiled with CFR 0.152.
 */
package com.stunslam.smashThePing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class SmashThePing
extends JavaPlugin
implements Listener,
TabCompleter {
    private final Map<UUID, AxeHitData> pendingAxeHits = new HashMap<UUID, AxeHitData>();
    private long compensationWindowMs;
    private boolean enabled = true;

    public void onEnable() {
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("smashping").setTabCompleter((TabCompleter)this);
        this.getLogger().info("SmashThePing enabled with compensation window: " + this.compensationWindowMs + " ms");
    }

    private void loadConfig() {
        if (!this.getConfig().contains("compensation-window-ms")) {
            this.getConfig().set("compensation-window-ms", (Object)500);
            this.saveConfig();
        }
        this.compensationWindowMs = this.getConfig().getLong("compensation-window-ms", 500L);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        long elapsed;
        AxeHitData axeData;
        if (!this.enabled) {
            return;
        }
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        final Player attacker = (Player)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        final Player target = (Player)entity2;
        Material weapon = attacker.getInventory().getItemInMainHand().getType();
        if (this.isAxe(weapon) && target.isBlocking()) {
            this.pendingAxeHits.put(attacker.getUniqueId(), new AxeHitData(target.getUniqueId(), System.currentTimeMillis()));
            new BukkitRunnable(){

                public void run() {
                    AxeHitData data = SmashThePing.this.pendingAxeHits.get(attacker.getUniqueId());
                    if (data != null && System.currentTimeMillis() - data.timestamp > SmashThePing.this.compensationWindowMs) {
                        SmashThePing.this.pendingAxeHits.remove(attacker.getUniqueId());
                    }
                }
            }.runTaskLater((Plugin)this, this.compensationWindowMs / 50L + 20L);
        }
        if (this.isMace(weapon) && (axeData = this.pendingAxeHits.get(attacker.getUniqueId())) != null && axeData.targetUUID.equals(target.getUniqueId()) && (elapsed = System.currentTimeMillis() - axeData.timestamp) <= this.compensationWindowMs) {
            target.setNoDamageTicks(0);
            target.setMaximumNoDamageTicks(0);
            new BukkitRunnable(this){

                public void run() {
                    target.setMaximumNoDamageTicks(20);
                }
            }.runTaskLater((Plugin)this, 1L);
            this.getLogger().info(String.format("Stun-slam allowed for %s -> %s (elapsed: %dms)", attacker.getName(), target.getName(), elapsed));
            this.pendingAxeHits.remove(attacker.getUniqueId());
        }
    }

    private boolean isAxe(Material material) {
        return material == Material.WOODEN_AXE || material == Material.STONE_AXE || material == Material.IRON_AXE || material == Material.GOLDEN_AXE || material == Material.DIAMOND_AXE || material == Material.NETHERITE_AXE;
    }

    private boolean isMace(Material material) {
        try {
            return material == Material.valueOf((String)"MACE");
        }
        catch (IllegalArgumentException e) {
            return material == Material.IRON_HOE || material == Material.DIAMOND_HOE || material == Material.NETHERITE_HOE;
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("smashping.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (command.getName().equalsIgnoreCase("smashping")) {
            if (args.length == 0) {
                sender.sendMessage("\u00a76SmashThePing Commands:");
                sender.sendMessage("\u00a7e/smashping toggle \u00a77- Enable/disable ping compensation");
                sender.sendMessage("\u00a7e/smashping set <ms> \u00a77- Set compensation window (current: " + this.compensationWindowMs + "ms)");
                sender.sendMessage("\u00a7e/smashping info \u00a77- Show current settings");
                return true;
            }
            if (args[0].equalsIgnoreCase("toggle")) {
                this.enabled = !this.enabled;
                sender.sendMessage("\u00a7aStun-slam ping compensation is now " + (this.enabled ? "\u00a72enabled" : "\u00a7cdisabled"));
                return true;
            }
            if (args[0].equalsIgnoreCase("set") && args.length == 2) {
                try {
                    long newWindow = Long.parseLong(args[1]);
                    if (newWindow < 0L || newWindow > 2000L) {
                        sender.sendMessage("\u00a7cCompensation window must be between 0-2000ms");
                        return true;
                    }
                    this.compensationWindowMs = newWindow;
                    this.getConfig().set("compensation-window-ms", (Object)this.compensationWindowMs);
                    this.saveConfig();
                    sender.sendMessage("\u00a7aCompensation window set to \u00a72" + this.compensationWindowMs + "ms");
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage("\u00a7cInvalid number!");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("info")) {
                sender.sendMessage("\u00a76=== SmashThePing Info ===");
                sender.sendMessage("\u00a7eStatus: " + (this.enabled ? "\u00a72Enabled" : "\u00a7cDisabled"));
                sender.sendMessage("\u00a7eCompensation Window: \u00a7f" + this.compensationWindowMs + "ms");
                sender.sendMessage("\u00a7ePending Combos: \u00a7f" + this.pendingAxeHits.size());
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("smashping")) {
            return null;
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>();
            for (String subCmd : List.of("toggle", "set", "info")) {
                if (!subCmd.startsWith(input)) continue;
                completions.add(subCmd);
            }
            return completions;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
            String input = args[1];
            ArrayList<String> completions = new ArrayList<String>();
            for (String ping : List.of("50", "100", "150", "200", "250", "300", "400", "500", "750", "1000")) {
                if (!ping.startsWith(input)) continue;
                completions.add(ping);
            }
            return completions;
        }
        return new ArrayList<String>();
    }

    private static class AxeHitData {
        final UUID targetUUID;
        final long timestamp;

        AxeHitData(UUID targetUUID, long timestamp) {
            this.targetUUID = targetUUID;
            this.timestamp = timestamp;
        }
    }
}

