# SmashThePing

**Level the playing field for stun-slam combos in Minecraft PvP!**

SmashThePing is a server-side plugin that normalizes ping for the stun-slam combat technique, allowing high-ping players to execute combos as effectively as low-ping players.

## 🎯 What is a Stun-Slam?

A **stun-slam** is a powerful PvP combo where you:
1. Hit an opponent's shield with an **axe** to stun/disable it
2. Immediately follow up with a **mace** smash attack while they're vulnerable

Normally, this combo is extremely ping-dependent - players with 20ms ping can execute it flawlessly, while players with 200-500ms struggle to land the follow-up before the target's invulnerability frames reset.

## ✨ Features

- **🌍 Ping Normalization**: Gives all players an equal time window to execute stun-slam combos
- **⚙️ Configurable Window**: Adjust the compensation window from 50ms to 2000ms
- **🎮 Universal Compatibility**: Works on Paper/Spigot 1.19+ servers
- **🔧 Easy Commands**: Simple commands with tab completion
- **📊 Real-time Tracking**: Monitor active combos with `/smashping info`
- **🚫 Toggle On/Off**: Enable or disable compensation without restarting

## 📦 Installation

1. Download the latest `.jar` file
2. Place it in your server's `plugins` folder
3. Start/restart your server
4. Configure with `/smashping set <ms>` (default: 500ms)

## 🎮 Commands

| Command | Description | Example |
|---------|-------------|---------|
| `/smashping` | Show all available commands | `/smashping` |
| `/smashping toggle` | Enable/disable ping compensation | `/smashping toggle` |
| `/smashping set <ms>` | Set compensation window in milliseconds | `/smashping set 300` |
| `/smashping info` | View current settings and active combos | `/smashping info` |

**Aliases:** `/sping`, `/stunping`

**Tab Completion:** All commands and values support tab completion for easy configuration!

## ⚙️ Configuration

The plugin creates a `config.yml` file automatically:

```yaml
compensation-window-ms: 500
```

- **Default:** 500ms (half a second)
- **Recommended Range:** 200-500ms for most servers
- **Minimum:** 50ms
- **Maximum:** 2000ms

### Choosing the Right Value

- **Low ping server (most players <100ms):** Use 200-300ms
- **Mixed ping server:** Use 400-500ms
- **High ping server (international players):** Use 500-750ms

## 🔧 How It Works

1. Plugin detects when a player hits a blocking opponent with an axe
2. Records the timestamp of this "shield stun" hit
3. When the same player follows up with a mace within the configured window, the plugin temporarily removes the target's invulnerability frames
4. The mace hit connects successfully, regardless of the attacker's actual network latency

**Result:** A 500ms ping player can execute stun-slams just as effectively as a 20ms ping player!

## 🛠️ Technical Details

- **Server-side only** - no client mods required
- **Lightweight** - minimal performance impact
- **Compatible with:** Paper, Spigot, Purpur (1.19+)
- **Supports all axe types:** Wooden, Stone, Iron, Gold, Diamond, Netherite
- **Mace detection:** Works with actual Mace items (1.21+) or falls back to hoes on older versions

## 📊 Example Use Cases

### Scenario 1: International Server
Players from Europe (50ms) and Asia (300ms) play together. With SmashThePing set to 500ms, both can execute stun-slams equally.

### Scenario 2: Tournament Server
Level the playing field by ensuring all participants have the same combo timing window, making skill more important than ping.

### Scenario 3: Practice Server
Help players practice stun-slam timing without worrying about their connection quality.

## 🐛 Troubleshooting

**Commands don't work?**
- Make sure you have operator permissions
- Check that the plugin loaded successfully in console

**Combo not triggering?**
- Ensure you're hitting a blocking player with an axe first
- Check your compensation window isn't too low (`/smashping info`)
- Verify the plugin is enabled (`/smashping toggle`)

**Performance issues?**
- SmashThePing is very lightweight, but if you notice issues, lower the compensation window

## 📝 Permissions

By default, all players can use the plugin. To restrict commands, add to your permissions plugin:

```yaml
smashping.admin  # Allows using all /smashping commands
```



## 📜 License

This plugin is close source. Feel free but not decompile, change .

---

**Made with ❤️ for the Minecraft PvP community By Frqme**

*Stop letting ping decide your fights - let skill shine through!*