/*
 * Decompiled with CFR 0.152.
 */
package com.mc.adminop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class AdminOP
extends JavaPlugin {
    private FileConfiguration config;
    private Logger logger;
    private final Map<UUID, AdminLevel> adminPlayers = new HashMap<UUID, AdminLevel>();
    private final List<String> seedCollection = new ArrayList<String>();
    private LuckPerms luckPermsApi;
    private boolean luckPermsEnabled = false;
    private String prefix;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.logger = this.getLogger();
        this.prefix = this.config.getString("messages.prefix", "&8[&bAdminOP&8]&r");
        this.getCommand("admin").setExecutor(this);
        this.getCommand("unadmin").setExecutor(this);
        this.getCommand("adminlist").setExecutor(this);
        this.getCommand("adminreload").setExecutor(this);
        this.getCommand("adminseed").setExecutor(this);
        this.setupLuckPerms();
        this.loadSeeds();
        if (this.config.getBoolean("persistence.enabled")) {
            this.loadAdminPlayers();
        }
        this.logger.info("AdminOP has been enabled successfully!");
        if (this.luckPermsEnabled) {
            this.logger.info("LuckPerms integration enabled!");
        } else {
            this.logger.info("LuckPerms not detected. Permission integration is disabled.");
        }
    }

    private boolean setupLuckPerms() {
        if (this.getServer().getPluginManager().getPlugin("LuckPerms") == null) {
            return false;
        }
        RegisteredServiceProvider<LuckPerms> provider = this.getServer().getServicesManager().getRegistration(LuckPerms.class);
        if (provider != null) {
            this.luckPermsApi = provider.getProvider();
            this.luckPermsEnabled = true;
            return true;
        }
        return false;
    }

    @Override
    public void onDisable() {
        if (this.config.getBoolean("persistence.enabled")) {
            this.saveAdminPlayers();
        }
        this.logger.info("AdminOP has been disabled!");
    }

    private void loadSeeds() {
        this.seedCollection.clear();
        List<String> seeds = this.config.getStringList("seeds");
        this.seedCollection.addAll(seeds);
    }

    private void loadAdminPlayers() {
        this.adminPlayers.clear();
        if (this.config.getConfigurationSection("admins") != null) {
            for (String uuid : this.config.getConfigurationSection("admins").getKeys(false)) {
                String levelStr = this.config.getString("admins." + uuid);
                try {
                    AdminLevel level = AdminLevel.valueOf(levelStr);
                    this.adminPlayers.put(UUID.fromString(uuid), level);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warning("Invalid admin level for " + uuid + ": " + levelStr);
                }
            }
        }
        this.logger.info("Loaded " + this.adminPlayers.size() + " admin players.");
    }

    private void saveAdminPlayers() {
        for (Map.Entry<UUID, AdminLevel> entry : this.adminPlayers.entrySet()) {
            this.config.set("admins." + entry.getKey().toString(), entry.getValue().name());
        }
        this.saveConfig();
        this.logger.info("Saved " + this.adminPlayers.size() + " admin players.");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("admin")) {
            return this.handleAdminCommand(sender, args);
        }
        if (cmd.getName().equalsIgnoreCase("unadmin")) {
            return this.handleUnadminCommand(sender, args);
        }
        if (cmd.getName().equalsIgnoreCase("adminlist")) {
            return this.handleAdminListCommand(sender);
        }
        if (cmd.getName().equalsIgnoreCase("adminreload")) {
            return this.handleAdminReloadCommand(sender);
        }
        if (cmd.getName().equalsIgnoreCase("adminseed")) {
            return this.handleAdminSeedCommand(sender);
        }
        return false;
    }

    private boolean handleAdminCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("adminop.admin")) {
            sender.sendMessage(this.formatMessage("no-permission"));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.formatMessage("admin-usage"));
            return true;
        }
        Player target = this.getServer().getPlayer(args[0]);
        if (target == null) {
            sender.sendMessage(this.formatMessage("player-not-found").replace("%player%", args[0]));
            return true;
        }
        AdminLevel level = AdminLevel.STANDARD;
        if (args.length >= 2) {
            try {
                level = AdminLevel.valueOf(args[1].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(this.formatMessage("invalid-level").replace("%level%", args[1]));
                return true;
            }
        }
        this.adminPlayers.put(target.getUniqueId(), level);
        if (this.config.getBoolean("vanilla-op.enabled")) {
            target.setOp(true);
        }
        if (this.config.getBoolean("permissions.integrate") && this.luckPermsEnabled) {
            this.applyPermissions(target, level);
        }
        if (this.config.getBoolean("messages.broadcast-admin")) {
            String broadcastMsg = this.formatMessage("admin-broadcast").replace("%player%", target.getName()).replace("%level%", level.name());
            this.getServer().broadcastMessage(broadcastMsg);
        } else {
            sender.sendMessage(this.formatMessage("admin-success").replace("%player%", target.getName()).replace("%level%", level.name()));
            target.sendMessage(this.formatMessage("admin-received").replace("%level%", level.name()));
        }
        if (this.config.getBoolean("effects.enabled")) {
            this.applyAdminEffect(target);
        }
        return true;
    }

    private boolean handleUnadminCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("adminop.unadmin")) {
            sender.sendMessage(this.formatMessage("no-permission"));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.formatMessage("unadmin-usage"));
            return true;
        }
        Player target = this.getServer().getPlayer(args[0]);
        if (target == null) {
            sender.sendMessage(this.formatMessage("player-not-found").replace("%player%", args[0]));
            return true;
        }
        this.adminPlayers.remove(target.getUniqueId());
        if (this.config.getBoolean("vanilla-op.enabled")) {
            target.setOp(false);
        }
        if (this.config.getBoolean("permissions.integrate") && this.luckPermsEnabled) {
            this.removePermissions(target);
        }
        if (this.config.getBoolean("messages.broadcast-unadmin")) {
            String broadcastMsg = this.formatMessage("unadmin-broadcast").replace("%player%", target.getName());
            this.getServer().broadcastMessage(broadcastMsg);
        } else {
            sender.sendMessage(this.formatMessage("unadmin-success").replace("%player%", target.getName()));
            target.sendMessage(this.formatMessage("unadmin-received"));
        }
        return true;
    }

    private boolean handleAdminListCommand(CommandSender sender) {
        if (!sender.hasPermission("adminop.list")) {
            sender.sendMessage(this.formatMessage("no-permission"));
            return true;
        }
        sender.sendMessage(this.formatMessage("admin-list-header"));
        if (this.adminPlayers.isEmpty()) {
            sender.sendMessage(this.formatMessage("admin-list-empty"));
            return true;
        }
        for (Map.Entry<UUID, AdminLevel> entry : this.adminPlayers.entrySet()) {
            Player player = this.getServer().getPlayer(entry.getKey());
            String name = player != null ? player.getName() : "Offline player";
            sender.sendMessage(this.formatMessage("admin-list-entry").replace("%player%", name).replace("%level%", entry.getValue().name()).replace("%status%", player != null ? "Online" : "Offline"));
        }
        return true;
    }

    private boolean handleAdminReloadCommand(CommandSender sender) {
        if (!sender.hasPermission("adminop.reload")) {
            sender.sendMessage(this.formatMessage("no-permission"));
            return true;
        }
        this.reloadConfig();
        this.config = this.getConfig();
        this.prefix = this.config.getString("messages.prefix", "&8[&bAdminOP&8]&r");
        this.loadSeeds();
        if (this.config.getBoolean("persistence.enabled")) {
            this.loadAdminPlayers();
        }
        sender.sendMessage(this.formatMessage("config-reloaded"));
        return true;
    }

    private boolean handleAdminSeedCommand(CommandSender sender) {
        if (!sender.hasPermission("adminop.seed")) {
            sender.sendMessage(this.formatMessage("no-permission"));
            return true;
        }
        if (this.seedCollection.isEmpty()) {
            sender.sendMessage(this.formatMessage("seed-empty"));
            return true;
        }
        int index = (int)(Math.random() * (double)this.seedCollection.size());
        String seed = this.seedCollection.get(index);
        sender.sendMessage(this.formatMessage("seed-header"));
        sender.sendMessage(this.formatMessage("seed-value").replace("%seed%", seed));
        return true;
    }

    private void applyPermissions(Player player, AdminLevel level) {
        if (!this.luckPermsEnabled) {
            this.logger.warning("Attempted to apply permissions but LuckPerms is not available.");
            return;
        }
        try {
            User user = this.luckPermsApi.getUserManager().getUser(player.getUniqueId());
            if (user == null) {
                this.logger.warning("Could not find LuckPerms user for " + player.getName());
                return;
            }
            if (this.config.getBoolean("permissions.clear-previous")) {
                for (AdminLevel adminLevel : AdminLevel.values()) {
                    List<String> previousPerms = this.config.getStringList("permissions.levels." + adminLevel.name());
                    for (String perm : previousPerms) {
                        user.data().remove((Node)Node.builder((String)perm).build());
                        user.data().remove((Node)Node.builder((String)perm).value(false).build());
                    }
                }
            }
            List<String> permissions = this.config.getStringList("permissions.levels." + level.name());
            for (String perm : permissions) {
                user.data().add((Node)Node.builder((String)perm).build());
            }
            String groupName = this.config.getString("permissions.groups." + level.name());
            if (groupName != null && !groupName.isEmpty()) {
                user.data().add((Node)Node.builder((String)("group." + groupName)).build());
            }
            this.luckPermsApi.getUserManager().saveUser(user);
            this.logger.info("Applied permissions for level " + level.name() + " to " + player.getName());
        }
        catch (Exception e) {
            this.logger.severe("Error applying permissions to " + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void removePermissions(Player player) {
        if (!this.luckPermsEnabled) {
            this.logger.warning("Attempted to remove permissions but LuckPerms is not available.");
            return;
        }
        try {
            User user = this.luckPermsApi.getUserManager().getUser(player.getUniqueId());
            if (user == null) {
                this.logger.warning("Could not find LuckPerms user for " + player.getName());
                return;
            }
            for (AdminLevel level : AdminLevel.values()) {
                List<String> perms = this.config.getStringList("permissions.levels." + level.name());
                for (String perm : perms) {
                    user.data().remove((Node)Node.builder((String)perm).build());
                }
                String groupName = this.config.getString("permissions.groups." + level.name());
                if (groupName == null || groupName.isEmpty()) continue;
                user.data().remove((Node)Node.builder((String)("group." + groupName)).build());
            }
            String defaultGroup = this.config.getString("permissions.default-group");
            if (defaultGroup != null && !defaultGroup.isEmpty()) {
                user.data().add((Node)Node.builder((String)("group." + defaultGroup)).build());
            }
            this.luckPermsApi.getUserManager().saveUser(user);
            this.logger.info("Removed admin permissions from " + player.getName());
        }
        catch (Exception e) {
            this.logger.severe("Error removing permissions from " + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void applyAdminEffect(Player player) {
        player.getWorld().strikeLightningEffect(player.getLocation());
    }

    private String formatMessage(String path) {
        String message = this.config.getString("messages." + path, "Missing message: " + path);
        message = message.replace("%prefix%", this.prefix);
        return ChatColor.translateAlternateColorCodes('&', message);
    }

    public static enum AdminLevel {
        JUNIOR(1),
        STANDARD(2),
        SENIOR(3),
        OWNER(4);

        private final int level;

        private AdminLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

