/*
 * Decompiled with CFR 0.152.
 */
package modernmarkings.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import modernmarkings.blocks.BlockBase;
import modernmarkings.init.ModBlocks;
import modernmarkings.init.ModRenderers;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MarkingWall
extends BlockBase {
    private static final AxisAlignedBB BOUNDING_BOX_S = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0E-4);
    private static final AxisAlignedBB BOUNDING_BOX_W = AxisAlignedBB.func_72330_a((double)0.9999, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final AxisAlignedBB BOUNDING_BOX_N = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.9999, (double)1.0, (double)1.0, (double)1.0);
    private static final AxisAlignedBB BOUNDING_BOX_E = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0E-4, (double)1.0, (double)1.0);

    public MarkingWall(String name, String textureName) {
        super(name, textureName);
        ModBlocks.WALL_BLOCKS.add(this);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        if (side != 0 && side != 1) {
            return side;
        }
        return this.getDirectionFromPlacedPlayer(world, x, y, z);
    }

    private int getDirectionFromPlacedPlayer(World world, int x, int y, int z) {
        EntityPlayer player = world.func_72977_a((double)x, (double)y, (double)z, -1.0);
        float yaw = player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        int rotation = MathHelper.func_76128_c((double)((double)(yaw * 4.0f / 360.0f) + 0.5)) & 3;
        switch (rotation) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 5;
            }
        }
        throw new RuntimeException("rotation wasn't 0<x<4 " + rotation);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 2: {
                return AxisAlignedBB.func_72330_a((double)((double)x + MarkingWall.BOUNDING_BOX_N.field_72340_a), (double)((double)y + MarkingWall.BOUNDING_BOX_N.field_72338_b), (double)((double)z + MarkingWall.BOUNDING_BOX_N.field_72339_c), (double)((double)x + MarkingWall.BOUNDING_BOX_N.field_72336_d), (double)((double)y + MarkingWall.BOUNDING_BOX_N.field_72337_e), (double)((double)z + MarkingWall.BOUNDING_BOX_N.field_72334_f));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)((double)x + MarkingWall.BOUNDING_BOX_S.field_72340_a), (double)((double)y + MarkingWall.BOUNDING_BOX_S.field_72338_b), (double)((double)z + MarkingWall.BOUNDING_BOX_S.field_72339_c), (double)((double)x + MarkingWall.BOUNDING_BOX_S.field_72336_d), (double)((double)y + MarkingWall.BOUNDING_BOX_S.field_72337_e), (double)((double)z + MarkingWall.BOUNDING_BOX_S.field_72334_f));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)((double)x + MarkingWall.BOUNDING_BOX_W.field_72340_a), (double)((double)y + MarkingWall.BOUNDING_BOX_W.field_72338_b), (double)((double)z + MarkingWall.BOUNDING_BOX_W.field_72339_c), (double)((double)x + MarkingWall.BOUNDING_BOX_W.field_72336_d), (double)((double)y + MarkingWall.BOUNDING_BOX_W.field_72337_e), (double)((double)z + MarkingWall.BOUNDING_BOX_W.field_72334_f));
            }
            case 5: {
                return AxisAlignedBB.func_72330_a((double)((double)x + MarkingWall.BOUNDING_BOX_E.field_72340_a), (double)((double)y + MarkingWall.BOUNDING_BOX_E.field_72338_b), (double)((double)z + MarkingWall.BOUNDING_BOX_E.field_72339_c), (double)((double)x + MarkingWall.BOUNDING_BOX_E.field_72336_d), (double)((double)y + MarkingWall.BOUNDING_BOX_E.field_72337_e), (double)((double)z + MarkingWall.BOUNDING_BOX_E.field_72334_f));
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    public AxisAlignedBB func_149668_a(World worldIn, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return ModRenderers.renderMarkingWallID;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (!super.func_149742_c(world, x, y, z)) {
            return false;
        }
        int direction = this.getDirectionFromPlacedPlayer(world, x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)direction);
        return world.isSideSolid(x + dir.offsetX, y, z + dir.offsetZ, dir, false);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta).getOpposite();
        if (!world.isSideSolid(x + dir.offsetX, y, z + dir.offsetZ, dir, false)) {
            world.func_147468_f(x, y, z);
            this.func_149697_b(world, x, y, z, 0, 0);
        }
        super.func_149695_a(world, x, y, z, neighbor);
    }
}

