/*
 * Decompiled with CFR 0.152.
 */
package dev.lycanea.mwonmod;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.dfonline.flint.Flint;
import dev.dfonline.flint.FlintAPI;
import dev.dfonline.flint.hypercube.Mode;
import dev.lycanea.mwonmod.Config;
import dev.lycanea.mwonmod.events.AttackEvent;
import dev.lycanea.mwonmod.events.SellEvent;
import dev.lycanea.mwonmod.music.CustomMusicManager;
import dev.lycanea.mwonmod.util.Commands;
import dev.lycanea.mwonmod.util.GameState;
import dev.lycanea.mwonmod.util.InventoryScanResult;
import dev.lycanea.mwonmod.util.ItemUtils;
import dev.lycanea.mwonmod.util.KeyBindings;
import dev.lycanea.mwonmod.util.TimeUtils;
import dev.lycanea.mwonmod.util.discord.DiscordManager;
import dev.lycanea.mwonmod.util.region.Region;
import dev.lycanea.mwonmod.util.region.RegionLoader;
import dev.lycanea.mwonmod.util.region.RegionRenderer;
import dev.lycanea.mwonmod.util.region.RegionUpdater;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mwonmod
implements ClientModInitializer {
    public static final String MOD_ID = "mwonmod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mwonmod");
    public static class_310 MC = class_310.method_1551();
    public static Boolean inventory_rundown = false;
    private static final String ITEM_DATA_PATH = "assets/mwonmod/data/items.json";
    private static final String UPGRADES_PATH = "assets/mwonmod/data/melonmod_upgrades.json";
    public static JsonObject itemData;
    public static Map<String, String> upgradeData;
    private static boolean auctionNotificationSent;
    public static Region activeRegion;
    public static List<String> players;

    public void onInitializeClient() {
        Config.HANDLER.load();
        JsonObject upgrade_dataJson = Mwonmod.loadJsonFile(UPGRADES_PATH);
        upgradeData = new HashMap<String, String>();
        if (upgrade_dataJson != null) {
            for (String key : upgrade_dataJson.keySet()) {
                upgradeData.put(key, upgrade_dataJson.get(key).getAsString());
            }
        }
        itemData = Mwonmod.loadJsonFile(ITEM_DATA_PATH);
        RegionLoader.init();
        RegionRenderer.init();
        RegionUpdater.init();
        FlintAPI.confirmLocationWithLocate();
        KeyBindings.setup();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            DiscordManager.updateStatus();
            if (client.field_1724 != null && client.field_1724.method_5781() != null && Mwonmod.onMelonKing()) {
                List<String> playerJoins = client.field_1724.method_5781().method_1204().stream().filter(item -> !players.contains(item)).toList();
                List<String> playerLeaves = players.stream().filter(item -> !client.field_1724.method_5781().method_1204().stream().toList().contains(item)).toList();
                if (!playerJoins.isEmpty()) {
                    client.field_1724.method_7353((class_2561)class_2561.method_30163((String)("Player Join: " + playerJoins.getFirst())).method_27661().method_27692(class_124.field_1075), false);
                }
                if (!playerLeaves.isEmpty()) {
                    client.field_1724.method_7353((class_2561)class_2561.method_30163((String)("Player Leave: " + playerLeaves.getFirst())).method_27661().method_27692(class_124.field_1061), false);
                }
                players = client.field_1724.method_5781().method_1204().stream().toList();
            }
            CustomMusicManager.tick(client);
        });
        UseEntityCallback.EVENT.register(SellEvent::entityInteract);
        AttackEntityCallback.EVENT.register(AttackEvent::entityAttack);
        DiscordManager.initialise();
        ClientCommandRegistrationCallback.EVENT.register(Commands::registerCommands);
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.CROSSHAIR, (class_2960)class_2960.method_60654((String)"mwonmod:overlay"), (context, tickCounter) -> this.renderHUDOverlay(context));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject loadJsonFile(String PATH) {
        JsonObject ret = null;
        try (InputStream stream = Mwonmod.class.getClassLoader().getResourceAsStream(PATH);){
            if (stream == null) {
                LOGGER.error("Could not find data file: assets/mwonmod/data/melonmod_upgrades.json");
                JsonObject jsonObject = null;
                return jsonObject;
            }
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (jsonElement.isJsonObject()) {
                LOGGER.info("Successfully loaded data from: assets/mwonmod/data/melonmod_upgrades.json");
                ret = jsonElement.getAsJsonObject();
                return ret;
            }
            LOGGER.error("Data file is not a JSON object: assets/mwonmod/data/melonmod_upgrades.json");
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error loading data from: assets/mwonmod/data/melonmod_upgrades.json");
        }
        return ret;
    }

    private void renderHUDOverlay(class_332 context) {
        class_310 client = class_310.method_1551();
        if (((Config)Config.HANDLER.instance()).debugMode) {
            ArrayList<CallSite> debugLines = new ArrayList<CallSite>(List.of("DEBUG MODE", "ON MWON: " + Mwonmod.onMelonKing(), "ON BETA: " + GameState.beta_plot));
            if (GameState.housing_pos != null) {
                debugLines.add((CallSite)((Object)("HOUSING LOCATION: " + String.valueOf(GameState.housing_pos))));
            }
            if (GameState.currentPath != null) {
                debugLines.add((CallSite)((Object)("CURRENT PATH: " + GameState.currentPath)));
            }
            if (GameState.currentMonarch != null) {
                debugLines.add((CallSite)((Object)("CURRENT MONARCH: " + GameState.currentMonarch)));
            }
            if (GameState.coins != null) {
                debugLines.add((CallSite)((Object)("CURRENT COINS: " + String.valueOf(GameState.coins))));
            }
            if (GameState.bank_gold != null) {
                debugLines.add((CallSite)((Object)("CURRENT BANK GOLD: " + String.valueOf(GameState.bank_gold))));
            }
            if (GameState.playerLocation != null) {
                debugLines.add((CallSite)((Object)("CURRENT LOCATION: " + GameState.playerLocation)));
            }
            if (GameState.personal_bank != null) {
                debugLines.add((CallSite)((Object)("CURRENT PERSONAL BANK: " + GameState.personal_bank)));
            }
            if (GameState.medals != null) {
                debugLines.add((CallSite)((Object)("CURRENT MEDALS: " + GameState.medals)));
            }
            if (GameState.trophies != null) {
                debugLines.add((CallSite)((Object)("CURRENT TROPHIES: " + GameState.trophies)));
            }
            if (GameState.karma != null) {
                debugLines.add((CallSite)((Object)("CURRENT KARMA: " + GameState.karma)));
            }
            if (GameState.melonJoin != null) {
                debugLines.add((CallSite)((Object)("MWON TIMER: " + Duration.between(GameState.melonJoin, LocalDateTime.now()).getSeconds())));
            }
            assert (class_310.method_1551().field_1724 != null);
            class_2338 pos = class_310.method_1551().field_1724.method_24515().method_10069(-RegionLoader.plot_origin.x, 0, -RegionLoader.plot_origin.y);
            if (GameState.beta_plot) {
                pos = class_310.method_1551().field_1724.method_24515().method_10069(-RegionLoader.beta_plot_origin.x, 0, -RegionLoader.beta_plot_origin.y);
            }
            debugLines.add((CallSite)((Object)("PLOTSPACE POS: " + String.valueOf(pos))));
            int startY = context.method_51443() - 390;
            this.drawDebugLines(context, client, debugLines, startY, 10, -8210451);
        }
        if (client.field_1724 != null && client.field_1687 != null && Mwonmod.onMelonKing()) {
            long auctionwaitMillis = TimeUtils.auctionTime();
            if (!auctionNotificationSent && auctionwaitMillis <= 30000L) {
                if (((Config)Config.HANDLER.instance()).auctionDesktopNotification) {
                    Mwonmod.notification("Auction Alert", "There is an auction in 30 seconds.");
                }
                if (((Config)Config.HANDLER.instance()).auctionTitleNotification) {
                    client.field_1724.showTitle(Title.title((Component)Component.text((String)"There is an auction in 30 seconds."), (Component)Component.text((String)"")));
                }
                auctionNotificationSent = true;
            }
            if (auctionNotificationSent && auctionwaitMillis > 30000L) {
                auctionNotificationSent = false;
            }
            if (((Config)Config.HANDLER.instance()).auctionTimer) {
                long auctionminutes = auctionwaitMillis / 60000L;
                long auctionseconds = auctionwaitMillis % 60000L / 1000L;
                context.method_25303(client.field_1772, String.format("Next Auction:  00:%02d:%02d", auctionminutes, auctionseconds), 3, 3, 0xFFFFFF);
            }
            if (((Config)Config.HANDLER.instance()).flawlessTimer) {
                long flawlessWait = TimeUtils.flawlessTime();
                if (flawlessWait < 4428L) {
                    context.method_25303(client.field_1772, String.format("Next Flawless: %02d:%02d:%02d", flawlessWait / 60L / 60L, (flawlessWait + 1L) / 60L % 60L, (flawlessWait + 1L) % 60L), 3, 12, 0xFFFFFF);
                } else {
                    context.method_25303(client.field_1772, "Next Flawless: Now", 3, 12, 0xFFFFFF);
                }
            }
        }
        if (client.field_1724 != null && client.field_1687 != null && Mwonmod.onMelonKing() && inventory_rundown.booleanValue()) {
            int barX = client.method_22683().method_4486() / 2 - 50;
            int barY = client.method_22683().method_4502() - 90;
            int barWidth = 100;
            int barHeight = 6;
            Map<String, Integer> items = Map.of("gold", -7936, "shard", -16733441, "compressed_shard", -16750885, "melon", -16711869, "enchanted_melon", -16728270, "super_enchanted_melon", -16741852);
            InventoryScanResult result = Mwonmod.scanInventory((class_1657)client.field_1724, items.keySet().stream().toList());
            double emptyPercent = (double)result.emptySlots() / 36.0;
            double emptyWidth = (double)barWidth * emptyPercent;
            context.method_25294(barX - 1, barY - 1, barX + 1 + barWidth, barY + 1 + barHeight, -16777216);
            context.method_25294(barX, barY, barX + barWidth, barY + barHeight, -11184811);
            context.method_25294(barX, barY, (int)((double)barX + emptyWidth), barY + barHeight, -7829368);
            double offset = emptyWidth;
            for (Map.Entry<String, Integer> entry : items.entrySet()) {
                double percent = (double)result.itemSlots().get(entry.getKey()).intValue() / 36.0;
                double width = (double)barWidth * percent;
                context.method_25294((int)((double)barX + offset), barY, (int)((double)barX + offset + width), barY + barHeight, entry.getValue().intValue());
                offset += width;
            }
        }
        if (client.method_22683() == null) {
            return;
        }
        if (client.field_1724 == null) {
            return;
        }
        if (client.field_1687 == null) {
            return;
        }
        if (((Config)Config.HANDLER.instance()).signUpgradeTooltip && Mwonmod.onMelonKing()) {
            class_243 hit = client.field_1724.method_5745(4.5, 0.0f, false).method_17784();
            String vecKey = Mwonmod.serializeVec(hit);
            class_2586 state = client.field_1687.method_8321(new class_2338((int)hit.field_1352, (int)hit.field_1351, (int)hit.field_1350).method_10059(new class_2382(GameState.beta_plot ? 0 : 1, 0, GameState.beta_plot ? 0 : 1)));
            ArrayList<Object> signTooltip = new ArrayList();
            if (state instanceof class_2625) {
                class_2625 signBlock = (class_2625)state;
                for (class_2561[] textList : new class_2561[][]{signBlock.method_49853().method_49877(true), signBlock.method_49854().method_49877(true)}) {
                    if (textList.length != 4 || textList[0].getString().trim().isEmpty()) continue;
                    String top = textList[0].getString().trim();
                    Object m = textList[1].getString().trim();
                    String m2 = textList[2].getString().trim();
                    if (textList[3].getString().contains("Reserve")) {
                        return;
                    }
                    if (!m2.isEmpty()) {
                        m = (String)m + " " + m2;
                    }
                    if (((String)m).contains("City Improvement:")) {
                        m = m2;
                    }
                    int color = 0xFFFFFF;
                    if (top.equals("[Right Click]")) {
                        color = 16571245;
                    }
                    if (top.equals("Bought!")) {
                        color = -16711936;
                    }
                    if (top.equals("Can't Buy") || Pattern.compile(".\\d/.\\d").matcher(top).find()) {
                        color = -2142128;
                    }
                    if (top.equals("Locked") || top.equals("Locked!") || top.equals("Path Locked!") || top.equals("Disabled")) {
                        color = -65536;
                    }
                    Object mkey = m;
                    if (((String)m).equals("Upgrade Town")) {
                        mkey = (String)m + vecKey;
                    }
                    if (!upgradeData.containsKey(mkey)) {
                        return;
                    }
                    String upgradeDesc = upgradeData.get(mkey);
                    upgradeDesc = upgradeDesc.replace(" queen ", " monarch ").replace(" king ", " monarch ");
                    List otList = Mwonmod.MC.field_1772.method_1728(class_5348.method_29430((String)upgradeDesc), client.method_22683().method_4486() / 3);
                    signTooltip = new ArrayList<class_5684>(List.of(class_5684.method_32662((class_5481)class_2561.method_43470((String)m).method_54663(color).method_30937())));
                    for (class_5481 t : otList) {
                        class_2561 nt = Mwonmod.convertOrderedTextToTextWithStyle(t);
                        signTooltip.add(class_5684.method_32662((class_5481)class_2561.method_43470((String)nt.getString()).method_54663(-6250336).method_30937()));
                    }
                }
            }
            if (!signTooltip.isEmpty()) {
                context.method_51435(client.field_1772, signTooltip, client.method_22683().method_4486() / 2, client.method_22683().method_4502() / 2, class_8001.field_41687, null);
            }
        }
    }

    private static String serializeVec(class_243 vec) {
        return "<" + (int)vec.field_1352 + ", " + (int)vec.field_1351 + ", " + (int)vec.field_1350 + ">";
    }

    public static class_2561 convertOrderedTextToTextWithStyle(class_5481 orderedText) {
        ArrayList<class_5250> components = new ArrayList<class_5250>();
        StringBuilder currentText = new StringBuilder();
        class_2583[] currentStyle = new class_2583[]{class_2583.field_24360};
        orderedText.accept((index, style, codePoint) -> {
            if (!style.equals((Object)currentStyle[0])) {
                if (!currentText.isEmpty()) {
                    components.add(class_2561.method_43470((String)currentText.toString()).method_10862(currentStyle[0]));
                    currentText.setLength(0);
                }
                currentStyle[0] = style;
            }
            currentText.appendCodePoint(codePoint);
            return true;
        });
        if (!currentText.isEmpty()) {
            components.add(class_2561.method_43470((String)currentText.toString()).method_10862(currentStyle[0]));
        }
        return class_2564.method_37112(components, (class_2561)class_2561.method_43473());
    }

    public static InventoryScanResult scanInventory(class_1657 player, List<String> itemsToCount) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        HashMap<String, Integer> slotCounts = new HashMap<String, Integer>();
        for (String item : itemsToCount) {
            counts.put(item, 0);
        }
        for (String item : itemsToCount) {
            slotCounts.put(item, 0);
        }
        int emptySlots = 0;
        for (class_1799 stack : player.method_31548().method_67533()) {
            if (stack.method_7960()) {
                ++emptySlots;
                continue;
            }
            String itemId = ItemUtils.getItemID(stack);
            if (!counts.containsKey(itemId)) continue;
            counts.put(itemId, (Integer)counts.get(itemId) + stack.method_7947());
            slotCounts.put(itemId, (Integer)slotCounts.get(itemId) + 1);
        }
        return new InventoryScanResult(counts, slotCounts, emptySlots);
    }

    public static boolean onMelonKing() {
        if (((Config)Config.HANDLER.instance()).ignoreMelonKingCheck) {
            return true;
        }
        if (Flint.getUser().getPlot() == null) {
            GameState.beta_plot = false;
            return false;
        }
        if (Flint.getUser().getMode() != Mode.PLAY) {
            return false;
        }
        GameState.beta_plot = Flint.getUser().getPlot().getId() == 202028;
        return Flint.getUser().getPlot().getId() == 22467 || Flint.getUser().getPlot().getId() == 202028;
    }

    public void drawDebugLines(class_332 context, class_310 client, List<String> lines, int startY, int lineSpacing, int color) {
        int maxWidth = 0;
        for (String line : lines) {
            maxWidth = Math.max(maxWidth, client.field_1772.method_1727(line));
        }
        context.method_25294(0, startY - 2, maxWidth + 4, startY + lines.size() * lineSpacing, -16777216);
        int y = startY;
        for (String line : lines) {
            context.method_51433(client.field_39924, line, 0, y, color, false);
            y += lineSpacing;
        }
    }

    public static void notification(String title, String message) {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        try {
            if (os.contains("nux") || os.contains("nix")) {
                InputStream iconStream = Mwonmod.class.getResourceAsStream("/assets/mwonmod/melon.png");
                if (iconStream == null) {
                    LOGGER.error("Icon resource not found.");
                    return;
                }
                Path tempIcon = Files.createTempFile("mwonmod-icon-", ".png", new FileAttribute[0]);
                Files.copy(iconStream, tempIcon, StandardCopyOption.REPLACE_EXISTING);
                iconStream.close();
                tempIcon.toFile().deleteOnExit();
                new ProcessBuilder("notify-send", "-i", tempIcon.toString(), title, message).inheritIO().start();
            } else if (SystemTray.isSupported()) {
                SystemTray tray = SystemTray.getSystemTray();
                Image icon = Toolkit.getDefaultToolkit().getImage(Mwonmod.class.getResource("/icon.png"));
                TrayIcon trayIcon = new TrayIcon(icon, "Mwonmod Notification");
                trayIcon.setImageAutoSize(true);
                tray.add(trayIcon);
                trayIcon.displayMessage(title, message, TrayIcon.MessageType.INFO);
            } else {
                LOGGER.error("SystemTray not supported; fallback here.");
            }
        }
        catch (AWTException | IOException e) {
            e.printStackTrace();
        }
    }

    public static void setActiveRegion(Region region) {
        activeRegion = region;
    }

    public static void clearActiveRegion() {
        activeRegion = null;
    }

    public static void expandActiveRegionTo(class_2382 pos) {
        activeRegion.expandTo(pos);
    }

    static {
        auctionNotificationSent = false;
        activeRegion = null;
        players = List.of();
    }
}

