/*
 * Decompiled with CFR 0.152.
 */
package dev.lycanea.mwonmod.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dfonline.flint.util.Toaster;
import dev.lycanea.mwonmod.Config;
import dev.lycanea.mwonmod.Mwonmod;
import dev.lycanea.mwonmod.util.GameState;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_3944;
import net.minecraft.class_7439;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2535.class})
public class OnPacketMixin {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Inject(method={"handlePacket"}, at={@At(value="HEAD")}, cancellable=true)
    private static <T extends class_2547> void onGameMessage(class_2596<T> packet, class_2547 listener, CallbackInfo ci) {
        if (packet instanceof class_7439) {
            boolean overlay;
            class_2561 content;
            class_7439 class_74392 = (class_7439)packet;
            try {
                boolean bl;
                class_2561 class_25612;
                content = class_25612 = class_74392.comp_763();
                overlay = bl = class_74392.comp_906();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            OnPacketMixin.handleChatPacket(content, overlay, ci);
        }
        if (!(packet instanceof class_3944)) return;
        class_3944 openScreenPacket = (class_3944)packet;
        if (!Mwonmod.onMelonKing()) return;
        class_2561 screenTitle = openScreenPacket.method_17594();
        Pattern bankPattern = Pattern.compile("Portable Bank \\| (\\d+)/10000 gold");
        Matcher bankMatcher = bankPattern.matcher(screenTitle.getString());
        if (!bankMatcher.find()) return;
        GameState.portable_bank = Integer.parseInt(bankMatcher.group(1));
    }

    @Unique
    private static void handleChatPacket(class_2561 content, boolean overlay, CallbackInfo ci) {
        String message = content.getString();
        Pattern melonJoinPattern = Pattern.compile("^\u00bb Joined game: < Melon King > \\((\\d(?:\\.\\d*)*|BETA)\\) by DeepSeaBlue\\.$");
        Matcher melonJoinMatcher = melonJoinPattern.matcher(message);
        if (melonJoinMatcher.find()) {
            String version = "(" + ((ModContainer)FabricLoader.getInstance().getModContainer("mwonmod").get()).getMetadata().getVersion().getFriendlyString() + ")";
            TextComponent versionComponent = Component.text((String)version, (Style)Style.style().color(TextColor.color((int)128, (int)128, (int)128)).decoration(TextDecoration.ITALIC, true).build());
            Style mainStyle = Style.style().color(TextColor.color((int)203, (int)64, (int)22)).build();
            Toaster.toast((Component)Component.text((String)"MwonMod"), (Component)((TextComponent)Component.text((String)"Using Alpha version ", (Style)mainStyle).append((Component)versionComponent)).append((Component)Component.text((String)", please report bugs on the Discord!", (Style)mainStyle)));
            GameState.melonJoin = LocalDateTime.now();
        }
        if (!Mwonmod.onMelonKing()) {
            return;
        }
        if (((Config)Config.HANDLER.instance()).hideSellFailMessage && Objects.equals(message, "> You don't have any Super Enchanted Melons. Get them by cooking four Enchanted Melon Slices, which are gotten by cooking four Melon Slices.")) {
            ci.cancel();
        }
        if (((Config)Config.HANDLER.instance()).what && Objects.equals(message, "> What?") && class_310.method_1551().field_1724 != null) {
            Mwonmod.notification("> What?", "> What?");
            class_310.method_1551().execute(() -> class_310.method_1551().field_1724.field_3944.method_45729("> What?"));
        }
        if (((Config)Config.HANDLER.instance()).down && Objects.equals(message, "> Down.") && class_310.method_1551().field_1724 != null) {
            Mwonmod.notification("> Down.", "> Down.");
            class_310.method_1551().execute(() -> class_310.method_1551().field_1724.field_3944.method_45729("> Down."));
        }
        Pattern auctionPattern = Pattern.compile("^>\\s*(?:First up,|And next,|Next,|And now,|And lastly,|Now,|Up next,)?\\s*(?:a|an|some)\\s+(.+?)!$");
        Pattern newKingPattern = Pattern.compile("^>\\s*([\\w]+)\\s+is\\s+the\\s+new\\s+(?:king|queen|monarch)!$");
        Matcher auctionMatcher = auctionPattern.matcher(message);
        Matcher kingMatcher = newKingPattern.matcher(message);
        if (auctionMatcher.find()) {
            assert (class_310.method_1551().field_1724 != null);
            if (((Config)Config.HANDLER.instance()).debugMode) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Auction Item: " + auctionMatcher.group(1))), false);
            }
            try {
                String itemKey = auctionMatcher.group(1).toLowerCase().replaceAll(" ", "_");
                JsonElement itemElement = Mwonmod.itemData.get(itemKey);
                if (itemElement == null) {
                    if (((Config)Config.HANDLER.instance()).debugMode) {
                        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Item data not found for: " + itemKey)), false);
                    }
                    return;
                }
                JsonObject itemData = itemElement.getAsJsonObject();
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Auction Item: " + itemData.get("name").getAsString())).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)itemData.get("description").getAsString())))), false);
            }
            catch (Exception e) {
                if (((Config)Config.HANDLER.instance()).debugMode) {
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Error accessing item data: " + e.getMessage())), false);
                }
            }
        } else if (kingMatcher.find()) {
            assert (class_310.method_1551().field_1724 != null);
            if (((Config)Config.HANDLER.instance()).kingChangeNotification) {
                GameState.currentMonarch = kingMatcher.group(1);
                Mwonmod.notification("New Monarch", kingMatcher.group(1));
            }
        }
    }
}

