/*
 * Decompiled with CFR 0.152.
 */
package dev.lycanea.mwonmod.util.discord;

import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import dev.lycanea.mwonmod.Config;
import dev.lycanea.mwonmod.Mwonmod;
import dev.lycanea.mwonmod.util.GameState;
import dev.lycanea.mwonmod.util.discord.DiscordListener;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class DiscordManager {
    public static IPCClient client;
    public static DiscordListener listener;
    public static boolean enabled;

    public static void initialise() {
        if (!enabled) {
            return;
        }
        if (client == null) {
            client = new IPCClient(1376119105136103496L);
            client.setListener((IPCListener)listener);
        }
        try {
            client.connect(new DiscordBuild[]{DiscordBuild.ANY});
            Mwonmod.LOGGER.info("Connected Discord Client");
        }
        catch (NoDiscordClientException e) {
            throw new RuntimeException("No Discord client found", e);
        }
    }

    public static void updateStatus() {
        if (GameState.melonJoin != null && ((Config)Config.HANDLER.instance()).discordRichPresence && Mwonmod.onMelonKing()) {
            DiscordManager.setEnabled(true);
            if (GameState.beta_plot) {
                DiscordManager.setStatus("On Beta Plot", "Playing around and breaking things", OffsetDateTime.of(GameState.melonJoin, ZoneOffset.systemDefault().getRules().getStandardOffset(Instant.now())), "melonbeta", "Running MwonMod " + (FabricLoader.getInstance().getModContainer("mwonmod").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Object::toString).orElse("0.0").equals("0.0.0") ? "Development" : FabricLoader.getInstance().getModContainer("mwonmod").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Object::toString).orElse("0.0")), "redactedpath", "REDACTED :3");
                return;
            }
            NumberFormat formatter = NumberFormat.getNumberInstance();
            String line1 = null;
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine1, "Coins/City Gold")) {
                String string = Objects.equals(GameState.currentPath, "Underground") || Objects.equals(GameState.currentPath, "Depths") ? "Gold: " + formatter.format(GameState.bank_gold != null ? (Number)GameState.bank_gold : (Number)0) : (line1 = "Coins: " + formatter.format(GameState.coins != null ? (Number)GameState.coins : (Number)0));
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine1, "Path")) {
                line1 = "Path: " + GameState.currentPath;
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine1, "Monarch")) {
                line1 = "Monarch: " + GameState.currentMonarch;
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine1, "Location")) {
                String string = line1 = GameState.playerLocation == null ? null : "Location: " + (GameState.playerLocation.substring(0, 1).toUpperCase() + GameState.playerLocation.substring(1)).replace("_", " ");
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine1, "Personal Gold")) {
                String string = line1 = GameState.personal_bank == null ? null : "Personal Gold: " + formatter.format(GameState.personal_bank);
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine1, "Medals")) {
                String string = line1 = GameState.medals == null ? null : "Medals: " + formatter.format(GameState.medals);
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine1, "Trophies")) {
                String string = line1 = GameState.trophies == null ? null : "Trophies: " + formatter.format(GameState.trophies);
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine1, "Karma")) {
                line1 = GameState.karma == null ? null : "Karma: " + formatter.format(GameState.karma);
            }
            String line2 = null;
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine2, "Coins/City Gold")) {
                String string = Objects.equals(GameState.currentPath, "Underground") || Objects.equals(GameState.currentPath, "Depths") ? "Gold: " + formatter.format(GameState.bank_gold != null ? (Number)GameState.bank_gold : (Number)0) : (line2 = "Coins: " + formatter.format(GameState.coins != null ? (Number)GameState.coins : (Number)0));
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine2, "Path")) {
                line2 = "Path: " + GameState.currentPath;
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine2, "Monarch")) {
                line2 = "Monarch: " + GameState.currentMonarch;
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine2, "Location")) {
                String string = line2 = GameState.playerLocation == null ? null : "Location: " + (GameState.playerLocation.substring(0, 1).toUpperCase() + GameState.playerLocation.substring(1)).replace("_", " ");
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine2, "Personal Gold")) {
                String string = line2 = GameState.personal_bank == null ? null : "Personal Gold: " + formatter.format(GameState.personal_bank);
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine2, "Medals")) {
                String string = line2 = GameState.medals == null ? null : "Medals: " + formatter.format(GameState.medals);
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine2, "Trophies")) {
                String string = line2 = GameState.trophies == null ? null : "Trophies: " + formatter.format(GameState.trophies);
            }
            if (Objects.equals(((Config)Config.HANDLER.instance()).richPresenceLine2, "Karma")) {
                line2 = GameState.karma == null ? null : "Karma: " + formatter.format(GameState.karma);
            }
            DiscordManager.setStatus(line2, line1, OffsetDateTime.of(GameState.melonJoin, ZoneOffset.systemDefault().getRules().getStandardOffset(Instant.now())), "melon", "Running MwonMod " + (FabricLoader.getInstance().getModContainer("mwonmod").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Object::toString).orElse("0.0").equals("0.0.0") ? "Development" : FabricLoader.getInstance().getModContainer("mwonmod").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Object::toString).orElse("0.0")), ((Config)Config.HANDLER.instance()).richPresencePathIcon != false && GameState.currentPath != null ? GameState.currentPath.toLowerCase() : null, ((Config)Config.HANDLER.instance()).richPresencePathIcon != false && GameState.currentPath != null ? "Path: " + GameState.currentPath : null);
        } else {
            DiscordManager.setEnabled(false);
        }
    }

    public static void setStatus(String state, String details, OffsetDateTime startTimestamp, String largeImageKey, String largeImageText, String smallImageKey, String smallImageText) {
        if (!enabled || client == null) {
            return;
        }
        if (!listener.isConnected()) {
            return;
        }
        RichPresence presence = new RichPresence.Builder().setState(state).setDetails(details).setStartTimestamp(startTimestamp).setLargeImage(largeImageKey, largeImageText).setSmallImage(smallImageKey, smallImageText).build();
        client.sendRichPresence(presence);
    }

    public static void setEnabled(boolean value) {
        if (enabled == value) {
            return;
        }
        enabled = value;
        if (!enabled && client != null) {
            client.close();
            client = null;
        } else if (enabled && client == null) {
            DiscordManager.initialise();
        }
    }

    static {
        listener = new DiscordListener();
        enabled = ((Config)Config.HANDLER.instance()).discordRichPresence;
    }
}

