/*
 * Decompiled with CFR 0.152.
 */
package dev.lycanea.mwonmod.util.region;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.lycanea.mwonmod.Mwonmod;
import dev.lycanea.mwonmod.util.GameState;
import dev.lycanea.mwonmod.util.region.Region;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import org.joml.Vector2i;

public class RegionLoader {
    public static final Vector2i plot_origin = new Vector2i(-975, -4270);
    public static final Vector2i beta_plot_origin = new Vector2i(104000, 14000);
    public static List<Region> locationData;

    public static void init() {
        InputStream inputStream = Mwonmod.class.getClassLoader().getResourceAsStream("assets/mwonmod/data/locations.json");
        locationData = RegionLoader.loadRegionsFromJson(inputStream);
    }

    public static Region getCurrentRegion() {
        if (class_310.method_1551().field_1724 == null || class_310.method_1551().field_1687 == null || locationData == null || !Mwonmod.onMelonKing()) {
            return null;
        }
        class_2338 pos = class_310.method_1551().field_1724.method_24515().method_10069(-RegionLoader.plot_origin.x, 0, -RegionLoader.plot_origin.y);
        if (GameState.beta_plot) {
            pos = class_310.method_1551().field_1724.method_24515().method_10069(-RegionLoader.beta_plot_origin.x, 0, -RegionLoader.beta_plot_origin.y);
        }
        for (Region region : locationData) {
            if (pos.method_10263() < Math.min(region.min.method_10263(), region.max.method_10263()) || pos.method_10263() > Math.max(region.min.method_10263(), region.max.method_10263()) || pos.method_10264() < Math.min(region.min.method_10264(), region.max.method_10264()) || pos.method_10264() > Math.max(region.min.method_10264(), region.max.method_10264()) || pos.method_10260() < Math.min(region.min.method_10260(), region.max.method_10260()) || pos.method_10260() > Math.max(region.min.method_10260(), region.max.method_10260())) continue;
            return region;
        }
        return null;
    }

    public static List<Region> loadRegionsFromJson(InputStream jsonStream) {
        ArrayList<Region> regions = new ArrayList<Region>();
        JsonElement root = JsonParser.parseReader((Reader)new InputStreamReader(jsonStream, StandardCharsets.UTF_8));
        if (root.isJsonArray()) {
            JsonArray array = root.getAsJsonArray();
            for (JsonElement element : array) {
                JsonObject obj = element.getAsJsonObject();
                String name = obj.get("name").getAsString();
                JsonObject min = obj.getAsJsonObject("min");
                JsonObject max = obj.getAsJsonObject("max");
                class_2382 minVec = new class_2382(min.get("x").getAsInt(), min.get("y").getAsInt(), min.get("z").getAsInt());
                class_2382 maxVec = new class_2382(max.get("x").getAsInt(), max.get("y").getAsInt(), max.get("z").getAsInt());
                regions.add(new Region(name, minVec, maxVec));
            }
        }
        return regions;
    }
}

