/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.StandardFileFormat;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;

final class AuFileFormat
extends StandardFileFormat {
    static final int AU_SUN_MAGIC = 779316836;
    static final int AU_ULAW_8 = 1;
    static final int AU_LINEAR_8 = 2;
    static final int AU_LINEAR_16 = 3;
    static final int AU_LINEAR_24 = 4;
    static final int AU_LINEAR_32 = 5;
    static final int AU_FLOAT = 6;
    static final int AU_DOUBLE = 7;
    static final int AU_ALAW_8 = 27;
    static final int AU_HEADERSIZE = 24;
    static final long UNKNOWN_SIZE = 0xFFFFFFFFL;
    private int auType;

    AuFileFormat(AudioFileFormat.Type type, long byteLength, AudioFormat format, long frameLength) {
        super(type, byteLength, format, frameLength);
        AudioFormat.Encoding encoding = format.getEncoding();
        this.auType = -1;
        if (AudioFormat.Encoding.ALAW.equals(encoding)) {
            if (format.getSampleSizeInBits() == 8) {
                this.auType = 27;
            }
        } else if (AudioFormat.Encoding.ULAW.equals(encoding)) {
            if (format.getSampleSizeInBits() == 8) {
                this.auType = 1;
            }
        } else if (AudioFormat.Encoding.PCM_SIGNED.equals(encoding)) {
            if (format.getSampleSizeInBits() == 8) {
                this.auType = 2;
            } else if (format.getSampleSizeInBits() == 16) {
                this.auType = 3;
            } else if (format.getSampleSizeInBits() == 24) {
                this.auType = 4;
            } else if (format.getSampleSizeInBits() == 32) {
                this.auType = 5;
            }
        } else if (AudioFormat.Encoding.PCM_FLOAT.equals(encoding)) {
            if (format.getSampleSizeInBits() == 32) {
                this.auType = 6;
            } else if (format.getSampleSizeInBits() == 64) {
                this.auType = 7;
            }
        }
    }

    public int getAuType() {
        return this.auType;
    }
}

