/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.DLSInfo;
import io.github.tofodroid.com.sun.media.sound.DLSInstrument;
import io.github.tofodroid.com.sun.media.sound.DLSModulator;
import io.github.tofodroid.com.sun.media.sound.DLSRegion;
import io.github.tofodroid.com.sun.media.sound.DLSSample;
import io.github.tofodroid.com.sun.media.sound.DLSSampleLoop;
import io.github.tofodroid.com.sun.media.sound.DLSSampleOptions;
import io.github.tofodroid.com.sun.media.sound.ModelByteBuffer;
import io.github.tofodroid.com.sun.media.sound.ModelInstrumentComparator;
import io.github.tofodroid.com.sun.media.sound.ModelPatch;
import io.github.tofodroid.com.sun.media.sound.RIFFInvalidDataException;
import io.github.tofodroid.com.sun.media.sound.RIFFInvalidFormatException;
import io.github.tofodroid.com.sun.media.sound.RIFFReader;
import io.github.tofodroid.com.sun.media.sound.RIFFWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public final class DLSSoundbank
implements Soundbank {
    private static final int DLS_CDL_AND = 1;
    private static final int DLS_CDL_OR = 2;
    private static final int DLS_CDL_XOR = 3;
    private static final int DLS_CDL_ADD = 4;
    private static final int DLS_CDL_SUBTRACT = 5;
    private static final int DLS_CDL_MULTIPLY = 6;
    private static final int DLS_CDL_DIVIDE = 7;
    private static final int DLS_CDL_LOGICAL_AND = 8;
    private static final int DLS_CDL_LOGICAL_OR = 9;
    private static final int DLS_CDL_LT = 10;
    private static final int DLS_CDL_LE = 11;
    private static final int DLS_CDL_GT = 12;
    private static final int DLS_CDL_GE = 13;
    private static final int DLS_CDL_EQ = 14;
    private static final int DLS_CDL_NOT = 15;
    private static final int DLS_CDL_CONST = 16;
    private static final int DLS_CDL_QUERY = 17;
    private static final int DLS_CDL_QUERYSUPPORTED = 18;
    private static final DLSID DLSID_GMInHardware = new DLSID(395259684L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_GSInHardware = new DLSID(395259685L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_XGInHardware = new DLSID(395259686L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_SupportsDLS1 = new DLSID(395259687L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_SupportsDLS2 = new DLSID(-247096859L, 18057, 4562, 175, 166, 0, 170, 0, 36, 216, 182);
    private static final DLSID DLSID_SampleMemorySize = new DLSID(395259688L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_ManufacturersID = new DLSID(-1338109567L, 32917, 4562, 161, 239, 0, 96, 8, 51, 219, 216);
    private static final DLSID DLSID_ProductID = new DLSID(-1338109566L, 32917, 4562, 161, 239, 0, 96, 8, 51, 219, 216);
    private static final DLSID DLSID_SamplePlaybackRate = new DLSID(714209043L, 42175, 4562, 187, 223, 0, 96, 8, 51, 219, 216);
    private long major = -1L;
    private long minor = -1L;
    private final DLSInfo info = new DLSInfo();
    private final List<DLSInstrument> instruments = new ArrayList<DLSInstrument>();
    private final List<DLSSample> samples = new ArrayList<DLSSample>();
    private boolean largeFormat = false;
    private File sampleFile;
    private Map<DLSRegion, Long> temp_rgnassign = new HashMap<DLSRegion, Long>();

    public DLSSoundbank() {
    }

    public DLSSoundbank(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            this.readSoundbank(is);
        }
    }

    public DLSSoundbank(File file) throws IOException {
        this.largeFormat = true;
        this.sampleFile = file;
        try (FileInputStream is = new FileInputStream(file);){
            this.readSoundbank(is);
        }
    }

    public DLSSoundbank(InputStream inputstream) throws IOException {
        this.readSoundbank(inputstream);
    }

    private void readSoundbank(InputStream inputstream) throws IOException {
        RIFFReader riff = new RIFFReader(inputstream);
        if (!riff.getFormat().equals("RIFF")) {
            throw new RIFFInvalidFormatException("Input stream is not a valid RIFF stream!");
        }
        if (!riff.getType().equals("DLS ")) {
            throw new RIFFInvalidFormatException("Input stream is not a valid DLS soundbank!");
        }
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            if (chunk.getFormat().equals("LIST")) {
                if (chunk.getType().equals("INFO")) {
                    this.readInfoChunk(chunk);
                }
                if (chunk.getType().equals("lins")) {
                    this.readLinsChunk(chunk);
                }
                if (!chunk.getType().equals("wvpl")) continue;
                this.readWvplChunk(chunk);
                continue;
            }
            if (chunk.getFormat().equals("cdl ") && !this.readCdlChunk(chunk)) {
                throw new RIFFInvalidFormatException("DLS file isn't supported!");
            }
            if (chunk.getFormat().equals("colh")) {
                // empty if block
            }
            if (chunk.getFormat().equals("ptbl")) {
                // empty if block
            }
            if (!chunk.getFormat().equals("vers")) continue;
            this.major = chunk.readUnsignedInt();
            this.minor = chunk.readUnsignedInt();
        }
        for (Map.Entry<DLSRegion, Long> entry : this.temp_rgnassign.entrySet()) {
            entry.getKey().sample = this.samples.get((int)entry.getValue().longValue());
        }
        this.temp_rgnassign = null;
    }

    private boolean cdlIsQuerySupported(DLSID uuid) {
        return uuid.equals(DLSID_GMInHardware) || uuid.equals(DLSID_GSInHardware) || uuid.equals(DLSID_XGInHardware) || uuid.equals(DLSID_SupportsDLS1) || uuid.equals(DLSID_SupportsDLS2) || uuid.equals(DLSID_SampleMemorySize) || uuid.equals(DLSID_ManufacturersID) || uuid.equals(DLSID_ProductID) || uuid.equals(DLSID_SamplePlaybackRate);
    }

    private long cdlQuery(DLSID uuid) {
        if (uuid.equals(DLSID_GMInHardware)) {
            return 1L;
        }
        if (uuid.equals(DLSID_GSInHardware)) {
            return 0L;
        }
        if (uuid.equals(DLSID_XGInHardware)) {
            return 0L;
        }
        if (uuid.equals(DLSID_SupportsDLS1)) {
            return 1L;
        }
        if (uuid.equals(DLSID_SupportsDLS2)) {
            return 1L;
        }
        if (uuid.equals(DLSID_SampleMemorySize)) {
            return Runtime.getRuntime().totalMemory();
        }
        if (uuid.equals(DLSID_ManufacturersID)) {
            return 0L;
        }
        if (uuid.equals(DLSID_ProductID)) {
            return 0L;
        }
        if (uuid.equals(DLSID_SamplePlaybackRate)) {
            return 44100L;
        }
        return 0L;
    }

    private boolean readCdlChunk(RIFFReader riff) throws IOException {
        ArrayDeque<Long> stack = new ArrayDeque<Long>();
        while (riff.available() != 0) {
            int opcode = riff.readUnsignedShort();
            switch (opcode) {
                case 1: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x != 0L && y != 0L ? 1L : 0L);
                    break;
                }
                case 2: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x != 0L || y != 0L ? 1L : 0L);
                    break;
                }
                case 3: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x != 0L ^ y != 0L ? 1L : 0L);
                    break;
                }
                case 4: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x + y);
                    break;
                }
                case 5: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x - y);
                    break;
                }
                case 6: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x * y);
                    break;
                }
                case 7: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x / y);
                    break;
                }
                case 8: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x != 0L && y != 0L ? 1L : 0L);
                    break;
                }
                case 9: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x != 0L || y != 0L ? 1L : 0L);
                    break;
                }
                case 10: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x < y ? 1L : 0L);
                    break;
                }
                case 11: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x <= y ? 1L : 0L);
                    break;
                }
                case 12: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x > y ? 1L : 0L);
                    break;
                }
                case 13: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x >= y ? 1L : 0L);
                    break;
                }
                case 14: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x == y ? 1L : 0L);
                    break;
                }
                case 15: {
                    long x = (Long)stack.pop();
                    long y = (Long)stack.pop();
                    stack.push(x == 0L ? 1L : 0L);
                    break;
                }
                case 16: {
                    stack.push(riff.readUnsignedInt());
                    break;
                }
                case 17: {
                    DLSID uuid = DLSID.read(riff);
                    stack.push(this.cdlQuery(uuid));
                    break;
                }
                case 18: {
                    DLSID uuid = DLSID.read(riff);
                    stack.push(this.cdlIsQuerySupported(uuid) ? 1L : 0L);
                    break;
                }
            }
        }
        if (stack.isEmpty()) {
            return false;
        }
        return (Long)stack.pop() == 1L;
    }

    private void readInfoChunk(RIFFReader riff) throws IOException {
        this.info.name = null;
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            String format = chunk.getFormat();
            if (format.equals("INAM")) {
                this.info.name = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICRD")) {
                this.info.creationDate = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IENG")) {
                this.info.engineers = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IPRD")) {
                this.info.product = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICOP")) {
                this.info.copyright = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICMT")) {
                this.info.comments = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISFT")) {
                this.info.tools = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IARL")) {
                this.info.archival_location = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IART")) {
                this.info.artist = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICMS")) {
                this.info.commissioned = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IGNR")) {
                this.info.genre = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IKEY")) {
                this.info.keywords = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IMED")) {
                this.info.medium = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISBJ")) {
                this.info.subject = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISRC")) {
                this.info.source = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISRF")) {
                this.info.source_form = chunk.readString(chunk.available());
                continue;
            }
            if (!format.equals("ITCH")) continue;
            this.info.technician = chunk.readString(chunk.available());
        }
    }

    private void readLinsChunk(RIFFReader riff) throws IOException {
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            if (!chunk.getFormat().equals("LIST") || !chunk.getType().equals("ins ")) continue;
            this.readInsChunk(chunk);
        }
    }

    private void readInsChunk(RIFFReader riff) throws IOException {
        DLSInstrument instrument = new DLSInstrument(this);
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            String format = chunk.getFormat();
            if (format.equals("LIST")) {
                RIFFReader subchunk;
                ArrayList<DLSModulator> modlist;
                if (chunk.getType().equals("INFO")) {
                    this.readInsInfoChunk(instrument, chunk);
                }
                if (chunk.getType().equals("lrgn")) {
                    while (chunk.hasNextChunk()) {
                        DLSRegion split;
                        RIFFReader subchunk2 = chunk.nextChunk();
                        if (!subchunk2.getFormat().equals("LIST")) continue;
                        if (subchunk2.getType().equals("rgn ") && this.readRgnChunk(split = new DLSRegion(), subchunk2)) {
                            instrument.getRegions().add(split);
                        }
                        if (!subchunk2.getType().equals("rgn2") || !this.readRgnChunk(split = new DLSRegion(), subchunk2)) continue;
                        instrument.getRegions().add(split);
                    }
                }
                if (chunk.getType().equals("lart")) {
                    modlist = new ArrayList<DLSModulator>();
                    while (chunk.hasNextChunk()) {
                        subchunk = chunk.nextChunk();
                        if (chunk.getFormat().equals("cdl ") && !this.readCdlChunk(chunk)) {
                            modlist.clear();
                            break;
                        }
                        if (!subchunk.getFormat().equals("art1")) continue;
                        this.readArt1Chunk(modlist, subchunk);
                    }
                    instrument.getModulators().addAll(modlist);
                }
                if (!chunk.getType().equals("lar2")) continue;
                modlist = new ArrayList();
                while (chunk.hasNextChunk()) {
                    subchunk = chunk.nextChunk();
                    if (chunk.getFormat().equals("cdl ") && !this.readCdlChunk(chunk)) {
                        modlist.clear();
                        break;
                    }
                    if (!subchunk.getFormat().equals("art2")) continue;
                    this.readArt2Chunk(modlist, subchunk);
                }
                instrument.getModulators().addAll(modlist);
                continue;
            }
            if (format.equals("dlid")) {
                instrument.guid = new byte[16];
                chunk.readFully(instrument.guid);
            }
            if (!format.equals("insh")) continue;
            chunk.readUnsignedInt();
            int bank = chunk.read();
            bank += (chunk.read() & 0x7F) << 7;
            chunk.read();
            int drumins = chunk.read();
            int id = chunk.read() & 0x7F;
            chunk.read();
            chunk.read();
            chunk.read();
            instrument.bank = bank;
            instrument.preset = id;
            instrument.druminstrument = (drumins & 0x80) > 0;
        }
        this.instruments.add(instrument);
    }

    private void readArt1Chunk(List<DLSModulator> modulators, RIFFReader riff) throws IOException {
        long size = riff.readUnsignedInt();
        long count = riff.readUnsignedInt();
        if (size - 8L != 0L) {
            riff.skip(size - 8L);
        }
        int i = 0;
        while ((long)i < count) {
            DLSModulator modulator = new DLSModulator();
            modulator.version = 1;
            modulator.source = riff.readUnsignedShort();
            modulator.control = riff.readUnsignedShort();
            modulator.destination = riff.readUnsignedShort();
            modulator.transform = riff.readUnsignedShort();
            modulator.scale = riff.readInt();
            modulators.add(modulator);
            ++i;
        }
    }

    private void readArt2Chunk(List<DLSModulator> modulators, RIFFReader riff) throws IOException {
        long size = riff.readUnsignedInt();
        long count = riff.readUnsignedInt();
        if (size - 8L != 0L) {
            riff.skip(size - 8L);
        }
        int i = 0;
        while ((long)i < count) {
            DLSModulator modulator = new DLSModulator();
            modulator.version = 2;
            modulator.source = riff.readUnsignedShort();
            modulator.control = riff.readUnsignedShort();
            modulator.destination = riff.readUnsignedShort();
            modulator.transform = riff.readUnsignedShort();
            modulator.scale = riff.readInt();
            modulators.add(modulator);
            ++i;
        }
    }

    private boolean readRgnChunk(DLSRegion split, RIFFReader riff) throws IOException {
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            String format = chunk.getFormat();
            if (format.equals("LIST")) {
                RIFFReader subchunk;
                ArrayList<DLSModulator> modlist;
                if (chunk.getType().equals("lart")) {
                    modlist = new ArrayList<DLSModulator>();
                    while (chunk.hasNextChunk()) {
                        subchunk = chunk.nextChunk();
                        if (chunk.getFormat().equals("cdl ") && !this.readCdlChunk(chunk)) {
                            modlist.clear();
                            break;
                        }
                        if (!subchunk.getFormat().equals("art1")) continue;
                        this.readArt1Chunk(modlist, subchunk);
                    }
                    split.getModulators().addAll(modlist);
                }
                if (!chunk.getType().equals("lar2")) continue;
                modlist = new ArrayList();
                while (chunk.hasNextChunk()) {
                    subchunk = chunk.nextChunk();
                    if (chunk.getFormat().equals("cdl ") && !this.readCdlChunk(chunk)) {
                        modlist.clear();
                        break;
                    }
                    if (!subchunk.getFormat().equals("art2")) continue;
                    this.readArt2Chunk(modlist, subchunk);
                }
                split.getModulators().addAll(modlist);
                continue;
            }
            if (format.equals("cdl ") && !this.readCdlChunk(chunk)) {
                return false;
            }
            if (format.equals("rgnh")) {
                split.keyfrom = chunk.readUnsignedShort();
                split.keyto = chunk.readUnsignedShort();
                split.velfrom = chunk.readUnsignedShort();
                split.velto = chunk.readUnsignedShort();
                split.options = chunk.readUnsignedShort();
                split.exclusiveClass = chunk.readUnsignedShort();
            }
            if (format.equals("wlnk")) {
                split.fusoptions = chunk.readUnsignedShort();
                split.phasegroup = chunk.readUnsignedShort();
                split.channel = chunk.readUnsignedInt();
                long sampleid = chunk.readUnsignedInt();
                this.temp_rgnassign.put(split, sampleid);
            }
            if (!format.equals("wsmp")) continue;
            split.sampleoptions = new DLSSampleOptions();
            this.readWsmpChunk(split.sampleoptions, chunk);
        }
        return true;
    }

    private void readWsmpChunk(DLSSampleOptions sampleOptions, RIFFReader riff) throws IOException {
        long size = riff.readUnsignedInt();
        sampleOptions.unitynote = riff.readUnsignedShort();
        sampleOptions.finetune = riff.readShort();
        sampleOptions.attenuation = riff.readInt();
        sampleOptions.options = riff.readUnsignedInt();
        long loops = riff.readInt();
        if (size > 20L) {
            riff.skip(size - 20L);
        }
        int i = 0;
        while ((long)i < loops) {
            DLSSampleLoop loop = new DLSSampleLoop();
            long size2 = riff.readUnsignedInt();
            loop.type = riff.readUnsignedInt();
            loop.start = riff.readUnsignedInt();
            loop.length = riff.readUnsignedInt();
            sampleOptions.loops.add(loop);
            if (size2 > 16L) {
                riff.skip(size2 - 16L);
            }
            ++i;
        }
    }

    private void readInsInfoChunk(DLSInstrument dlsinstrument, RIFFReader riff) throws IOException {
        dlsinstrument.info.name = null;
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            String format = chunk.getFormat();
            if (format.equals("INAM")) {
                dlsinstrument.info.name = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICRD")) {
                dlsinstrument.info.creationDate = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IENG")) {
                dlsinstrument.info.engineers = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IPRD")) {
                dlsinstrument.info.product = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICOP")) {
                dlsinstrument.info.copyright = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICMT")) {
                dlsinstrument.info.comments = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISFT")) {
                dlsinstrument.info.tools = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IARL")) {
                dlsinstrument.info.archival_location = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IART")) {
                dlsinstrument.info.artist = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICMS")) {
                dlsinstrument.info.commissioned = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IGNR")) {
                dlsinstrument.info.genre = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IKEY")) {
                dlsinstrument.info.keywords = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IMED")) {
                dlsinstrument.info.medium = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISBJ")) {
                dlsinstrument.info.subject = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISRC")) {
                dlsinstrument.info.source = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISRF")) {
                dlsinstrument.info.source_form = chunk.readString(chunk.available());
                continue;
            }
            if (!format.equals("ITCH")) continue;
            dlsinstrument.info.technician = chunk.readString(chunk.available());
        }
    }

    private void readWvplChunk(RIFFReader riff) throws IOException {
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            if (!chunk.getFormat().equals("LIST") || !chunk.getType().equals("wave")) continue;
            this.readWaveChunk(chunk);
        }
    }

    private void readWaveChunk(RIFFReader riff) throws IOException {
        DLSSample sample = new DLSSample(this);
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            String format = chunk.getFormat();
            if (format.equals("LIST")) {
                if (!chunk.getType().equals("INFO")) continue;
                this.readWaveInfoChunk(sample, chunk);
                continue;
            }
            if (format.equals("dlid")) {
                sample.guid = new byte[16];
                chunk.readFully(sample.guid);
            }
            if (format.equals("fmt ")) {
                int sampleformat = chunk.readUnsignedShort();
                if (sampleformat != 1 && sampleformat != 3) {
                    throw new RIFFInvalidDataException("Only PCM samples are supported!");
                }
                int channels = chunk.readUnsignedShort();
                long samplerate = chunk.readUnsignedInt();
                chunk.readUnsignedInt();
                int framesize = chunk.readUnsignedShort();
                int bits = chunk.readUnsignedShort();
                AudioFormat audioformat = null;
                if (sampleformat == 1) {
                    audioformat = bits == 8 ? new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, samplerate, bits, channels, framesize, samplerate, false) : new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, samplerate, bits, channels, framesize, samplerate, false);
                }
                if (sampleformat == 3) {
                    audioformat = new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, samplerate, bits, channels, framesize, samplerate, false);
                }
                sample.format = audioformat;
            }
            if (format.equals("data")) {
                if (this.largeFormat) {
                    sample.setData(new ModelByteBuffer(this.sampleFile, chunk.getFilePointer(), (long)chunk.available()));
                } else {
                    byte[] buffer = new byte[chunk.available()];
                    sample.setData(buffer);
                    int read = 0;
                    int avail = chunk.available();
                    while (read != avail) {
                        if (avail - read > 65536) {
                            chunk.readFully(buffer, read, 65536);
                            read += 65536;
                            continue;
                        }
                        chunk.readFully(buffer, read, avail - read);
                        read = avail;
                    }
                }
            }
            if (!format.equals("wsmp")) continue;
            sample.sampleoptions = new DLSSampleOptions();
            this.readWsmpChunk(sample.sampleoptions, chunk);
        }
        this.samples.add(sample);
    }

    private void readWaveInfoChunk(DLSSample dlssample, RIFFReader riff) throws IOException {
        dlssample.info.name = null;
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            String format = chunk.getFormat();
            if (format.equals("INAM")) {
                dlssample.info.name = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICRD")) {
                dlssample.info.creationDate = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IENG")) {
                dlssample.info.engineers = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IPRD")) {
                dlssample.info.product = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICOP")) {
                dlssample.info.copyright = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICMT")) {
                dlssample.info.comments = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISFT")) {
                dlssample.info.tools = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IARL")) {
                dlssample.info.archival_location = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IART")) {
                dlssample.info.artist = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ICMS")) {
                dlssample.info.commissioned = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IGNR")) {
                dlssample.info.genre = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IKEY")) {
                dlssample.info.keywords = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("IMED")) {
                dlssample.info.medium = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISBJ")) {
                dlssample.info.subject = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISRC")) {
                dlssample.info.source = chunk.readString(chunk.available());
                continue;
            }
            if (format.equals("ISRF")) {
                dlssample.info.source_form = chunk.readString(chunk.available());
                continue;
            }
            if (!format.equals("ITCH")) continue;
            dlssample.info.technician = chunk.readString(chunk.available());
        }
    }

    public void save(String name) throws IOException {
        try (RIFFWriter writer = new RIFFWriter(name, "DLS ");){
            this.writeSoundbank(writer);
        }
    }

    public void save(File file) throws IOException {
        try (RIFFWriter writer = new RIFFWriter(file, "DLS ");){
            this.writeSoundbank(writer);
        }
    }

    public void save(OutputStream out) throws IOException {
        try (RIFFWriter writer = new RIFFWriter(out, "DLS ");){
            this.writeSoundbank(writer);
        }
    }

    private void writeSoundbank(RIFFWriter writer) throws IOException {
        RIFFWriter colh_chunk = writer.writeChunk("colh");
        colh_chunk.writeUnsignedInt(this.instruments.size());
        if (this.major != -1L && this.minor != -1L) {
            RIFFWriter vers_chunk = writer.writeChunk("vers");
            vers_chunk.writeUnsignedInt(this.major);
            vers_chunk.writeUnsignedInt(this.minor);
        }
        this.writeInstruments(writer.writeList("lins"));
        RIFFWriter ptbl = writer.writeChunk("ptbl");
        ptbl.writeUnsignedInt(8L);
        ptbl.writeUnsignedInt(this.samples.size());
        long ptbl_offset = writer.getFilePointer();
        for (int i = 0; i < this.samples.size(); ++i) {
            ptbl.writeUnsignedInt(0L);
        }
        RIFFWriter wvpl = writer.writeList("wvpl");
        long off = wvpl.getFilePointer();
        ArrayList<Long> offsettable = new ArrayList<Long>();
        for (DLSSample sample : this.samples) {
            offsettable.add(wvpl.getFilePointer() - off);
            this.writeSample(wvpl.writeList("wave"), sample);
        }
        long bak = writer.getFilePointer();
        writer.seek(ptbl_offset);
        writer.setWriteOverride(true);
        for (Long offset : offsettable) {
            writer.writeUnsignedInt(offset);
        }
        writer.setWriteOverride(false);
        writer.seek(bak);
        this.writeInfo(writer.writeList("INFO"), this.info);
    }

    private void writeSample(RIFFWriter writer, DLSSample sample) throws IOException {
        AudioFormat audioformat = sample.getFormat();
        AudioFormat.Encoding encoding = audioformat.getEncoding();
        float sampleRate = audioformat.getSampleRate();
        int sampleSizeInBits = audioformat.getSampleSizeInBits();
        int channels = audioformat.getChannels();
        int frameSize = audioformat.getFrameSize();
        float frameRate = audioformat.getFrameRate();
        boolean bigEndian = audioformat.isBigEndian();
        boolean convert_needed = false;
        if (audioformat.getSampleSizeInBits() == 8) {
            if (!encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                convert_needed = true;
            }
        } else {
            if (!encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                convert_needed = true;
            }
            if (bigEndian) {
                bigEndian = false;
                convert_needed = true;
            }
        }
        if (convert_needed) {
            audioformat = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
        }
        RIFFWriter fmt_chunk = writer.writeChunk("fmt ");
        int sampleformat = 0;
        if (audioformat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            sampleformat = 1;
        } else if (audioformat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            sampleformat = 1;
        } else if (audioformat.getEncoding().equals(AudioFormat.Encoding.PCM_FLOAT)) {
            sampleformat = 3;
        }
        fmt_chunk.writeUnsignedShort(sampleformat);
        fmt_chunk.writeUnsignedShort(audioformat.getChannels());
        fmt_chunk.writeUnsignedInt((long)audioformat.getSampleRate());
        long srate = (long)audioformat.getFrameRate() * (long)audioformat.getFrameSize();
        fmt_chunk.writeUnsignedInt(srate);
        fmt_chunk.writeUnsignedShort(audioformat.getFrameSize());
        fmt_chunk.writeUnsignedShort(audioformat.getSampleSizeInBits());
        fmt_chunk.write(0);
        fmt_chunk.write(0);
        this.writeSampleOptions(writer.writeChunk("wsmp"), sample.sampleoptions);
        if (convert_needed) {
            RIFFWriter data_chunk = writer.writeChunk("data");
            AudioInputStream stream = AudioSystem.getAudioInputStream(audioformat, (AudioInputStream)sample.getData());
            stream.transferTo(data_chunk);
        } else {
            RIFFWriter data_chunk = writer.writeChunk("data");
            ModelByteBuffer databuff = sample.getDataBuffer();
            databuff.writeTo(data_chunk);
        }
        this.writeInfo(writer.writeList("INFO"), sample.info);
    }

    private void writeInstruments(RIFFWriter writer) throws IOException {
        for (DLSInstrument instrument : this.instruments) {
            this.writeInstrument(writer.writeList("ins "), instrument);
        }
    }

    private void writeInstrument(RIFFWriter writer, DLSInstrument instrument) throws IOException {
        int art1_count = 0;
        int art2_count = 0;
        for (DLSModulator modulator : instrument.getModulators()) {
            if (modulator.version == 1) {
                ++art1_count;
            }
            if (modulator.version != 2) continue;
            ++art2_count;
        }
        for (DLSRegion region : instrument.regions) {
            for (DLSModulator modulator : region.getModulators()) {
                if (modulator.version == 1) {
                    ++art1_count;
                }
                if (modulator.version != 2) continue;
                ++art2_count;
            }
        }
        int version = 1;
        if (art2_count > 0) {
            version = 2;
        }
        RIFFWriter insh_chunk = writer.writeChunk("insh");
        insh_chunk.writeUnsignedInt(instrument.getRegions().size());
        insh_chunk.writeUnsignedInt((long)instrument.bank + (instrument.druminstrument ? 0x80000000L : 0L));
        insh_chunk.writeUnsignedInt(instrument.preset);
        RIFFWriter lrgn = writer.writeList("lrgn");
        for (DLSRegion region : instrument.regions) {
            this.writeRegion(lrgn, region, version);
        }
        this.writeArticulators(writer, instrument.getModulators());
        this.writeInfo(writer.writeList("INFO"), instrument.info);
    }

    private void writeArticulators(RIFFWriter writer, List<DLSModulator> modulators) throws IOException {
        int art1_count = 0;
        int art2_count = 0;
        for (DLSModulator modulator : modulators) {
            if (modulator.version == 1) {
                ++art1_count;
            }
            if (modulator.version != 2) continue;
            ++art2_count;
        }
        if (art1_count > 0) {
            RIFFWriter lar1 = writer.writeList("lart");
            RIFFWriter art1 = lar1.writeChunk("art1");
            art1.writeUnsignedInt(8L);
            art1.writeUnsignedInt(art1_count);
            for (DLSModulator modulator : modulators) {
                if (modulator.version != 1) continue;
                art1.writeUnsignedShort(modulator.source);
                art1.writeUnsignedShort(modulator.control);
                art1.writeUnsignedShort(modulator.destination);
                art1.writeUnsignedShort(modulator.transform);
                art1.writeInt(modulator.scale);
            }
        }
        if (art2_count > 0) {
            RIFFWriter lar2 = writer.writeList("lar2");
            RIFFWriter art2 = lar2.writeChunk("art2");
            art2.writeUnsignedInt(8L);
            art2.writeUnsignedInt(art2_count);
            for (DLSModulator modulator : modulators) {
                if (modulator.version != 2) continue;
                art2.writeUnsignedShort(modulator.source);
                art2.writeUnsignedShort(modulator.control);
                art2.writeUnsignedShort(modulator.destination);
                art2.writeUnsignedShort(modulator.transform);
                art2.writeInt(modulator.scale);
            }
        }
    }

    private void writeRegion(RIFFWriter writer, DLSRegion region, int version) throws IOException {
        RIFFWriter rgns = null;
        if (version == 1) {
            rgns = writer.writeList("rgn ");
        }
        if (version == 2) {
            rgns = writer.writeList("rgn2");
        }
        if (rgns == null) {
            return;
        }
        RIFFWriter rgnh = rgns.writeChunk("rgnh");
        rgnh.writeUnsignedShort(region.keyfrom);
        rgnh.writeUnsignedShort(region.keyto);
        rgnh.writeUnsignedShort(region.velfrom);
        rgnh.writeUnsignedShort(region.velto);
        rgnh.writeUnsignedShort(region.options);
        rgnh.writeUnsignedShort(region.exclusiveClass);
        if (region.sampleoptions != null) {
            this.writeSampleOptions(rgns.writeChunk("wsmp"), region.sampleoptions);
        }
        if (region.sample != null && this.samples.indexOf(region.sample) != -1) {
            RIFFWriter wlnk = rgns.writeChunk("wlnk");
            wlnk.writeUnsignedShort(region.fusoptions);
            wlnk.writeUnsignedShort(region.phasegroup);
            wlnk.writeUnsignedInt(region.channel);
            wlnk.writeUnsignedInt(this.samples.indexOf(region.sample));
        }
        this.writeArticulators(rgns, region.getModulators());
        rgns.close();
    }

    private void writeSampleOptions(RIFFWriter wsmp, DLSSampleOptions sampleoptions) throws IOException {
        wsmp.writeUnsignedInt(20L);
        wsmp.writeUnsignedShort(sampleoptions.unitynote);
        wsmp.writeShort(sampleoptions.finetune);
        wsmp.writeInt(sampleoptions.attenuation);
        wsmp.writeUnsignedInt(sampleoptions.options);
        wsmp.writeInt(sampleoptions.loops.size());
        for (DLSSampleLoop loop : sampleoptions.loops) {
            wsmp.writeUnsignedInt(16L);
            wsmp.writeUnsignedInt(loop.type);
            wsmp.writeUnsignedInt(loop.start);
            wsmp.writeUnsignedInt(loop.length);
        }
    }

    private void writeInfoStringChunk(RIFFWriter writer, String name, String value) throws IOException {
        if (value == null) {
            return;
        }
        RIFFWriter chunk = writer.writeChunk(name);
        chunk.writeString(value);
        int len = value.getBytes(StandardCharsets.US_ASCII).length;
        chunk.write(0);
        if (++len % 2 != 0) {
            chunk.write(0);
        }
    }

    private void writeInfo(RIFFWriter writer, DLSInfo info) throws IOException {
        this.writeInfoStringChunk(writer, "INAM", info.name);
        this.writeInfoStringChunk(writer, "ICRD", info.creationDate);
        this.writeInfoStringChunk(writer, "IENG", info.engineers);
        this.writeInfoStringChunk(writer, "IPRD", info.product);
        this.writeInfoStringChunk(writer, "ICOP", info.copyright);
        this.writeInfoStringChunk(writer, "ICMT", info.comments);
        this.writeInfoStringChunk(writer, "ISFT", info.tools);
        this.writeInfoStringChunk(writer, "IARL", info.archival_location);
        this.writeInfoStringChunk(writer, "IART", info.artist);
        this.writeInfoStringChunk(writer, "ICMS", info.commissioned);
        this.writeInfoStringChunk(writer, "IGNR", info.genre);
        this.writeInfoStringChunk(writer, "IKEY", info.keywords);
        this.writeInfoStringChunk(writer, "IMED", info.medium);
        this.writeInfoStringChunk(writer, "ISBJ", info.subject);
        this.writeInfoStringChunk(writer, "ISRC", info.source);
        this.writeInfoStringChunk(writer, "ISRF", info.source_form);
        this.writeInfoStringChunk(writer, "ITCH", info.technician);
    }

    public DLSInfo getInfo() {
        return this.info;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public String getVersion() {
        return this.major + "." + this.minor;
    }

    @Override
    public String getVendor() {
        return this.info.engineers;
    }

    @Override
    public String getDescription() {
        return this.info.comments;
    }

    public void setName(String s) {
        this.info.name = s;
    }

    public void setVendor(String s) {
        this.info.engineers = s;
    }

    public void setDescription(String s) {
        this.info.comments = s;
    }

    @Override
    public SoundbankResource[] getResources() {
        SoundbankResource[] resources = new SoundbankResource[this.samples.size()];
        int j = 0;
        for (int i = 0; i < this.samples.size(); ++i) {
            resources[j++] = this.samples.get(i);
        }
        return resources;
    }

    public DLSInstrument[] getInstruments() {
        DLSInstrument[] inslist_array = this.instruments.toArray(new DLSInstrument[this.instruments.size()]);
        Arrays.sort(inslist_array, new ModelInstrumentComparator());
        return inslist_array;
    }

    public DLSSample[] getSamples() {
        return this.samples.toArray(new DLSSample[this.samples.size()]);
    }

    @Override
    public Instrument getInstrument(Patch patch) {
        int program = patch.getProgram();
        int bank = patch.getBank();
        boolean percussion = false;
        if (patch instanceof ModelPatch) {
            percussion = ((ModelPatch)patch).isPercussion();
        }
        for (Instrument instrument : this.instruments) {
            Patch patch2 = instrument.getPatch();
            int program2 = patch2.getProgram();
            int bank2 = patch2.getBank();
            if (program != program2 || bank != bank2) continue;
            boolean percussion2 = false;
            if (patch2 instanceof ModelPatch) {
                percussion2 = ((ModelPatch)patch2).isPercussion();
            }
            if (percussion != percussion2) continue;
            return instrument;
        }
        return null;
    }

    public void addResource(SoundbankResource resource) {
        if (resource instanceof DLSInstrument) {
            this.instruments.add((DLSInstrument)resource);
        }
        if (resource instanceof DLSSample) {
            this.samples.add((DLSSample)resource);
        }
    }

    public void removeResource(SoundbankResource resource) {
        if (resource instanceof DLSInstrument) {
            this.instruments.remove(resource);
        }
        if (resource instanceof DLSSample) {
            this.samples.remove(resource);
        }
    }

    public void addInstrument(DLSInstrument resource) {
        this.instruments.add(resource);
    }

    public void removeInstrument(DLSInstrument resource) {
        this.instruments.remove(resource);
    }

    public long getMajor() {
        return this.major;
    }

    public void setMajor(long major) {
        this.major = major;
    }

    public long getMinor() {
        return this.minor;
    }

    public void setMinor(long minor) {
        this.minor = minor;
    }

    private static class DLSID {
        long i1;
        int s1;
        int s2;
        int x1;
        int x2;
        int x3;
        int x4;
        int x5;
        int x6;
        int x7;
        int x8;

        private DLSID() {
        }

        DLSID(long i1, int s1, int s2, int x1, int x2, int x3, int x4, int x5, int x6, int x7, int x8) {
            this.i1 = i1;
            this.s1 = s1;
            this.s2 = s2;
            this.x1 = x1;
            this.x2 = x2;
            this.x3 = x3;
            this.x4 = x4;
            this.x5 = x5;
            this.x6 = x6;
            this.x7 = x7;
            this.x8 = x8;
        }

        public static DLSID read(RIFFReader riff) throws IOException {
            DLSID d = new DLSID();
            d.i1 = riff.readUnsignedInt();
            d.s1 = riff.readUnsignedShort();
            d.s2 = riff.readUnsignedShort();
            d.x1 = riff.readUnsignedByte();
            d.x2 = riff.readUnsignedByte();
            d.x3 = riff.readUnsignedByte();
            d.x4 = riff.readUnsignedByte();
            d.x5 = riff.readUnsignedByte();
            d.x6 = riff.readUnsignedByte();
            d.x7 = riff.readUnsignedByte();
            d.x8 = riff.readUnsignedByte();
            return d;
        }

        public int hashCode() {
            return Long.hashCode(this.i1);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DLSID)) {
                return false;
            }
            DLSID t = (DLSID)obj;
            return this.i1 == t.i1 && this.s1 == t.s1 && this.s2 == t.s2 && this.x1 == t.x1 && this.x2 == t.x2 && this.x3 == t.x3 && this.x4 == t.x4 && this.x5 == t.x5 && this.x6 == t.x6 && this.x7 == t.x7 && this.x8 == t.x8;
        }
    }
}

