/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.AbstractDataLine;
import io.github.tofodroid.com.sun.media.sound.AbstractMixer;
import io.github.tofodroid.com.sun.media.sound.AutoClosingClip;
import io.github.tofodroid.com.sun.media.sound.DirectAudioDeviceProvider;
import io.github.tofodroid.com.sun.media.sound.EventDispatcher;
import io.github.tofodroid.com.sun.media.sound.JSSecurityManager;
import io.github.tofodroid.com.sun.media.sound.Printer;
import io.github.tofodroid.com.sun.media.sound.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

final class DirectAudioDevice
extends AbstractMixer {
    private static final int CLIP_BUFFER_TIME = 1000;
    private static final int DEFAULT_LINE_BUFFER_TIME = 500;

    DirectAudioDevice(DirectAudioDeviceProvider.DirectAudioDeviceInfo portMixerInfo) {
        super(portMixerInfo, null, null, null);
        DirectDLI srcLineInfo = this.createDataLineInfo(true);
        if (srcLineInfo != null) {
            this.sourceLineInfo = new Line.Info[2];
            this.sourceLineInfo[0] = srcLineInfo;
            this.sourceLineInfo[1] = new DirectDLI(Clip.class, srcLineInfo.getFormats(), srcLineInfo.getHardwareFormats(), 32, -1);
        } else {
            this.sourceLineInfo = new Line.Info[0];
        }
        DirectDLI dstLineInfo = this.createDataLineInfo(false);
        if (dstLineInfo != null) {
            this.targetLineInfo = new Line.Info[1];
            this.targetLineInfo[0] = dstLineInfo;
        } else {
            this.targetLineInfo = new Line.Info[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectDLI createDataLineInfo(boolean isSource) {
        Vector formats = new Vector();
        AudioFormat[] hardwareFormatArray = null;
        AudioFormat[] formatArray = null;
        Vector vector = formats;
        synchronized (vector) {
            DirectAudioDevice.nGetFormats(this.getMixerIndex(), this.getDeviceID(), isSource, formats);
            if (formats.size() > 0) {
                int size;
                int formatArraySize = size = formats.size();
                hardwareFormatArray = new AudioFormat[size];
                for (int i = 0; i < size; ++i) {
                    AudioFormat format;
                    hardwareFormatArray[i] = format = (AudioFormat)formats.elementAt(i);
                    boolean isSigned = format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                    boolean isUnsigned = format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
                    if (!isSigned && !isUnsigned) continue;
                    ++formatArraySize;
                }
                formatArray = new AudioFormat[formatArraySize];
                int formatArrayIndex = 0;
                for (int i = 0; i < size; ++i) {
                    AudioFormat format = hardwareFormatArray[i];
                    formatArray[formatArrayIndex++] = format;
                    int bits = format.getSampleSizeInBits();
                    boolean isSigned = format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                    boolean isUnsigned = format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
                    if (bits == 8) {
                        if (isSigned) {
                            formatArray[formatArrayIndex++] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, format.getSampleRate(), bits, format.getChannels(), format.getFrameSize(), format.getSampleRate(), format.isBigEndian());
                            continue;
                        }
                        if (!isUnsigned) continue;
                        formatArray[formatArrayIndex++] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), bits, format.getChannels(), format.getFrameSize(), format.getSampleRate(), format.isBigEndian());
                        continue;
                    }
                    if (bits <= 8 || !isSigned && !isUnsigned) continue;
                    formatArray[formatArrayIndex++] = new AudioFormat(format.getEncoding(), format.getSampleRate(), bits, format.getChannels(), format.getFrameSize(), format.getSampleRate(), !format.isBigEndian());
                }
            }
        }
        if (formatArray != null) {
            return new DirectDLI(isSource ? SourceDataLine.class : TargetDataLine.class, formatArray, hardwareFormatArray, 32, -1);
        }
        return null;
    }

    @Override
    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo == null) {
            throw new IllegalArgumentException("Line unsupported: " + String.valueOf(info));
        }
        if (fullInfo instanceof DataLine.Info) {
            AudioFormat lineFormat;
            DataLine.Info dataLineInfo = (DataLine.Info)fullInfo;
            int lineBufferSize = -1;
            AudioFormat[] supportedFormats = null;
            if (info instanceof DataLine.Info) {
                supportedFormats = ((DataLine.Info)info).getFormats();
                lineBufferSize = ((DataLine.Info)info).getMaxBufferSize();
            }
            if (supportedFormats == null || supportedFormats.length == 0) {
                lineFormat = null;
            } else {
                lineFormat = supportedFormats[supportedFormats.length - 1];
                if (!Toolkit.isFullySpecifiedPCMFormat(lineFormat)) {
                    lineFormat = null;
                }
            }
            if (dataLineInfo.getLineClass().isAssignableFrom(DirectSDL.class)) {
                return new DirectSDL(dataLineInfo, lineFormat, lineBufferSize, this);
            }
            if (dataLineInfo.getLineClass().isAssignableFrom(DirectClip.class)) {
                return new DirectClip(dataLineInfo, lineFormat, lineBufferSize, this);
            }
            if (dataLineInfo.getLineClass().isAssignableFrom(DirectTDL.class)) {
                return new DirectTDL(dataLineInfo, lineFormat, lineBufferSize, this);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + String.valueOf(info));
    }

    @Override
    public int getMaxLines(Line.Info info) {
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo == null) {
            return 0;
        }
        if (fullInfo instanceof DataLine.Info) {
            return this.getMaxSimulLines();
        }
        return 0;
    }

    @Override
    protected void implOpen() throws LineUnavailableException {
    }

    @Override
    protected void implClose() {
    }

    @Override
    protected void implStart() {
    }

    @Override
    protected void implStop() {
    }

    int getMixerIndex() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getIndex();
    }

    int getDeviceID() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getDeviceID();
    }

    int getMaxSimulLines() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getMaxSimulLines();
    }

    private static void addFormat(Vector<AudioFormat> v, int bits, int frameSizeInBytes, int channels, float sampleRate, int encoding, boolean signed, boolean bigEndian) {
        AudioFormat.Encoding enc = null;
        switch (encoding) {
            case 0: {
                enc = signed ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
                break;
            }
            case 1: {
                enc = AudioFormat.Encoding.ULAW;
                if (bits == 8) break;
                if (Printer.err) {
                    Printer.err("DirectAudioDevice.addFormat called with ULAW, but bitsPerSample=" + bits);
                }
                bits = 8;
                frameSizeInBytes = channels;
                break;
            }
            case 2: {
                enc = AudioFormat.Encoding.ALAW;
                if (bits == 8) break;
                if (Printer.err) {
                    Printer.err("DirectAudioDevice.addFormat called with ALAW, but bitsPerSample=" + bits);
                }
                bits = 8;
                frameSizeInBytes = channels;
            }
        }
        if (enc == null) {
            if (Printer.err) {
                Printer.err("DirectAudioDevice.addFormat called with unknown encoding: " + encoding);
            }
            return;
        }
        if (frameSizeInBytes <= 0) {
            frameSizeInBytes = channels > 0 ? (bits + 7) / 8 * channels : -1;
        }
        v.add(new AudioFormat(enc, sampleRate, bits, channels, frameSizeInBytes, sampleRate, bigEndian));
    }

    protected static AudioFormat getSignOrEndianChangedFormat(AudioFormat format) {
        boolean isSigned = format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        boolean isUnsigned = format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        if (format.getSampleSizeInBits() > 8 && isSigned) {
            return new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), format.getFrameRate(), !format.isBigEndian());
        }
        if (format.getSampleSizeInBits() == 8 && (isSigned || isUnsigned)) {
            return new AudioFormat(isSigned ? AudioFormat.Encoding.PCM_UNSIGNED : AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), format.getFrameRate(), format.isBigEndian());
        }
        return null;
    }

    private static native void nGetFormats(int var0, int var1, boolean var2, Vector var3);

    private static native long nOpen(int var0, int var1, boolean var2, int var3, float var4, int var5, int var6, int var7, boolean var8, boolean var9, int var10) throws LineUnavailableException;

    private static native void nStart(long var0, boolean var2);

    private static native void nStop(long var0, boolean var2);

    private static native void nClose(long var0, boolean var2);

    private static native int nWrite(long var0, byte[] var2, int var3, int var4, int var5, float var6, float var7);

    private static native int nRead(long var0, byte[] var2, int var3, int var4, int var5);

    private static native int nGetBufferSize(long var0, boolean var2);

    private static native boolean nIsStillDraining(long var0, boolean var2);

    private static native void nFlush(long var0, boolean var2);

    private static native int nAvailable(long var0, boolean var2);

    private static native long nGetBytePosition(long var0, boolean var2, long var3);

    private static native void nSetBytePosition(long var0, boolean var2, long var3);

    private static native boolean nRequiresServicing(long var0, boolean var2);

    private static native void nService(long var0, boolean var2);

    private static final class DirectDLI
    extends DataLine.Info {
        final AudioFormat[] hardwareFormats;

        private DirectDLI(Class<?> clazz, AudioFormat[] formatArray, AudioFormat[] hardwareFormatArray, int minBuffer, int maxBuffer) {
            super(clazz, formatArray, minBuffer, maxBuffer);
            this.hardwareFormats = hardwareFormatArray;
        }

        public boolean isFormatSupportedInHardware(AudioFormat format) {
            if (format == null) {
                return false;
            }
            for (int i = 0; i < this.hardwareFormats.length; ++i) {
                if (!format.matches(this.hardwareFormats[i])) continue;
                return true;
            }
            return false;
        }

        private AudioFormat[] getHardwareFormats() {
            return this.hardwareFormats;
        }
    }

    private static final class DirectSDL
    extends DirectDL
    implements SourceDataLine {
        private DirectSDL(DataLine.Info info, AudioFormat format, int bufferSize, DirectAudioDevice mixer) {
            super(info, mixer, format, bufferSize, mixer.getMixerIndex(), mixer.getDeviceID(), true);
        }
    }

    private static final class DirectClip
    extends DirectDL
    implements Clip,
    Runnable,
    AutoClosingClip {
        private volatile Thread thread;
        private volatile byte[] audioData;
        private volatile int frameSize;
        private volatile int m_lengthInFrames;
        private volatile int loopCount;
        private volatile int clipBytePosition;
        private volatile int newFramePosition;
        private volatile int loopStartFrame;
        private volatile int loopEndFrame;
        private boolean autoclosing = false;

        private DirectClip(DataLine.Info info, AudioFormat format, int bufferSize, DirectAudioDevice mixer) {
            super(info, mixer, format, bufferSize, mixer.getMixerIndex(), mixer.getDeviceID(), true);
        }

        @Override
        public void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
            Toolkit.isFullySpecifiedAudioFormat(format);
            Toolkit.validateBuffer(format.getFrameSize(), bufferSize);
            byte[] newData = new byte[bufferSize];
            System.arraycopy(data, offset, newData, 0, bufferSize);
            this.open(format, newData, bufferSize / format.getFrameSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void open(AudioFormat format, byte[] data, int frameLength) throws LineUnavailableException {
            Toolkit.isFullySpecifiedAudioFormat(format);
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + String.valueOf(this.getFormat()) + " and frame lengh of " + this.getFrameLength());
                }
                this.audioData = data;
                this.frameSize = format.getFrameSize();
                this.m_lengthInFrames = frameLength;
                this.bytePosition = 0L;
                this.clipBytePosition = 0;
                this.newFramePosition = -1;
                this.loopStartFrame = 0;
                this.loopEndFrame = frameLength - 1;
                this.loopCount = 0;
                try {
                    this.open(format, (int)Toolkit.millis2bytes(format, 1000L));
                }
                catch (LineUnavailableException lue) {
                    this.audioData = null;
                    throw lue;
                }
                catch (IllegalArgumentException iae) {
                    this.audioData = null;
                    throw iae;
                }
                int priority = 6;
                this.thread = JSSecurityManager.createThread(this, "Direct Clip", true, priority, false);
                this.thread.start();
            }
            if (this.isAutoClosing()) {
                this.getEventDispatcher().autoClosingClipOpened(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
            Toolkit.isFullySpecifiedAudioFormat(stream.getFormat());
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                byte[] streamData = null;
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + String.valueOf(this.getFormat()) + " and frame lengh of " + this.getFrameLength());
                }
                int lengthInFrames = (int)stream.getFrameLength();
                int bytesRead = 0;
                int frameSize = stream.getFormat().getFrameSize();
                if (lengthInFrames != -1) {
                    int arraysize = lengthInFrames * frameSize;
                    if (arraysize < 0) {
                        throw new IllegalArgumentException("Audio data < 0");
                    }
                    try {
                        streamData = new byte[arraysize];
                    }
                    catch (OutOfMemoryError e) {
                        throw new IOException("Audio data is too big");
                    }
                    int bytesRemaining = arraysize;
                    int thisRead = 0;
                    while (bytesRemaining > 0 && thisRead >= 0) {
                        thisRead = stream.read(streamData, bytesRead, bytesRemaining);
                        if (thisRead > 0) {
                            bytesRead += thisRead;
                            bytesRemaining -= thisRead;
                            continue;
                        }
                        if (thisRead != 0) continue;
                        Thread.yield();
                    }
                } else {
                    byte[] tmp;
                    int maxReadLimit = Math.max(16384, frameSize);
                    DirectBAOS dbaos = new DirectBAOS();
                    try {
                        tmp = new byte[maxReadLimit];
                    }
                    catch (OutOfMemoryError e) {
                        throw new IOException("Audio data is too big");
                    }
                    int thisRead = 0;
                    while (thisRead >= 0) {
                        thisRead = stream.read(tmp, 0, tmp.length);
                        if (thisRead > 0) {
                            dbaos.write(tmp, 0, thisRead);
                            bytesRead += thisRead;
                            continue;
                        }
                        if (thisRead != 0) continue;
                        Thread.yield();
                    }
                    streamData = dbaos.getInternalBuffer();
                }
                lengthInFrames = bytesRead / frameSize;
                this.open(stream.getFormat(), streamData, lengthInFrames);
            }
        }

        @Override
        public int getFrameLength() {
            return this.m_lengthInFrames;
        }

        @Override
        public long getMicrosecondLength() {
            return Toolkit.frames2micros(this.getFormat(), this.getFrameLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFramePosition(int frames) {
            if (frames < 0) {
                frames = 0;
            } else if (frames >= this.getFrameLength()) {
                frames = this.getFrameLength();
            }
            if (this.doIO) {
                this.newFramePosition = frames;
            } else {
                this.clipBytePosition = frames * this.frameSize;
                this.newFramePosition = -1;
            }
            this.bytePosition = frames * this.frameSize;
            this.flush();
            Object object = this.lockNative;
            synchronized (object) {
                DirectAudioDevice.nSetBytePosition(this.id, this.isSource, frames * this.frameSize);
            }
        }

        @Override
        public long getLongFramePosition() {
            return super.getLongFramePosition();
        }

        @Override
        public void setMicrosecondPosition(long microseconds) {
            long frames = Toolkit.micros2frames(this.getFormat(), microseconds);
            this.setFramePosition((int)frames);
        }

        @Override
        public void setLoopPoints(int start, int end) {
            if (start < 0 || start >= this.getFrameLength()) {
                throw new IllegalArgumentException("illegal value for start: " + start);
            }
            if (end >= this.getFrameLength()) {
                throw new IllegalArgumentException("illegal value for end: " + end);
            }
            if (end == -1 && (end = this.getFrameLength() - 1) < 0) {
                end = 0;
            }
            if (end < start) {
                throw new IllegalArgumentException("End position " + end + "  preceeds start position " + start);
            }
            this.loopStartFrame = start;
            this.loopEndFrame = end;
        }

        @Override
        public void loop(int count) {
            this.loopCount = count;
            this.start();
        }

        @Override
        void implOpen(AudioFormat format, int bufferSize) throws LineUnavailableException {
            if (this.audioData == null) {
                throw new IllegalArgumentException("illegal call to open() in interface Clip");
            }
            super.implOpen(format, bufferSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void implClose() {
            Thread oldThread = this.thread;
            this.thread = null;
            this.doIO = false;
            if (oldThread != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
                try {
                    oldThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.implClose();
            this.audioData = null;
            this.newFramePosition = -1;
            this.getEventDispatcher().autoClosingClipClosed(this);
        }

        @Override
        void implStart() {
            super.implStart();
        }

        @Override
        void implStop() {
            super.implStop();
            this.loopCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread curThread = Thread.currentThread();
            while (this.thread == curThread) {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.doIO && this.thread == curThread) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                while (this.doIO && this.thread == curThread) {
                    long framePos;
                    int toWriteFrames;
                    int toWriteBytes;
                    if (this.newFramePosition >= 0) {
                        this.clipBytePosition = this.newFramePosition * this.frameSize;
                        this.newFramePosition = -1;
                    }
                    int endFrame = this.getFrameLength() - 1;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        endFrame = this.loopEndFrame;
                    }
                    if ((toWriteBytes = (toWriteFrames = (int)((long)endFrame - (framePos = (long)(this.clipBytePosition / this.frameSize)) + 1L)) * this.frameSize) > this.getBufferSize()) {
                        toWriteBytes = Toolkit.align(this.getBufferSize(), this.frameSize);
                    }
                    int written = this.write(this.audioData, this.clipBytePosition, toWriteBytes);
                    this.clipBytePosition += written;
                    if (!this.doIO || this.newFramePosition >= 0 || written < 0 || (framePos = (long)(this.clipBytePosition / this.frameSize)) <= (long)endFrame) continue;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        if (this.loopCount != -1) {
                            --this.loopCount;
                        }
                        this.newFramePosition = this.loopStartFrame;
                        continue;
                    }
                    this.drain();
                    this.stop();
                }
            }
        }

        @Override
        public boolean isAutoClosing() {
            return this.autoclosing;
        }

        @Override
        public void setAutoClosing(boolean value) {
            if (value != this.autoclosing) {
                if (this.isOpen()) {
                    if (value) {
                        this.getEventDispatcher().autoClosingClipOpened(this);
                    } else {
                        this.getEventDispatcher().autoClosingClipClosed(this);
                    }
                }
                this.autoclosing = value;
            }
        }

        @Override
        protected boolean requiresServicing() {
            return false;
        }
    }

    private static final class DirectTDL
    extends DirectDL
    implements TargetDataLine {
        private DirectTDL(DataLine.Info info, AudioFormat format, int bufferSize, DirectAudioDevice mixer) {
            super(info, mixer, format, bufferSize, mixer.getMixerIndex(), mixer.getDeviceID(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) {
            this.flushing = false;
            if (len == 0) {
                return 0;
            }
            if (len < 0) {
                throw new IllegalArgumentException("illegal len: " + len);
            }
            if (len % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("illegal request to read non-integral number of frames (" + len + " bytes, frameSize = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (off < 0) {
                throw new ArrayIndexOutOfBoundsException(off);
            }
            if ((long)off + (long)len > (long)b.length) {
                throw new ArrayIndexOutOfBoundsException(b.length);
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.isActive() && this.doIO) {
                    this.setActive(true);
                    this.setStarted(true);
                }
            }
            int read = 0;
            while (this.doIO && !this.flushing) {
                int thisRead;
                Object object2 = this.lockNative;
                synchronized (object2) {
                    thisRead = DirectAudioDevice.nRead(this.id, b, off, len, this.softwareConversionSize);
                    if (thisRead < 0) {
                        break;
                    }
                    this.bytePosition += (long)thisRead;
                    if (thisRead > 0) {
                        this.drained = false;
                    }
                }
                read += thisRead;
                if ((len -= thisRead) <= 0) break;
                off += thisRead;
                object2 = this.lock;
                synchronized (object2) {
                    try {
                        this.lock.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.flushing) {
                read = 0;
            }
            return read;
        }
    }

    private static class DirectBAOS
    extends ByteArrayOutputStream {
        DirectBAOS() {
        }

        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }

    private static class DirectDL
    extends AbstractDataLine
    implements EventDispatcher.LineMonitor {
        protected final int mixerIndex;
        protected final int deviceID;
        protected long id;
        protected int waitTime;
        protected volatile boolean flushing;
        protected final boolean isSource;
        protected volatile long bytePosition;
        protected volatile boolean doIO;
        protected volatile boolean stoppedWritten;
        protected volatile boolean drained;
        protected boolean monitoring;
        protected int softwareConversionSize = 0;
        protected AudioFormat hardwareFormat;
        private final Gain gainControl = new Gain();
        private final Mute muteControl = new Mute();
        private final Balance balanceControl = new Balance();
        private final Pan panControl = new Pan();
        private float leftGain;
        private float rightGain;
        protected volatile boolean noService;
        protected final Object lockNative = new Object();

        protected DirectDL(DataLine.Info info, DirectAudioDevice mixer, AudioFormat format, int bufferSize, int mixerIndex, int deviceID, boolean isSource) {
            super(info, mixer, null, format, bufferSize);
            this.mixerIndex = mixerIndex;
            this.deviceID = deviceID;
            this.waitTime = 10;
            this.isSource = isSource;
        }

        @Override
        void implOpen(AudioFormat format, int bufferSize) throws LineUnavailableException {
            AudioFormat newFormat;
            Toolkit.isFullySpecifiedAudioFormat(format);
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            int encoding = 0;
            if (format.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                encoding = 1;
            } else if (format.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
                encoding = 2;
            }
            if (bufferSize <= -1) {
                bufferSize = (int)Toolkit.millis2bytes(format, 500L);
            }
            DirectDLI ddli = null;
            if (this.info instanceof DirectDLI) {
                ddli = (DirectDLI)this.info;
            }
            if (this.isSource) {
                if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                    this.controls = new Control[0];
                } else if (format.getChannels() > 2 || format.getSampleSizeInBits() > 16) {
                    this.controls = new Control[0];
                } else {
                    if (format.getChannels() == 1) {
                        this.controls = new Control[2];
                    } else {
                        this.controls = new Control[4];
                        this.controls[2] = this.balanceControl;
                        this.controls[3] = this.panControl;
                    }
                    this.controls[0] = this.gainControl;
                    this.controls[1] = this.muteControl;
                }
            }
            this.hardwareFormat = format;
            this.softwareConversionSize = 0;
            if (ddli != null && !ddli.isFormatSupportedInHardware(format) && ddli.isFormatSupportedInHardware(newFormat = DirectAudioDevice.getSignOrEndianChangedFormat(format))) {
                this.hardwareFormat = newFormat;
                this.softwareConversionSize = format.getFrameSize() / format.getChannels();
            }
            bufferSize = bufferSize / format.getFrameSize() * format.getFrameSize();
            this.id = DirectAudioDevice.nOpen(this.mixerIndex, this.deviceID, this.isSource, encoding, this.hardwareFormat.getSampleRate(), this.hardwareFormat.getSampleSizeInBits(), this.hardwareFormat.getFrameSize(), this.hardwareFormat.getChannels(), this.hardwareFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED), this.hardwareFormat.isBigEndian(), bufferSize);
            if (this.id == 0L) {
                throw new LineUnavailableException("line with format " + String.valueOf(format) + " not supported.");
            }
            this.bufferSize = DirectAudioDevice.nGetBufferSize(this.id, this.isSource);
            if (this.bufferSize < 1) {
                this.bufferSize = bufferSize;
            }
            this.format = format;
            this.waitTime = (int)Toolkit.bytes2millis(format, this.bufferSize) / 4;
            if (this.waitTime < 10) {
                this.waitTime = 1;
            } else if (this.waitTime > 1000) {
                this.waitTime = 1000;
            }
            this.bytePosition = 0L;
            this.stoppedWritten = false;
            this.doIO = false;
            this.calcVolume();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void implStart() {
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            Object object = this.lockNative;
            synchronized (object) {
                DirectAudioDevice.nStart(this.id, this.isSource);
            }
            this.monitoring = this.requiresServicing();
            if (this.monitoring) {
                this.getEventDispatcher().addLineMonitor(this);
            }
            object = this.lock;
            synchronized (object) {
                this.doIO = true;
                if (this.isSource && this.stoppedWritten) {
                    this.setStarted(true);
                    this.setActive(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void implStop() {
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            if (this.monitoring) {
                this.getEventDispatcher().removeLineMonitor(this);
                this.monitoring = false;
            }
            Object object = this.lockNative;
            synchronized (object) {
                DirectAudioDevice.nStop(this.id, this.isSource);
            }
            object = this.lock;
            synchronized (object) {
                this.doIO = false;
                this.setActive(false);
                this.setStarted(false);
                this.lock.notifyAll();
            }
            this.stoppedWritten = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void implClose() {
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            if (this.monitoring) {
                this.getEventDispatcher().removeLineMonitor(this);
                this.monitoring = false;
            }
            this.doIO = false;
            long oldID = this.id;
            this.id = 0L;
            Object object = this.lockNative;
            synchronized (object) {
                DirectAudioDevice.nClose(oldID, this.isSource);
            }
            this.bytePosition = 0L;
            this.softwareConversionSize = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() {
            int a;
            if (this.id == 0L) {
                return 0;
            }
            Object object = this.lockNative;
            synchronized (object) {
                a = DirectAudioDevice.nAvailable(this.id, this.isSource);
            }
            return a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drain() {
            this.noService = true;
            int counter = 0;
            long startPos = this.getLongFramePosition();
            boolean posChanged = false;
            while (!this.drained) {
                Object object = this.lockNative;
                synchronized (object) {
                    if (this.id == 0L || !this.doIO || !DirectAudioDevice.nIsStillDraining(this.id, this.isSource)) {
                        break;
                    }
                }
                if (counter % 5 == 4) {
                    long thisFramePos = this.getLongFramePosition();
                    posChanged |= thisFramePos != startPos;
                    if (counter % 50 > 45) {
                        if (!posChanged) {
                            if (!Printer.err) break;
                            Printer.err("Native reports isDraining, but frame position does not increase!");
                            break;
                        }
                        posChanged = false;
                        startPos = thisFramePos;
                    }
                }
                ++counter;
                object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.doIO && this.id != 0L) {
                this.drained = true;
            }
            this.noService = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            if (this.id != 0L) {
                this.flushing = true;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
                object = this.lockNative;
                synchronized (object) {
                    if (this.id != 0L) {
                        DirectAudioDevice.nFlush(this.id, this.isSource);
                    }
                }
                this.drained = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLongFramePosition() {
            long pos;
            Object object = this.lockNative;
            synchronized (object) {
                pos = DirectAudioDevice.nGetBytePosition(this.id, this.isSource, this.bytePosition);
            }
            if (pos < 0L) {
                pos = 0L;
            }
            return pos / (long)this.getFormat().getFrameSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(byte[] b, int off, int len) {
            this.flushing = false;
            if (len == 0) {
                return 0;
            }
            if (len < 0) {
                throw new IllegalArgumentException("illegal len: " + len);
            }
            if (len % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("illegal request to write non-integral number of frames (" + len + " bytes, frameSize = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (off < 0) {
                throw new ArrayIndexOutOfBoundsException(off);
            }
            if ((long)off + (long)len > (long)b.length) {
                throw new ArrayIndexOutOfBoundsException(b.length);
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.isActive() && this.doIO) {
                    this.setActive(true);
                    this.setStarted(true);
                }
            }
            int written = 0;
            while (!this.flushing) {
                int thisWritten;
                Object object2 = this.lockNative;
                synchronized (object2) {
                    thisWritten = DirectAudioDevice.nWrite(this.id, b, off, len, this.softwareConversionSize, this.leftGain, this.rightGain);
                    if (thisWritten < 0) {
                        break;
                    }
                    this.bytePosition += (long)thisWritten;
                    if (thisWritten > 0) {
                        this.drained = false;
                    }
                }
                written += thisWritten;
                if (!this.doIO || (len -= thisWritten) <= 0) break;
                off += thisWritten;
                object2 = this.lock;
                synchronized (object2) {
                    try {
                        this.lock.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (written > 0 && !this.doIO) {
                this.stoppedWritten = true;
            }
            return written;
        }

        protected boolean requiresServicing() {
            return DirectAudioDevice.nRequiresServicing(this.id, this.isSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkLine() {
            Object object = this.lockNative;
            synchronized (object) {
                if (this.monitoring && this.doIO && this.id != 0L && !this.flushing && !this.noService) {
                    DirectAudioDevice.nService(this.id, this.isSource);
                }
            }
        }

        private void calcVolume() {
            if (this.getFormat() == null) {
                return;
            }
            if (this.muteControl.getValue()) {
                this.leftGain = 0.0f;
                this.rightGain = 0.0f;
                return;
            }
            float gain = this.gainControl.getLinearGain();
            if (this.getFormat().getChannels() == 1) {
                this.leftGain = gain;
                this.rightGain = gain;
            } else {
                float bal = this.balanceControl.getValue();
                if (bal < 0.0f) {
                    this.leftGain = gain;
                    this.rightGain = gain * (bal + 1.0f);
                } else {
                    this.leftGain = gain * (1.0f - bal);
                    this.rightGain = gain;
                }
            }
        }

        protected final class Gain
        extends FloatControl {
            private float linearGain;

            private Gain() {
                super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(2.0f), Math.abs(Toolkit.linearToDB(1.0f) - Toolkit.linearToDB(0.0f)) / 128.0f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
                this.linearGain = 1.0f;
            }

            @Override
            public void setValue(float newValue) {
                float newLinearGain = Toolkit.dBToLinear(newValue);
                super.setValue(Toolkit.linearToDB(newLinearGain));
                this.linearGain = newLinearGain;
                DirectDL.this.calcVolume();
            }

            float getLinearGain() {
                return this.linearGain;
            }
        }

        private final class Mute
        extends BooleanControl {
            private Mute() {
                super(BooleanControl.Type.MUTE, false, "True", "False");
            }

            @Override
            public void setValue(boolean newValue) {
                super.setValue(newValue);
                DirectDL.this.calcVolume();
            }
        }

        private final class Balance
        extends FloatControl {
            private Balance() {
                super(FloatControl.Type.BALANCE, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
            }

            @Override
            public void setValue(float newValue) {
                this.setValueImpl(newValue);
                DirectDL.this.panControl.setValueImpl(newValue);
                DirectDL.this.calcVolume();
            }

            void setValueImpl(float newValue) {
                super.setValue(newValue);
            }
        }

        private final class Pan
        extends FloatControl {
            private Pan() {
                super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
            }

            @Override
            public void setValue(float newValue) {
                this.setValueImpl(newValue);
                DirectDL.this.balanceControl.setValueImpl(newValue);
                DirectDL.this.calcVolume();
            }

            void setValueImpl(float newValue) {
                super.setValue(newValue);
            }
        }
    }
}

