/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.Printer;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.sound.sampled.AudioPermission;

final class JSSecurityManager {
    private JSSecurityManager() {
    }

    static void checkRecordPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AudioPermission("record"));
        }
    }

    static void loadProperties(Properties properties) {
        String customFile = AccessController.doPrivileged(() -> System.getProperty("javax.sound.config.file"));
        if (customFile != null && JSSecurityManager.loadPropertiesImpl(properties, customFile, new String[0])) {
            return;
        }
        AccessController.doPrivileged(() -> {
            String home = System.getProperty("java.home");
            if (home == null) {
                throw new Error("Can't find java.home ??");
            }
            JSSecurityManager.loadPropertiesImpl(properties, home, "conf", "sound.properties");
            return null;
        });
    }

    private static boolean loadPropertiesImpl(Properties properties, String first, String ... more) {
        boolean bl;
        block8: {
            Path fname = Paths.get(first, more);
            BufferedReader reader = Files.newBufferedReader(fname);
            try {
                properties.load(reader);
                bl = true;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return false;
                }
            }
            ((Reader)reader).close();
        }
        return bl;
    }

    static Thread createThread(Runnable runnable, String threadName, boolean isDaemon, int priority, boolean doStart) {
        String name = threadName != null ? threadName : "JSSM Thread";
        Thread thread = new Thread(null, runnable, threadName, 0L, false);
        thread.setDaemon(isDaemon);
        if (priority >= 0) {
            thread.setPriority(priority);
        }
        if (doStart) {
            thread.start();
        }
        return thread;
    }

    static synchronized <T> List<T> getProviders(final Class<T> providerClass) {
        ArrayList p = new ArrayList(7);
        PrivilegedAction psAction = new PrivilegedAction<Iterator<T>>(){

            @Override
            public Iterator<T> run() {
                return ServiceLoader.load(providerClass).iterator();
            }
        };
        final Iterator ps = (Iterator)AccessController.doPrivileged(psAction);
        PrivilegedAction<Boolean> hasNextAction = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ps.hasNext();
            }
        };
        while (AccessController.doPrivileged(hasNextAction).booleanValue()) {
            try {
                Object provider = ps.next();
                if (!providerClass.isInstance(provider)) continue;
                p.add(0, provider);
            }
            catch (Throwable t) {
                if (!Printer.err) continue;
                t.printStackTrace();
            }
        }
        return p;
    }
}

