/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;

public final class UlawCodec
extends FormatConversionProvider {
    private static final byte[] ULAW_TABH = new byte[256];
    private static final byte[] ULAW_TABL = new byte[256];
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW, AudioFormat.Encoding.PCM_SIGNED};
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return this.getSourceEncodings();
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (AudioFormat.Encoding.PCM_SIGNED.equals(sourceFormat.getEncoding())) {
            if (sourceFormat.getSampleSizeInBits() == 16) {
                AudioFormat.Encoding[] enc = new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW};
                return enc;
            }
            return new AudioFormat.Encoding[0];
        }
        if (AudioFormat.Encoding.ULAW.equals(sourceFormat.getEncoding())) {
            if (sourceFormat.getSampleSizeInBits() == 8) {
                AudioFormat.Encoding[] enc = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
                return enc;
            }
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[0];
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        Objects.requireNonNull(targetEncoding);
        Objects.requireNonNull(sourceFormat);
        if (AudioFormat.Encoding.PCM_SIGNED.equals(targetEncoding) && AudioFormat.Encoding.ULAW.equals(sourceFormat.getEncoding()) || AudioFormat.Encoding.ULAW.equals(targetEncoding) && AudioFormat.Encoding.PCM_SIGNED.equals(sourceFormat.getEncoding())) {
            return this.getOutputFormats(sourceFormat);
        }
        return new AudioFormat[0];
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioFormat.Encoding sourceEncoding = sourceFormat.getEncoding();
        if (!this.isConversionSupported(targetEncoding, sourceStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + sourceStream.getFormat().toString() + " to " + targetEncoding.toString());
        }
        if (sourceEncoding.equals(targetEncoding)) {
            return sourceStream;
        }
        AudioFormat targetFormat = null;
        if (AudioFormat.Encoding.ULAW.equals(sourceEncoding) && AudioFormat.Encoding.PCM_SIGNED.equals(targetEncoding)) {
            targetFormat = new AudioFormat(targetEncoding, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), 2 * sourceFormat.getChannels(), sourceFormat.getSampleRate(), sourceFormat.isBigEndian());
        } else if (AudioFormat.Encoding.PCM_SIGNED.equals(sourceEncoding) && AudioFormat.Encoding.ULAW.equals(targetEncoding)) {
            targetFormat = new AudioFormat(targetEncoding, sourceFormat.getSampleRate(), 8, sourceFormat.getChannels(), sourceFormat.getChannels(), sourceFormat.getSampleRate(), false);
        } else {
            throw new IllegalArgumentException("Unsupported conversion: " + sourceStream.getFormat().toString() + " to " + targetEncoding.toString());
        }
        return this.getConvertedStream(targetFormat, sourceStream);
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (!this.isConversionSupported(targetFormat, sourceStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + sourceStream.getFormat().toString() + " to " + targetFormat.toString());
        }
        return this.getConvertedStream(targetFormat, sourceStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat outputFormat, AudioInputStream stream) {
        AudioInputStream cs = null;
        AudioFormat inputFormat = stream.getFormat();
        cs = inputFormat.matches(outputFormat) ? stream : new UlawCodecStream(this, stream, outputFormat);
        return cs;
    }

    private AudioFormat[] getOutputFormats(AudioFormat inputFormat) {
        AudioFormat format;
        ArrayList<AudioFormat> formats = new ArrayList<AudioFormat>();
        if (inputFormat.getSampleSizeInBits() == 16 && AudioFormat.Encoding.PCM_SIGNED.equals(inputFormat.getEncoding())) {
            format = new AudioFormat(AudioFormat.Encoding.ULAW, inputFormat.getSampleRate(), 8, inputFormat.getChannels(), inputFormat.getChannels(), inputFormat.getSampleRate(), false);
            formats.add(format);
        }
        if (inputFormat.getSampleSizeInBits() == 8 && AudioFormat.Encoding.ULAW.equals(inputFormat.getEncoding())) {
            format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), 16, inputFormat.getChannels(), inputFormat.getChannels() * 2, inputFormat.getSampleRate(), false);
            formats.add(format);
            format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), 16, inputFormat.getChannels(), inputFormat.getChannels() * 2, inputFormat.getSampleRate(), true);
            formats.add(format);
        }
        AudioFormat[] formatArray = new AudioFormat[formats.size()];
        for (int i = 0; i < formatArray.length; ++i) {
            formatArray[i] = (AudioFormat)formats.get(i);
        }
        return formatArray;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int ulaw = ~i;
            int t = (((ulaw &= 0xFF) & 0xF) << 3) + 132;
            t = (ulaw & 0x80) != 0 ? 132 - t : (t <<= (ulaw & 0x70) >> 4) - 132;
            UlawCodec.ULAW_TABL[i] = (byte)(t & 0xFF);
            UlawCodec.ULAW_TABH[i] = (byte)(t >> 8 & 0xFF);
        }
    }

    private final class UlawCodecStream
    extends AudioInputStream {
        private static final int tempBufferSize = 64;
        private byte[] tempBuffer = null;
        boolean encode = false;
        AudioFormat encodeFormat;
        AudioFormat decodeFormat;
        byte[] tabByte1 = null;
        byte[] tabByte2 = null;
        int highByte = 0;
        int lowByte = 1;

        UlawCodecStream(UlawCodec ulawCodec, AudioInputStream stream, AudioFormat outputFormat) {
            super(stream, outputFormat, -1L);
            boolean PCMIsBigEndian;
            AudioFormat inputFormat = stream.getFormat();
            if (!ulawCodec.isConversionSupported(outputFormat, inputFormat)) {
                throw new IllegalArgumentException("Unsupported conversion: " + inputFormat.toString() + " to " + outputFormat.toString());
            }
            if (AudioFormat.Encoding.ULAW.equals(inputFormat.getEncoding())) {
                this.encode = false;
                this.encodeFormat = inputFormat;
                this.decodeFormat = outputFormat;
                PCMIsBigEndian = outputFormat.isBigEndian();
            } else {
                this.encode = true;
                this.encodeFormat = outputFormat;
                this.decodeFormat = inputFormat;
                PCMIsBigEndian = inputFormat.isBigEndian();
                this.tempBuffer = new byte[64];
            }
            if (PCMIsBigEndian) {
                this.tabByte1 = ULAW_TABH;
                this.tabByte2 = ULAW_TABL;
                this.highByte = 0;
                this.lowByte = 1;
            } else {
                this.tabByte1 = ULAW_TABL;
                this.tabByte2 = ULAW_TABH;
                this.highByte = 1;
                this.lowByte = 0;
            }
            if (stream instanceof AudioInputStream) {
                this.frameLength = stream.getFrameLength();
            }
            this.framePos = 0L;
            this.frameSize = inputFormat.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
        }

        private short search(short val, short[] table, short size) {
            for (short i = 0; i < size; i = (short)(i + 1)) {
                if (val > table[i]) continue;
                return i;
            }
            return size;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, b.length) == 1) {
                return b[1] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i;
            if (len % this.frameSize != 0) {
                len -= len % this.frameSize;
            }
            if (this.encode) {
                int readLen;
                int BIAS = 132;
                int readCount = 0;
                int currentPos = off;
                int readLeft = len * 2;
                int n = readLen = readLeft > 64 ? 64 : readLeft;
                while ((readCount = super.read(this.tempBuffer, 0, readLen)) > 0) {
                    for (int i2 = 0; i2 < readCount; i2 += 2) {
                        byte enc;
                        int mask;
                        short sample = (short)(this.tempBuffer[i2 + this.highByte] << 8 & 0xFF00);
                        if ((sample = (short)(sample | (short)((short)this.tempBuffer[i2 + this.lowByte] & 0xFF))) < 0) {
                            sample = (short)(BIAS - sample);
                            mask = 127;
                        } else {
                            sample = (short)(sample + BIAS);
                            mask = 255;
                        }
                        short seg = this.search(sample, seg_end, (short)8);
                        if (seg >= 8) {
                            enc = (byte)(0x7F ^ mask);
                        } else {
                            enc = (byte)(seg << 4 | sample >> seg + 3 & 0xF);
                            enc = (byte)(enc ^ mask);
                        }
                        b[currentPos] = enc;
                        ++currentPos;
                    }
                    readLen = (readLeft -= readCount) > 64 ? 64 : readLeft;
                }
                if (currentPos == off && readCount < 0) {
                    return readCount;
                }
                return currentPos - off;
            }
            int readOffset = off + len / 2;
            int readLen = len / 2;
            int readCount = super.read(b, readOffset, readLen);
            if (readCount < 0) {
                return readCount;
            }
            for (i = off; i < off + readCount * 2; i += 2) {
                b[i] = this.tabByte1[b[readOffset] & 0xFF];
                b[i + 1] = this.tabByte2[b[readOffset] & 0xFF];
                ++readOffset;
            }
            return i - off;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.encode ? super.skip(n * 2L) / 2L : super.skip(n / 2L) * 2L;
        }
    }
}

