/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client;

import io.github.tofodroid.mods.mimi.client.midi.MidiDataManager;
import io.github.tofodroid.mods.mimi.client.midi.synth.MidiMultiSynthManager;
import io.github.tofodroid.mods.mimi.common.Proxy;
import io.github.tofodroid.mods.mimi.common.midi.FilesystemMidiFileProvider;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.network.ServerTimeSyncPacket;
import io.github.tofodroid.mods.mimi.util.TimeUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.world.entity.player.Player;

public class ClientProxy
implements Proxy {
    private MidiMultiSynthManager MIDI_SYNTH;
    private MidiDataManager MIDI_DATA;
    private FilesystemMidiFileProvider CLIENT_MIDI_FILES;
    private FilesystemMidiFileProvider SERVER_MIDI_FILES;
    private Long startSyncEpoch = null;
    private Long serverStartEpoch = 0L;
    private Boolean initialized = false;

    @Override
    public void init() {
        this.MIDI_SYNTH = new MidiMultiSynthManager();
        this.MIDI_DATA = new MidiDataManager();
        this.CLIENT_MIDI_FILES = new FilesystemMidiFileProvider(false);
        this.CLIENT_MIDI_FILES.loadSongs();
        this.SERVER_MIDI_FILES = new FilesystemMidiFileProvider(true);
        this.SERVER_MIDI_FILES.loadSongs();
        this.initialized = true;
    }

    @Override
    public Boolean isClient() {
        return true;
    }

    @Override
    public Long getServerStartEpoch() {
        return this.serverStartEpoch;
    }

    @Override
    public FilesystemMidiFileProvider clientMidiFiles() {
        return this.CLIENT_MIDI_FILES;
    }

    @Override
    public FilesystemMidiFileProvider serverMidiFiles() {
        return this.SERVER_MIDI_FILES;
    }

    public MidiMultiSynthManager getMidiSynth() {
        return this.MIDI_SYNTH;
    }

    public MidiDataManager getMidiData() {
        return this.MIDI_DATA;
    }

    public void handleTimeSyncPacket(ServerTimeSyncPacket message) {
        ServerData currentServer = Minecraft.getInstance().getCurrentServer();
        if (currentServer != null) {
            if (this.startSyncEpoch == null) {
                this.startSyncEpoch = TimeUtils.getNowTime();
                NetworkProxy.sendToServer(new ServerTimeSyncPacket(0L, false));
            } else {
                this.serverStartEpoch = TimeUtils.getNowTime() - message.currentServerMilli - (TimeUtils.getNowTime() - this.startSyncEpoch) / 2L;
                this.startSyncEpoch = null;
            }
        }
    }

    @Override
    public Boolean isInitialized() {
        return this.initialized;
    }

    public void onLocalPlayerLogout() {
        if (this.isInitialized().booleanValue()) {
            this.getMidiData().handleLoginLogout();
            this.getMidiSynth().handleLogout();
        }
    }

    public void onLocalPlayerLogin() {
        if (this.isInitialized().booleanValue()) {
            this.getMidiData().handleLoginLogout();
            this.getMidiSynth().handleLogin();
        }
    }

    public void onClientTick() {
        if (this.isInitialized().booleanValue()) {
            this.getMidiData().handleClientTick();
            this.getMidiSynth().handleClientTick();
        }
    }

    public void onPlayerTick(Player player) {
        if (this.isInitialized().booleanValue()) {
            this.getMidiData().handlePlayerTick(player);
            this.getMidiSynth().handlePlayerTick(player);
        }
    }
}

