/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class BaseContainerGui<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final Integer STANDARD_BUTTON_SIZE = 15;
    protected ResourceLocation guiTexture;
    protected Integer TEXTURE_SIZE;
    protected Integer GUI_WIDTH;
    protected Integer GUI_HEIGHT;
    protected Integer START_X;
    protected Integer START_Y;

    public BaseContainerGui(T container, Inventory inv, Integer gWidth, Integer gHeight, Integer textureSize, String textureResource, Component textComponent) {
        super(container, inv, textComponent);
        this.guiTexture = ResourceUtils.newModLocation(textureResource);
        this.TEXTURE_SIZE = textureSize;
        this.GUI_HEIGHT = gHeight;
        this.GUI_WIDTH = gWidth;
        this.imageWidth = textureSize;
        this.imageHeight = textureSize;
    }

    public void init() {
        this.START_X = (this.width - this.GUI_WIDTH) / 2;
        this.START_Y = (this.height - this.GUI_HEIGHT) / 2;
        this.leftPos = this.START_X;
        this.topPos = this.START_Y;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics = this.renderGraphics(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics = this.renderText(graphics, mouseX, mouseY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.shouldRenderBackground().booleanValue()) {
            this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected Boolean shouldRenderBackground() {
        return true;
    }

    public boolean doCloseOnInventoryKeyPress() {
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.doCloseOnInventoryKeyPress() && this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return false;
    }

    protected void setAlpha(float alpha) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
    }

    protected abstract GuiGraphics renderGraphics(GuiGraphics var1, int var2, int var3, float var4);

    protected abstract GuiGraphics renderText(GuiGraphics var1, int var2, int var3);

    protected void blitAbsolute(GuiGraphics graphics, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        CommonGuiUtils.blitAbsolute(graphics, this.guiTexture, renderStartX, renderStartY, atlasStartX, atlasStartY, sizeX, sizeY, textureSizeX, textureSizeY);
    }

    protected void blitAbsolute(GuiGraphics graphics, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY) {
        CommonGuiUtils.blitAbsolute(graphics, this.guiTexture, renderStartX, renderStartY, atlasStartX, atlasStartY, sizeX, sizeY, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
    }

    protected void blitAbsolute(GuiGraphics graphics, ResourceLocation texture, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        CommonGuiUtils.blitAbsolute(graphics, texture, renderStartX, renderStartY, atlasStartX, atlasStartY, sizeX, sizeY, textureSizeX, textureSizeY);
    }

    protected void blitAbsolute(GuiGraphics graphics, ResourceLocation texture, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY) {
        CommonGuiUtils.blitAbsolute(graphics, texture, renderStartX, renderStartY, atlasStartX, atlasStartY, sizeX, sizeY, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
    }

    protected void drawStringAbsolute(GuiGraphics graphics, Font font, String string, Integer renderStartX, Integer renderStartY, Integer color) {
        CommonGuiUtils.drawStringAbsolute(graphics, font, string, renderStartX, renderStartY, color);
    }

    protected void drawStringAbsolute(GuiGraphics graphics, String string, Integer renderStartX, Integer renderStartY, Integer color) {
        CommonGuiUtils.drawStringAbsolute(graphics, this.font, string, renderStartX, renderStartY, color);
    }

    protected void blitRelative(GuiGraphics graphics, int relativeStartX, int relativeStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        CommonGuiUtils.blitAbsolute(graphics, this.guiTexture, this.START_X + relativeStartX, this.START_Y + relativeStartY, atlasStartX, atlasStartY, sizeX, sizeY, textureSizeX, textureSizeY);
    }

    protected void blitRelative(GuiGraphics graphics, int relativeStartX, int relativeStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY) {
        CommonGuiUtils.blitAbsolute(graphics, this.guiTexture, this.START_X + relativeStartX, this.START_Y + relativeStartY, atlasStartX, atlasStartY, sizeX, sizeY, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
    }

    protected void blitRelative(GuiGraphics graphics, ResourceLocation texture, int relativeStartX, int relativeStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        CommonGuiUtils.blitAbsolute(graphics, texture, this.START_X + relativeStartX, this.START_Y + relativeStartY, atlasStartX, atlasStartY, sizeX, sizeY, textureSizeX, textureSizeY);
    }

    protected void blitRelative(GuiGraphics graphics, ResourceLocation texture, int relativeStartX, int relativeStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY) {
        CommonGuiUtils.blitAbsolute(graphics, texture, this.START_X + relativeStartX, this.START_Y + relativeStartY, atlasStartX, atlasStartY, sizeX, sizeY, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
    }

    protected void drawStringRelative(GuiGraphics graphics, Font font, String string, Integer relativeStartX, Integer relativeStartY, Integer color) {
        CommonGuiUtils.drawStringAbsolute(graphics, font, string, this.START_X + relativeStartX, this.START_Y + relativeStartY, color);
    }

    protected void drawStringRelative(GuiGraphics graphics, String string, Integer relativeStartX, Integer relativeStartY, Integer color) {
        CommonGuiUtils.drawStringAbsolute(graphics, this.font, string, this.START_X + relativeStartX, this.START_Y + relativeStartY, color);
    }
}

