/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.MidiChannelToggleWidget;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.network.ConfigurableMidiTileSyncPacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuiConductor
extends BaseGui {
    private static final Vector2Int MIDI_CHANNEL_WIDGET_COORDS = new Vector2Int(6, 26);
    private static final Vector2Int NOTE_LETTER_BUTTON_COORDS = new Vector2Int(181, 41);
    private static final Vector2Int NOTE_OCTAVE_BUTTON_COORDS = new Vector2Int(203, 41);
    private MidiChannelToggleWidget midiChannelToggle;
    private final ItemStack conductorStack;
    private final BlockPos tilePos;
    private Byte broadcastNote;

    public GuiConductor(BlockPos tilePos, ItemStack conductorStack) {
        super(272, 99, 272, "textures/gui/container_conductor.png", "item.MIMIMod.gui_conductor");
        this.tilePos = tilePos;
        if (conductorStack == null || conductorStack.isEmpty()) {
            MIMIMod.LOGGER.error("Conductor stack is null or empty. Force closing GUI!");
            Minecraft.getInstance().forceSetScreen((Screen)null);
            this.conductorStack = null;
            return;
        }
        this.conductorStack = new ItemStack((ItemLike)conductorStack.getItem(), conductorStack.getCount());
        this.conductorStack.applyComponents(conductorStack.getComponents());
    }

    @Override
    public void init() {
        super.init();
        this.broadcastNote = MidiNbtDataUtils.getBroadcastNote(this.conductorStack);
        this.midiChannelToggle = new MidiChannelToggleWidget(this.conductorStack, new Vector2Int(this.START_X, this.START_Y), MIDI_CHANNEL_WIDGET_COORDS);
    }

    public void syncConductorToServer() {
        NetworkProxy.sendToServer(new ConfigurableMidiTileSyncPacket(this.conductorStack, this.tilePos, null));
    }

    public boolean mouseClicked(double dmouseX, double dmouseY, int mouseButton) {
        int imouseX = (int)Math.round(dmouseX);
        int imouseY = (int)Math.round(dmouseY);
        if (this.midiChannelToggle.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncConductorToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(NOTE_LETTER_BUTTON_COORDS)).booleanValue()) {
            this.shiftBroadcastNoteLetter();
            this.syncConductorToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(NOTE_OCTAVE_BUTTON_COORDS)).booleanValue()) {
            this.shiftBroadcastNoteOctave();
            this.syncConductorToServer();
        }
        return super.mouseClicked(dmouseX, dmouseY, mouseButton);
    }

    @Override
    protected GuiGraphics renderGraphics(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.blitAbsolute(graphics, this.guiTexture, this.START_X, this.START_Y, 0.0f, 0.0f, this.GUI_WIDTH, this.GUI_HEIGHT, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        this.midiChannelToggle.renderGraphics(graphics, mouseX, mouseY);
        return graphics;
    }

    @Override
    protected GuiGraphics renderText(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawStringAbsolute(graphics, this.font, MidiNbtDataUtils.getMidiNoteAsString(this.broadcastNote), this.START_X + 224, this.START_Y + 45, -16718336);
        this.midiChannelToggle.renderText(graphics, this.font, mouseX, mouseY);
        return graphics;
    }

    protected void shiftBroadcastNoteLetter() {
        if (this.broadcastNote % 12 < 11) {
            if (this.broadcastNote + 1 <= 127) {
                Byte by = this.broadcastNote;
                this.broadcastNote = (byte)(this.broadcastNote + 1);
            } else {
                this.broadcastNote = (byte)(this.broadcastNote - this.broadcastNote % 12);
            }
        } else {
            this.broadcastNote = (byte)(this.broadcastNote - 11);
        }
        MidiNbtDataUtils.setBroadcastNote(this.conductorStack, this.broadcastNote);
    }

    protected void shiftBroadcastNoteOctave() {
        this.broadcastNote = this.broadcastNote / 12 < 10 ? (this.broadcastNote + 12 <= 127 ? Byte.valueOf((byte)(this.broadcastNote + 12)) : Byte.valueOf((byte)(this.broadcastNote + -108))) : Byte.valueOf((byte)(this.broadcastNote - 120));
        MidiNbtDataUtils.setBroadcastNote(this.conductorStack, this.broadcastNote);
    }
}

