/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.InvertSignalWidget;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.block.BlockEffectEmitter;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.network.EffectEmitterUpdatePacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileEffectEmitter;
import io.github.tofodroid.mods.mimi.util.MathUtils;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GuiEffectEmitter
extends BaseGui {
    private static final Integer DEFAULT_TEXT_FIELD_COLOR = 0xE0E0E0;
    private static final Vector2Int INVERT_SIGNAL_WIDGET_COORDS = new Vector2Int(281, 5);
    private static final Vector2Int SOUND_BOX_COORDS = new Vector2Int(46, 32);
    private static final Vector2Int PLAY_SOUND_BUTTON_COORDS = new Vector2Int(278, 29);
    private static final Vector2Int VOL_DOWN_BUTTON_COORDS = new Vector2Int(30, 51);
    private static final Vector2Int VOL_UP_BUTTON_COORDS = new Vector2Int(66, 51);
    private static final Vector2Int VOL_TEXT_COORDS = new Vector2Int(50, 55);
    private static final Vector2Int PITCH_DOWN_BUTTON_COORDS = new Vector2Int(116, 51);
    private static final Vector2Int PITCH_UP_BUTTON_COORDS = new Vector2Int(152, 51);
    private static final Vector2Int PITCH_TEXT_COORDS = new Vector2Int(136, 55);
    private static final Vector2Int S_LOOP_DOWN_BUTTON_COORDS = new Vector2Int(230, 51);
    private static final Vector2Int S_LOOP_UP_BUTTON_COORDS = new Vector2Int(278, 51);
    private static final Vector2Int S_LOOP_TEXT_COORDS = new Vector2Int(250, 55);
    private static final Vector2Int PARTICLE_BOX_COORDS = new Vector2Int(51, 81);
    private static final Vector2Int PLAY_PARTICLE_BUTTON_COORDS = new Vector2Int(278, 78);
    private static final Vector2Int SIDE_DOWN_BUTTON_COORDS = new Vector2Int(32, 100);
    private static final Vector2Int SIDE_UP_BUTTON_COORDS = new Vector2Int(62, 100);
    private static final Vector2Int SIDE_TEXT_COORDS = new Vector2Int(52, 104);
    private static final Vector2Int SPEED_X_DOWN_BUTTON_COORDS = new Vector2Int(116, 100);
    private static final Vector2Int SPEED_X_UP_BUTTON_COORDS = new Vector2Int(158, 100);
    private static final Vector2Int SPEED_X_TEXT_COORDS = new Vector2Int(136, 107);
    private static final Vector2Int SPEED_Y_DOWN_BUTTON_COORDS = new Vector2Int(176, 100);
    private static final Vector2Int SPEED_Y_UP_BUTTON_COORDS = new Vector2Int(218, 100);
    private static final Vector2Int SPEED_Y_TEXT_COORDS = new Vector2Int(196, 107);
    private static final Vector2Int SPEED_Z_DOWN_BUTTON_COORDS = new Vector2Int(236, 100);
    private static final Vector2Int SPEED_Z_UP_BUTTON_COORDS = new Vector2Int(278, 100);
    private static final Vector2Int SPEED_Z_TEXT_COORDS = new Vector2Int(256, 107);
    private static final Vector2Int SPREAD_DOWN_BUTTON_COORDS = new Vector2Int(36, 122);
    private static final Vector2Int SPREAD_UP_BUTTON_COORDS = new Vector2Int(66, 122);
    private static final Vector2Int SPREAD_TEXT_COORDS = new Vector2Int(56, 126);
    private static final Vector2Int COUNT_DOWN_BUTTON_COORDS = new Vector2Int(116, 122);
    private static final Vector2Int COUNT_UP_BUTTON_COORDS = new Vector2Int(152, 122);
    private static final Vector2Int COUNT_TEXT_COORDS = new Vector2Int(136, 126);
    private static final Vector2Int P_LOOP_DOWN_BUTTON_COORDS = new Vector2Int(230, 122);
    private static final Vector2Int P_LOOP_UP_BUTTON_COORDS = new Vector2Int(278, 122);
    private static final Vector2Int P_LOOP_TEXT_COORDS = new Vector2Int(250, 126);
    private InvertSignalWidget invertSignalWidget;
    private EditBox soundBox;
    private EditBox particleBox;
    private final Level world;
    private final ItemStack emitterStack;
    private final BlockPos tilePos;
    private final InteractionHand handIn;
    private Boolean shiftModifier = false;
    private Boolean settingsOnly = false;

    public GuiEffectEmitter(Level world, BlockPos tilePos, InteractionHand handIn, ItemStack emitterStack) {
        super(302, 146, 302, "textures/gui/gui_effect_emitter.png", "item.MIMIMod.gui_effect_emitter");
        this.tilePos = tilePos;
        this.handIn = handIn;
        this.world = world;
        if (emitterStack == null || emitterStack.isEmpty()) {
            MIMIMod.LOGGER.error("Emitter stack is null or empty. Force closing GUI!");
            Minecraft.getInstance().forceSetScreen((Screen)null);
            this.emitterStack = null;
            return;
        }
        if (emitterStack.getItem().equals((Object)ModItems.SETTINGSSYNC)) {
            this.settingsOnly = true;
        }
        this.emitterStack = new ItemStack((ItemLike)emitterStack.getItem(), emitterStack.getCount());
        this.emitterStack.applyComponents(emitterStack.getComponents());
    }

    @Override
    public void init() {
        super.init();
        this.invertSignalWidget = new InvertSignalWidget(this.emitterStack, new Vector2Int(this.START_X, this.START_Y), INVERT_SIGNAL_WIDGET_COORDS);
        this.soundBox = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.START_X + GuiEffectEmitter.SOUND_BOX_COORDS.x, this.START_Y + GuiEffectEmitter.SOUND_BOX_COORDS.y, 229, 10, CommonComponents.EMPTY));
        this.soundBox.setMaxLength(512);
        this.soundBox.setValue(TagUtils.getStringOrDefault((DataComponentHolder)this.emitterStack, "sound", ""));
        this.soundBox.setResponder(this::handleSoundChange);
        this.soundBox.setTextColor(this.validateSound(this.soundBox.getValue()) != false ? DEFAULT_TEXT_FIELD_COLOR : 13112340);
        this.particleBox = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.START_X + GuiEffectEmitter.PARTICLE_BOX_COORDS.x, this.START_Y + GuiEffectEmitter.PARTICLE_BOX_COORDS.y, 224, 10, CommonComponents.EMPTY));
        this.particleBox.setMaxLength(512);
        this.particleBox.setValue(TagUtils.getStringOrDefault((DataComponentHolder)this.emitterStack, "particle", ""));
        this.particleBox.setResponder(this::handleParticleChange);
        this.particleBox.setTextColor(this.validateParticle(this.particleBox.getValue()) != false ? DEFAULT_TEXT_FIELD_COLOR : 13112340);
    }

    @Override
    public boolean doCloseOnInventoryKeyPress() {
        return !this.soundBox.isFocused() && !this.particleBox.isFocused();
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        super.keyPressed(keyCode, scanCode, modifiers);
        if (keyCode == 340 || keyCode == 344) {
            this.shiftModifier = true;
        }
        return true;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        super.keyReleased(keyCode, scanCode, modifiers);
        if (keyCode == 340 || keyCode == 344) {
            this.shiftModifier = false;
        }
        return true;
    }

    public boolean mouseClicked(double dmouseX, double dmouseY, int mouseButton) {
        int addAmount;
        Boolean mouseModifier = this.shiftModifier == false && mouseButton == 1;
        int imouseX = (int)Math.round(dmouseX);
        int imouseY = (int)Math.round(dmouseY);
        int n = addAmount = this.shiftModifier != false ? 10000 : 1;
        if (this.invertSignalWidget.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncEffectEmitterToServer();
        } else if (!this.settingsOnly.booleanValue() && CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(PLAY_SOUND_BUTTON_COORDS)).booleanValue()) {
            this.playCurrentSound();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(VOL_DOWN_BUTTON_COORDS)).booleanValue()) {
            Byte volume = TagUtils.getByteOrDefault(this.emitterStack, "volume", 5);
            addAmount = mouseModifier != false ? 2 : addAmount;
            volume = MathUtils.addClamped(volume, (Integer)(-addAmount), (Integer)0, (Integer)10);
            TagUtils.setOrRemoveByte(this.emitterStack, "volume", volume);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(VOL_UP_BUTTON_COORDS)).booleanValue()) {
            Byte volume = TagUtils.getByteOrDefault(this.emitterStack, "volume", 5);
            addAmount = mouseModifier != false ? 2 : addAmount;
            volume = MathUtils.addClamped(volume, (Integer)addAmount, (Integer)0, (Integer)10);
            TagUtils.setOrRemoveByte(this.emitterStack, "volume", volume);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(PITCH_DOWN_BUTTON_COORDS)).booleanValue()) {
            Byte pitch = TagUtils.getByteOrDefault(this.emitterStack, "pitch", 0);
            addAmount = mouseModifier != false ? 2 : addAmount;
            pitch = MathUtils.addClamped(pitch, (Integer)(-addAmount), (Integer)-2, (Integer)2);
            TagUtils.setOrRemoveByte(this.emitterStack, "pitch", pitch);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(PITCH_UP_BUTTON_COORDS)).booleanValue()) {
            Byte pitch = TagUtils.getByteOrDefault(this.emitterStack, "pitch", 0);
            addAmount = mouseModifier != false ? 2 : addAmount;
            pitch = MathUtils.addClamped(pitch, (Integer)addAmount, (Integer)-2, (Integer)2);
            TagUtils.setOrRemoveByte(this.emitterStack, "pitch", pitch);
            this.syncEffectEmitterToServer();
        } else if (!this.settingsOnly.booleanValue() && CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(PLAY_PARTICLE_BUTTON_COORDS)).booleanValue()) {
            this.playCurrentParticle();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SIDE_DOWN_BUTTON_COORDS)).booleanValue()) {
            Byte side = TagUtils.getByteOrDefault(this.emitterStack, "side", 0);
            addAmount = mouseModifier != false ? 2 : addAmount;
            side = MathUtils.addClamped(side, (Integer)(-addAmount), (Integer)0, (Integer)5);
            TagUtils.setOrRemoveByte(this.emitterStack, "side", side);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SIDE_UP_BUTTON_COORDS)).booleanValue()) {
            Byte side = TagUtils.getByteOrDefault(this.emitterStack, "side", 0);
            addAmount = mouseModifier != false ? 2 : addAmount;
            side = MathUtils.addClamped(side, (Integer)addAmount, (Integer)0, (Integer)5);
            TagUtils.setOrRemoveByte(this.emitterStack, "side", side);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SPREAD_DOWN_BUTTON_COORDS)).booleanValue()) {
            Byte spread = TagUtils.getByteOrDefault(this.emitterStack, "spread", 0);
            addAmount = mouseModifier != false ? 2 : addAmount;
            spread = MathUtils.addClamped(spread, (Integer)(-addAmount), (Integer)0, (Integer)5);
            TagUtils.setOrRemoveByte(this.emitterStack, "spread", spread);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SPREAD_UP_BUTTON_COORDS)).booleanValue()) {
            Byte spread = TagUtils.getByteOrDefault(this.emitterStack, "spread", 0);
            addAmount = mouseModifier != false ? 2 : addAmount;
            spread = MathUtils.addClamped(spread, (Integer)addAmount, (Integer)0, (Integer)5);
            TagUtils.setOrRemoveByte(this.emitterStack, "spread", spread);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(COUNT_DOWN_BUTTON_COORDS)).booleanValue()) {
            Byte count = TagUtils.getByteOrDefault(this.emitterStack, "count", 1);
            addAmount = mouseModifier != false ? 5 : addAmount;
            count = MathUtils.addClamped(count, (Integer)(-addAmount), (Integer)1, (Integer)20);
            TagUtils.setOrRemoveByte(this.emitterStack, "count", count);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(COUNT_UP_BUTTON_COORDS)).booleanValue()) {
            Byte count = TagUtils.getByteOrDefault(this.emitterStack, "count", 1);
            addAmount = mouseModifier != false ? 5 : addAmount;
            count = MathUtils.addClamped(count, (Integer)addAmount, (Integer)1, (Integer)20);
            TagUtils.setOrRemoveByte(this.emitterStack, "count", count);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SPEED_X_DOWN_BUTTON_COORDS)).booleanValue()) {
            Byte speed = TagUtils.getByteOrDefault(this.emitterStack, "speed_x", 0);
            addAmount = mouseModifier != false ? 5 : addAmount;
            speed = MathUtils.addClamped(speed, (Integer)(-addAmount), (Integer)-50, (Integer)50);
            TagUtils.setOrRemoveByte(this.emitterStack, "speed_x", speed);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SPEED_X_UP_BUTTON_COORDS)).booleanValue()) {
            Byte speed = TagUtils.getByteOrDefault(this.emitterStack, "speed_x", 0);
            addAmount = mouseModifier != false ? 5 : addAmount;
            speed = MathUtils.addClamped(speed, (Integer)addAmount, (Integer)-50, (Integer)50);
            TagUtils.setOrRemoveByte(this.emitterStack, "speed_x", speed);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SPEED_Y_DOWN_BUTTON_COORDS)).booleanValue()) {
            Byte speed = TagUtils.getByteOrDefault(this.emitterStack, "speed_y", 0);
            addAmount = mouseModifier != false ? 5 : addAmount;
            speed = MathUtils.addClamped(speed, (Integer)(-addAmount), (Integer)-50, (Integer)50);
            TagUtils.setOrRemoveByte(this.emitterStack, "speed_y", speed);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SPEED_Y_UP_BUTTON_COORDS)).booleanValue()) {
            Byte speed = TagUtils.getByteOrDefault(this.emitterStack, "speed_y", 0);
            addAmount = mouseModifier != false ? 5 : addAmount;
            speed = MathUtils.addClamped(speed, (Integer)addAmount, (Integer)-50, (Integer)50);
            TagUtils.setOrRemoveByte(this.emitterStack, "speed_y", speed);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SPEED_Z_DOWN_BUTTON_COORDS)).booleanValue()) {
            Byte speed = TagUtils.getByteOrDefault(this.emitterStack, "speed_z", 0);
            addAmount = mouseModifier != false ? 5 : addAmount;
            speed = MathUtils.addClamped(speed, (Integer)(-addAmount), (Integer)-50, (Integer)50);
            TagUtils.setOrRemoveByte(this.emitterStack, "speed_z", speed);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SPEED_Z_UP_BUTTON_COORDS)).booleanValue()) {
            Byte speed = TagUtils.getByteOrDefault(this.emitterStack, "speed_z", 0);
            addAmount = mouseModifier != false ? 5 : addAmount;
            speed = MathUtils.addClamped(speed, (Integer)addAmount, (Integer)-50, (Integer)50);
            TagUtils.setOrRemoveByte(this.emitterStack, "speed_z", speed);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(S_LOOP_DOWN_BUTTON_COORDS)).booleanValue()) {
            Integer loop = TagUtils.getIntOrDefault((DataComponentHolder)this.emitterStack, "sound_loop", 0);
            addAmount = mouseModifier != false ? 10 : addAmount;
            loop = MathUtils.addClamped(loop, (Integer)(-addAmount), (Integer)0, (Integer)999);
            TagUtils.setOrRemoveInt(this.emitterStack, "sound_loop", loop);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(S_LOOP_UP_BUTTON_COORDS)).booleanValue()) {
            Integer loop = TagUtils.getIntOrDefault((DataComponentHolder)this.emitterStack, "sound_loop", 0);
            addAmount = mouseModifier != false ? 10 : addAmount;
            loop = MathUtils.addClamped(loop, (Integer)addAmount, (Integer)0, (Integer)999);
            TagUtils.setOrRemoveInt(this.emitterStack, "sound_loop", loop);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(P_LOOP_DOWN_BUTTON_COORDS)).booleanValue()) {
            Integer loop = TagUtils.getIntOrDefault((DataComponentHolder)this.emitterStack, "particle_loop", 0);
            addAmount = mouseModifier != false ? 10 : addAmount;
            loop = MathUtils.addClamped(loop, (Integer)(-addAmount), (Integer)0, (Integer)999);
            TagUtils.setOrRemoveInt(this.emitterStack, "particle_loop", loop);
            this.syncEffectEmitterToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(P_LOOP_UP_BUTTON_COORDS)).booleanValue()) {
            Integer loop = TagUtils.getIntOrDefault((DataComponentHolder)this.emitterStack, "particle_loop", 0);
            addAmount = mouseModifier != false ? 10 : addAmount;
            loop = MathUtils.addClamped(loop, (Integer)addAmount, (Integer)0, (Integer)999);
            TagUtils.setOrRemoveInt(this.emitterStack, "particle_loop", loop);
            this.syncEffectEmitterToServer();
        }
        return super.mouseClicked(dmouseX, dmouseY, mouseButton);
    }

    public void syncEffectEmitterToServer() {
        NetworkProxy.sendToServer(new EffectEmitterUpdatePacket(this.emitterStack, this.tilePos, this.handIn));
    }

    public Boolean validateParticle(String newParticleString) {
        if (!newParticleString.trim().isBlank()) {
            try {
                ParticleOptions options = (ParticleOptions)((Registry)this.world.registryAccess().registry(Registries.PARTICLE_TYPE).get()).get(ResourceUtils.parseLocation(newParticleString.trim()));
                return options != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public Boolean validateSound(String newSoundString) {
        if (!newSoundString.trim().isBlank()) {
            try {
                return ((Registry)this.world.registryAccess().registry(Registries.SOUND_EVENT).get()).containsKey(ResourceUtils.parseLocation(newSoundString.trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void handleParticleChange(String newParticleString) {
        Boolean particleValid = this.validateParticle(newParticleString);
        this.particleBox.setTextColor(particleValid != false ? DEFAULT_TEXT_FIELD_COLOR : 13112340);
        TagUtils.setOrRemoveString(this.emitterStack, "particle", newParticleString.trim());
        this.syncEffectEmitterToServer();
    }

    public void handleSoundChange(String newSoundString) {
        Boolean soundValid = this.validateSound(newSoundString);
        this.soundBox.setTextColor(soundValid != false ? DEFAULT_TEXT_FIELD_COLOR : 13112340);
        TagUtils.setOrRemoveString(this.emitterStack, "sound", newSoundString.trim());
        this.syncEffectEmitterToServer();
    }

    public void playCurrentSound() {
        TileEffectEmitter tile = this.world.getBlockEntity(this.tilePos, ModTiles.EFFECTEMITTER).orElse(null);
        if (tile != null) {
            tile.playSoundLocal();
        }
    }

    public void playCurrentParticle() {
        TileEffectEmitter tile = this.world.getBlockEntity(this.tilePos, ModTiles.EFFECTEMITTER).orElse(null);
        if (tile != null) {
            tile.playParticleLocal();
        }
    }

    @Override
    protected GuiGraphics renderGraphics(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.blitAbsolute(graphics, this.guiTexture, this.START_X, this.START_Y, 0.0f, 0.0f, this.GUI_WIDTH, this.GUI_HEIGHT, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        this.invertSignalWidget.renderGraphics(graphics, mouseX, mouseY);
        this.soundBox.render(graphics, mouseX, mouseY, partialTicks);
        this.particleBox.render(graphics, mouseX, mouseY, partialTicks);
        return graphics;
    }

    @Override
    protected GuiGraphics renderText(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.invertSignalWidget.renderText(graphics, this.font, mouseX, mouseY);
        this.drawStringAbsolute(graphics, this.font, TagUtils.getByteOrDefault(this.emitterStack, "volume", 5).toString(), this.START_X + GuiEffectEmitter.VOL_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.VOL_TEXT_COORDS.y, -16718336);
        this.drawStringAbsolute(graphics, this.font, TagUtils.getByteOrDefault(this.emitterStack, "pitch", 0).toString(), this.START_X + GuiEffectEmitter.PITCH_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.PITCH_TEXT_COORDS.y, -16718336);
        this.drawStringAbsolute(graphics, this.font, TagUtils.getByteOrDefault(this.emitterStack, "spread", 0).toString(), this.START_X + GuiEffectEmitter.SPREAD_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.SPREAD_TEXT_COORDS.y, -16718336);
        this.drawStringAbsolute(graphics, this.font, BlockEffectEmitter.getSideFromByte(TagUtils.getByteOrDefault(this.emitterStack, "side", 0)).substring(0, 1), this.START_X + GuiEffectEmitter.SIDE_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.SIDE_TEXT_COORDS.y, -16718336);
        this.drawStringAbsolute(graphics, this.font, TagUtils.getByteOrDefault(this.emitterStack, "count", 1).toString(), this.START_X + GuiEffectEmitter.COUNT_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.COUNT_TEXT_COORDS.y, -16718336);
        this.drawStringAbsolute(graphics, this.font, TagUtils.getByteOrDefault(this.emitterStack, "speed_x", 0).toString(), this.START_X + GuiEffectEmitter.SPEED_X_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.SPEED_X_TEXT_COORDS.y, -16718336);
        this.drawStringAbsolute(graphics, this.font, TagUtils.getByteOrDefault(this.emitterStack, "speed_y", 0).toString(), this.START_X + GuiEffectEmitter.SPEED_Y_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.SPEED_Y_TEXT_COORDS.y, -16718336);
        this.drawStringAbsolute(graphics, this.font, TagUtils.getByteOrDefault(this.emitterStack, "speed_z", 0).toString(), this.START_X + GuiEffectEmitter.SPEED_Z_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.SPEED_Z_TEXT_COORDS.y, -16718336);
        this.drawStringAbsolute(graphics, this.font, this.getLoopFromInt(TagUtils.getIntOrDefault((DataComponentHolder)this.emitterStack, "sound_loop", 0)), this.START_X + GuiEffectEmitter.S_LOOP_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.S_LOOP_TEXT_COORDS.y, -16718336);
        this.drawStringAbsolute(graphics, this.font, this.getLoopFromInt(TagUtils.getIntOrDefault((DataComponentHolder)this.emitterStack, "particle_loop", 0)), this.START_X + GuiEffectEmitter.P_LOOP_TEXT_COORDS.x, this.START_Y + GuiEffectEmitter.P_LOOP_TEXT_COORDS.y, -16718336);
        return graphics;
    }

    public String getLoopFromInt(Integer loop) {
        if (loop == 0) {
            return "None";
        }
        return loop.toString();
    }
}

