/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import io.github.tofodroid.mods.mimi.client.ClientProxy;
import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.MidiChannelToggleWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.TransmitterSourceWidget;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.common.network.SyncInstrumentPacket;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.github.tofodroid.mods.mimi.util.EntityUtils;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.lwjgl.glfw.GLFW;

public class GuiInstrument
extends BaseGui {
    private static final Integer NOTE_WIDTH = 14;
    private static final Integer NOTE_OFFSET_X = 11;
    private static final Integer NOTE_OFFSET_Y = 29;
    private static final Vector2Int MIDI_CHANNEL_WIDGET_COORDS = new Vector2Int(137, 71);
    private static final Vector2Int TRANSMIT_SOURCE_WIDGET_COORDS = new Vector2Int(18, 105);
    private static final Vector2Int SYS_DEVICE_BUTTON_COORDS = new Vector2Int(108, 85);
    private static final Vector2Int INSTRUMENT_VOLUME_UP_BUTTON_COORDS = new Vector2Int(114, 62);
    private static final Vector2Int INSTRUMENT_VOLUME_DOWN_BUTTON_COORDS = new Vector2Int(67, 62);
    private static final Vector2Int KEYBOARD_LAYOUT_BUTTON_COORDS = new Vector2Int(300, 31);
    private static final Vector2Int NOTE_SHIFT_DOWN_BUTTON_COORDS = new Vector2Int(33, 161);
    private static final Vector2Int NOTE_SHIFT_UP_BUTTON_COORDS = new Vector2Int(52, 161);
    private static final Vector2Int OCT_SHIFT_DOWN_BUTTON_COORDS = new Vector2Int(14, 161);
    private static final Vector2Int OCT_SHIFT_UP_BUTTON_COORDS = new Vector2Int(71, 161);
    private static final Vector2Int MIDI_EDIT_BUTTON_COORDS = new Vector2Int(299, 161);
    private static final Integer KEYBOARD_START_NOTE = 21;
    private static final Integer VISIBLE_NOTES = 44;
    private static final Integer MAX_NOTE_SHIFT = 53;
    private final Integer MIMI_ACCENT_LEFT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)83);
    private final Integer MIMI_ACCENT_LEFT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)39);
    private final Integer MIMI_ACCENT_RIGHT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)49);
    private final Integer MIMI_ACCENT_RIGHT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)61);
    private final Integer MIMI_NOTE_LEFT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)90);
    private final Integer MIMI_NOTE_LEFT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)47);
    private final Integer MIMI_NOTE_RIGHT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)81);
    private final Integer MIMI_NOTE_RIGHT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)93);
    private final Integer LMMS_ACCENT_LEFT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)83);
    private final Integer LMMS_ACCENT_LEFT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)75);
    private final Integer LMMS_ACCENT_LEFT_CROSS_MAX_SCAN = GLFW.glfwGetKeyScancode((int)39);
    private final Integer LMMS_NOTE_LEFT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)90);
    private final Integer LMMS_NOTE_LEFT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)77);
    private final Integer LMMS_NOTE_LEFT_CROSS_MAX_SCAN = GLFW.glfwGetKeyScancode((int)47);
    private final Integer LMMS_ACCENT_RIGHT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)49);
    private final Integer LMMS_ACCENT_RIGHT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)61);
    private final Integer LMMS_NOTE_RIGHT_MIN_SCAN = GLFW.glfwGetKeyScancode((int)81);
    private final Integer LMMS_NOTE_RIGHT_MAX_SCAN = GLFW.glfwGetKeyScancode((int)93);
    private final Integer V_PIANO_MIN_SHIFT = 14;
    private final Integer V_PIANO_MAX_SHIFT = 28;
    private final Integer V_PIANO_MAX_NOTE = 49;
    private final Map<Integer, Integer> VPianoMidiMap = Stream.of({GLFW.glfwGetKeyScancode((int)49), 0}, {-GLFW.glfwGetKeyScancode((int)49), 1}, {GLFW.glfwGetKeyScancode((int)50), 2}, {-GLFW.glfwGetKeyScancode((int)50), 3}, {GLFW.glfwGetKeyScancode((int)51), 4}, {GLFW.glfwGetKeyScancode((int)52), 5}, {-GLFW.glfwGetKeyScancode((int)52), 6}, {GLFW.glfwGetKeyScancode((int)53), 7}, {-GLFW.glfwGetKeyScancode((int)53), 8}, {GLFW.glfwGetKeyScancode((int)54), 9}, {-GLFW.glfwGetKeyScancode((int)54), 10}, {GLFW.glfwGetKeyScancode((int)55), 11}, {GLFW.glfwGetKeyScancode((int)56), 12}, {-GLFW.glfwGetKeyScancode((int)56), 13}, {GLFW.glfwGetKeyScancode((int)57), 14}, {-GLFW.glfwGetKeyScancode((int)57), 15}, {GLFW.glfwGetKeyScancode((int)48), 16}, {GLFW.glfwGetKeyScancode((int)81), 17}, {-GLFW.glfwGetKeyScancode((int)81), 18}, {GLFW.glfwGetKeyScancode((int)87), 19}, {-GLFW.glfwGetKeyScancode((int)87), 20}, {GLFW.glfwGetKeyScancode((int)69), 21}, {-GLFW.glfwGetKeyScancode((int)69), 22}, {GLFW.glfwGetKeyScancode((int)82), 23}, {GLFW.glfwGetKeyScancode((int)84), 24}, {-GLFW.glfwGetKeyScancode((int)84), 25}, {GLFW.glfwGetKeyScancode((int)89), 26}, {-GLFW.glfwGetKeyScancode((int)89), 27}, {GLFW.glfwGetKeyScancode((int)85), 28}, {GLFW.glfwGetKeyScancode((int)73), 29}, {-GLFW.glfwGetKeyScancode((int)73), 30}, {GLFW.glfwGetKeyScancode((int)79), 31}, {-GLFW.glfwGetKeyScancode((int)79), 32}, {GLFW.glfwGetKeyScancode((int)80), 33}, {-GLFW.glfwGetKeyScancode((int)80), 34}, {GLFW.glfwGetKeyScancode((int)65), 35}, {GLFW.glfwGetKeyScancode((int)83), 36}, {-GLFW.glfwGetKeyScancode((int)83), 37}, {GLFW.glfwGetKeyScancode((int)68), 38}, {-GLFW.glfwGetKeyScancode((int)68), 39}, {GLFW.glfwGetKeyScancode((int)70), 40}, {GLFW.glfwGetKeyScancode((int)71), 41}, {-GLFW.glfwGetKeyScancode((int)71), 42}, {GLFW.glfwGetKeyScancode((int)72), 43}, {-GLFW.glfwGetKeyScancode((int)72), 44}, {GLFW.glfwGetKeyScancode((int)74), 45}, {-GLFW.glfwGetKeyScancode((int)74), 46}, {GLFW.glfwGetKeyScancode((int)75), 47}, {GLFW.glfwGetKeyScancode((int)76), 48}, {-GLFW.glfwGetKeyScancode((int)76), 49}, {GLFW.glfwGetKeyScancode((int)90), 50}, {-GLFW.glfwGetKeyScancode((int)90), 51}, {GLFW.glfwGetKeyScancode((int)88), 52}, {GLFW.glfwGetKeyScancode((int)67), 53}, {-GLFW.glfwGetKeyScancode((int)67), 54}, {GLFW.glfwGetKeyScancode((int)86), 55}, {-GLFW.glfwGetKeyScancode((int)86), 56}, {GLFW.glfwGetKeyScancode((int)66), 57}, {-GLFW.glfwGetKeyScancode((int)66), 58}, {GLFW.glfwGetKeyScancode((int)78), 59}, {GLFW.glfwGetKeyScancode((int)77), 60}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    private MidiChannelToggleWidget midiChannelToggle;
    private TransmitterSourceWidget transmitSource;
    private final ItemStack instrumentStack;
    private Player player;
    private InteractionHand handIn;
    private ConcurrentHashMap<Byte, Instant> heldNotes;
    private ConcurrentHashMap<Byte, Instant> releasedNotes;
    private String instrumentNameString = null;
    private Byte instrumentId = null;
    private Boolean editMode = false;
    private Boolean settingsOnly = false;
    private Integer visibleNoteShift = KEYBOARD_START_NOTE;
    private String noteIdString = "C3,F4 | G4,C6";
    private Byte mouseNote = null;
    private Boolean pedalToggle = false;

    public GuiInstrument(Player player, ItemStack instrumentStack, InteractionHand handIn) {
        this(player, instrumentStack, handIn, false);
    }

    public GuiInstrument(Player player, ItemStack instrumentStack, InteractionHand handIn, Boolean settingsOnly) {
        super(328, 184, 563, "textures/gui/container_instrument.png", "item.MIMIMod.gui_instrument");
        if (instrumentStack == null || instrumentStack.isEmpty()) {
            MIMIMod.LOGGER.error("Instrument stack is null or empty. Force closing GUI!");
            Minecraft.getInstance().forceSetScreen((Screen)null);
            this.instrumentStack = null;
            return;
        }
        this.settingsOnly = settingsOnly;
        this.editMode = settingsOnly;
        this.player = player;
        this.handIn = handIn;
        this.instrumentStack = new ItemStack((ItemLike)instrumentStack.getItem(), instrumentStack.getCount());
        this.instrumentStack.applyComponents(instrumentStack.getComponents());
        if (!this.settingsOnly.booleanValue()) {
            this.instrumentId = MidiNbtDataUtils.getInstrumentId(this.instrumentStack);
            this.instrumentNameString = MidiNbtDataUtils.getInstrumentName(this.instrumentId);
        } else {
            this.instrumentNameString = "Settings";
        }
    }

    @Override
    public void init() {
        super.init();
        this.START_Y = Math.round((float)(this.height - this.GUI_HEIGHT) / 1.5f);
        this.heldNotes = new ConcurrentHashMap();
        this.releasedNotes = new ConcurrentHashMap();
        this.midiChannelToggle = new MidiChannelToggleWidget(this.instrumentStack, new Vector2Int(this.START_X, this.START_Y), MIDI_CHANNEL_WIDGET_COORDS);
        this.transmitSource = new TransmitterSourceWidget(this.instrumentStack, this.player.getUUID(), this.player.getName().getString(), new Vector2Int(this.START_X, this.START_Y), TRANSMIT_SOURCE_WIDGET_COORDS);
    }

    public void syncInstrumentToServer() {
        NetworkProxy.sendToServer(new SyncInstrumentPacket(this.instrumentStack, this.handIn));
    }

    public Byte getInstrumentId() {
        return this.instrumentId;
    }

    public InteractionHand getHandIn() {
        return this.handIn;
    }

    public void onClose() {
        this.toggleHoldPedal(false);
        this.releaseHeldNotes();
        super.onClose();
    }

    public boolean mouseClicked(double dmouseX, double dmouseY, int mouseButton) {
        int imouseX = (int)Math.round(dmouseX);
        int imouseY = (int)Math.round(dmouseY);
        if (!this.settingsOnly.booleanValue()) {
            if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(NOTE_SHIFT_UP_BUTTON_COORDS)).booleanValue()) {
                this.shiftVisibleNotes(true, 1);
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(NOTE_SHIFT_DOWN_BUTTON_COORDS)).booleanValue()) {
                this.shiftVisibleNotes(false, 1);
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(OCT_SHIFT_UP_BUTTON_COORDS)).booleanValue()) {
                this.shiftVisibleNotes(true, 7);
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(OCT_SHIFT_DOWN_BUTTON_COORDS)).booleanValue()) {
                this.shiftVisibleNotes(false, 7);
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(MIDI_EDIT_BUTTON_COORDS)).booleanValue()) {
                this.editMode = this.editMode == false;
            }
        }
        if (!this.editMode.booleanValue()) {
            if (imouseX >= this.START_X + 222 && imouseY >= this.START_Y + 28 && imouseX < this.START_X + this.GUI_WIDTH && imouseY < this.START_Y + 50) {
                if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(KEYBOARD_LAYOUT_BUTTON_COORDS)).booleanValue()) {
                    if (ConfigProxy.getKeyboardLayout().ordinal() < ConfigProxy.KEYBOARD_LAYOUTS.values().length - 1) {
                        ConfigProxy.setKeyboardLayout(ConfigProxy.KEYBOARD_LAYOUTS.values()[ConfigProxy.getKeyboardLayout().ordinal() + 1]);
                    } else {
                        ConfigProxy.setKeyboardLayout(ConfigProxy.KEYBOARD_LAYOUTS.values()[0]);
                    }
                    this.releaseHeldNotes();
                }
                return super.mouseClicked(dmouseX, dmouseY, mouseButton);
            }
            int relativeMouseX = imouseX - (this.START_X + NOTE_OFFSET_X);
            int relativeMouseY = imouseY - (this.START_Y + NOTE_OFFSET_Y);
            if (relativeMouseX >= 0 && relativeMouseY >= 0 && imouseX < this.START_X + this.GUI_WIDTH - 11 && imouseY < this.START_Y + this.GUI_HEIGHT - 28) {
                Byte midiNote = null;
                if (relativeMouseY <= 84) {
                    midiNote = this.keyNumToMidiNote(2 * ((relativeMouseX + NOTE_WIDTH / 2) / NOTE_WIDTH));
                }
                if (midiNote == null) {
                    midiNote = this.keyNumToMidiNote(2 * (relativeMouseX / NOTE_WIDTH) + 1);
                }
                if (midiNote != null) {
                    this.mouseNote = midiNote;
                    this.onGuiNotePress(midiNote, (byte)127);
                }
            }
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SYS_DEVICE_BUTTON_COORDS)).booleanValue()) {
            MidiNbtDataUtils.setSysInput(this.instrumentStack, MidiNbtDataUtils.getSysInput(this.instrumentStack) == false);
            this.syncInstrumentToServer();
            this.allNotesOff();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(INSTRUMENT_VOLUME_UP_BUTTON_COORDS)).booleanValue()) {
            MidiNbtDataUtils.setInstrumentVolume(this.instrumentStack, Integer.valueOf(MidiNbtDataUtils.getInstrumentVolume(this.instrumentStack) + 1).byteValue());
            this.syncInstrumentToServer();
            this.releaseHeldNotes();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(INSTRUMENT_VOLUME_DOWN_BUTTON_COORDS)).booleanValue()) {
            MidiNbtDataUtils.setInstrumentVolume(this.instrumentStack, Integer.valueOf(MidiNbtDataUtils.getInstrumentVolume(this.instrumentStack) - 1).byteValue());
            this.syncInstrumentToServer();
            this.releaseHeldNotes();
        } else if (this.transmitSource.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncInstrumentToServer();
            this.releaseHeldNotes();
        } else if (this.midiChannelToggle.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncInstrumentToServer();
            this.releaseHeldNotes();
        }
        return super.mouseClicked(dmouseX, dmouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.mouseNote != null) {
            this.onGuiNoteRelease(this.mouseNote);
            this.mouseNote = null;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean doCloseOnInventoryKeyPress() {
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        super.keyPressed(keyCode, scanCode, modifiers);
        if (!this.settingsOnly.booleanValue()) {
            if (keyCode == 263) {
                this.shiftVisibleNotes(false, 1);
                return true;
            }
            if (keyCode == 262) {
                this.shiftVisibleNotes(true, 1);
                return true;
            }
            if (keyCode == 264) {
                this.shiftVisibleNotes(false, 7);
                return true;
            }
            if (keyCode == 265) {
                this.shiftVisibleNotes(true, 7);
                return true;
            }
            if (keyCode == 32) {
                this.toggleHoldPedal(true);
                return true;
            }
            if (keyCode == 259) {
                this.toggleHoldPedal(this.pedalToggle == false);
                this.pedalToggle = this.pedalToggle == false;
                return true;
            }
            Set<Byte> midiNoteNums = this.getMidiNoteFromScanCode(scanCode, modifiers == 1, false);
            if (midiNoteNums != null) {
                for (Byte midiNoteNum : midiNoteNums) {
                    if (this.heldNotes.containsKey(midiNoteNum)) continue;
                    this.onGuiNotePress(midiNoteNum, (byte)127);
                }
                return true;
            }
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        super.keyReleased(keyCode, scanCode, modifiers);
        if (!this.settingsOnly.booleanValue()) {
            if (keyCode == 32) {
                this.toggleHoldPedal(false);
                return true;
            }
            Set<Byte> midiNoteNums = this.getMidiNoteFromScanCode(scanCode, modifiers == 1, true);
            if (midiNoteNums != null) {
                for (Byte midiNoteNum : midiNoteNums) {
                    this.onGuiNoteRelease(midiNoteNum);
                }
                return true;
            }
        }
        return false;
    }

    private void toggleHoldPedal(Boolean on) {
        if (this.instrumentId != null) {
            Byte controller = 64;
            Byte value = on != false ? (byte)127 : 0;
            NoteEventPacket packet = NoteEventPacket.createControlPacket(controller, value, this.instrumentId, this.player.getUUID(), EntityUtils.getEntityHeadPos((LivingEntity)this.player), this.handIn);
            NetworkProxy.sendToServer(packet);
            ((ClientProxy)MIMIMod.getProxy()).getMidiSynth().handleLocalPacketInstant(packet);
        }
    }

    private Byte keyNumToMidiNote(Integer keyNum) {
        if (keyNum == null) {
            return null;
        }
        Byte result = null;
        Integer octaveNote = (keyNum + 2 * this.visibleNoteShift) % 14;
        Integer octaveNum = (keyNum + 2 * this.visibleNoteShift) / 14;
        if (octaveNote != 0 && octaveNote != 6) {
            octaveNote = octaveNote - (octaveNote > 6 ? 2 : 1);
            result = Integer.valueOf(octaveNote + 12 * octaveNum).byteValue();
        }
        return result;
    }

    private Integer midiNoteToKeyNum(Byte midiNote) {
        if (midiNote == null) {
            return null;
        }
        Integer octaveNote = midiNote % 12;
        Integer octaveNum = midiNote / 12;
        Integer result = (octaveNote = Integer.valueOf(octaveNote + (octaveNote > 4 ? 2 : 1))) + 14 * octaveNum - 2 * this.visibleNoteShift;
        if (result >= 0 && result <= VISIBLE_NOTES) {
            return result;
        }
        return null;
    }

    private void shiftVisibleNotes(Boolean up, Integer amount) {
        this.visibleNoteShift = up != false ? Integer.valueOf(this.visibleNoteShift + amount) : Integer.valueOf(this.visibleNoteShift - amount);
        this.visibleNoteShift = this.visibleNoteShift < 0 ? 0 : (this.visibleNoteShift > MAX_NOTE_SHIFT ? MAX_NOTE_SHIFT : this.visibleNoteShift);
        this.noteIdString = this.buildNoteIdString();
    }

    private void releaseHeldNotes() {
        if (this.heldNotes != null && this.instrumentId != null) {
            ArrayList notesToRemove = new ArrayList(this.heldNotes.keySet());
            for (Byte note : notesToRemove) {
                this.onGuiNoteRelease(note);
            }
            NoteEventPacket packet = NoteEventPacket.createResetPacket(this.instrumentId, this.player.getUUID(), EntityUtils.getEntityHeadPos((LivingEntity)this.player), this.handIn);
            NetworkProxy.sendToServer(packet);
            ((ClientProxy)MIMIMod.getProxy()).getMidiSynth().handlePacket(packet);
            ((ClientProxy)MIMIMod.getProxy()).getMidiSynth().handleLocalPacketInstant(packet);
        }
    }

    private void allNotesOff() {
        if (this.heldNotes != null && this.instrumentId != null) {
            this.releaseHeldNotes();
            NoteEventPacket packet = NoteEventPacket.createResetPacket(this.instrumentId, this.player.getUUID(), EntityUtils.getEntityHeadPos((LivingEntity)this.player), this.handIn);
            NetworkProxy.sendToServer(packet);
            ((ClientProxy)MIMIMod.getProxy()).getMidiSynth().handlePacket(packet);
            ((ClientProxy)MIMIMod.getProxy()).getMidiSynth().handleLocalPacketInstant(packet);
        }
    }

    public void onExternalNotePress(Byte midiNote) {
        if (this.instrumentId != null) {
            this.releasedNotes.remove(midiNote);
            this.heldNotes.put(midiNote, Instant.now());
        }
    }

    public void onExternalNoteRelease(Byte midiNote) {
        if (this.instrumentId != null && this.heldNotes.remove(midiNote) != null) {
            this.releasedNotes.put(midiNote, Instant.now());
        }
    }

    private void onGuiNotePress(Byte midiNote, Byte velocity) {
        if (this.instrumentId != null) {
            NoteEventPacket packet = NoteEventPacket.createNotePacket(midiNote, MidiNbtDataUtils.applyInstrumentVolume(this.instrumentStack, velocity), this.instrumentId, this.player.getUUID(), EntityUtils.getEntityHeadPos((LivingEntity)this.player), this.handIn);
            NetworkProxy.sendToServer(packet);
            ((ClientProxy)MIMIMod.getProxy()).getMidiSynth().handleLocalPacketInstant(packet);
            this.releasedNotes.remove(midiNote);
            this.heldNotes.put(midiNote, Instant.now());
        }
    }

    private void onGuiNoteRelease(Byte midiNote) {
        if (this.instrumentId != null) {
            NoteEventPacket packet = NoteEventPacket.createNotePacket(midiNote, ByteUtils.ZERO, this.instrumentId, this.player.getUUID(), EntityUtils.getEntityHeadPos((LivingEntity)this.player), this.handIn);
            NetworkProxy.sendToServer(packet);
            ((ClientProxy)MIMIMod.getProxy()).getMidiSynth().handleLocalPacketInstant(packet);
            if (this.heldNotes.remove(midiNote) != null) {
                this.releasedNotes.put(midiNote, Instant.now());
            }
        }
    }

    private Set<Byte> getMidiNoteFromScanCode(Integer scanCode, Boolean modifier, Boolean ignoreModifier) {
        switch (ConfigProxy.getKeyboardLayout()) {
            case MIMI: {
                return Arrays.asList(this.getMidiNoteFromScanCode_MIMI(scanCode)).stream().filter(b -> b != null).collect(Collectors.toSet());
            }
            case VPiano: {
                return Arrays.asList(this.getMidiNoteFromScanCode_VPiano(scanCode, modifier), ignoreModifier != false ? this.getMidiNoteFromScanCode_VPiano(scanCode, modifier == false) : null).stream().filter(b -> b != null).collect(Collectors.toSet());
            }
            case LMMS: {
                return Arrays.asList(this.getMidiNoteFromScanCode_LMMS(scanCode)).stream().filter(b -> b != null).collect(Collectors.toSet());
            }
        }
        MIMIMod.LOGGER.warn("Warning: Unknown keyboard layout selected for Instrument GUI.");
        return null;
    }

    private Byte getMidiNoteFromScanCode_LMMS(Integer scanCode) {
        Integer keyNum = null;
        if (scanCode >= this.LMMS_ACCENT_LEFT_MIN_SCAN && scanCode <= this.LMMS_ACCENT_LEFT_MAX_SCAN) {
            keyNum = scanCode - this.LMMS_ACCENT_LEFT_MIN_SCAN + 1;
            keyNum = keyNum * 2;
        } else if (scanCode > this.LMMS_ACCENT_LEFT_MAX_SCAN && scanCode <= this.LMMS_ACCENT_LEFT_CROSS_MAX_SCAN) {
            keyNum = scanCode - this.LMMS_ACCENT_LEFT_MAX_SCAN + (this.LMMS_ACCENT_LEFT_MAX_SCAN - this.LMMS_ACCENT_LEFT_MIN_SCAN) + 1;
            keyNum = keyNum * 2;
        } else if (scanCode >= this.LMMS_NOTE_LEFT_MIN_SCAN && scanCode <= this.LMMS_NOTE_LEFT_MAX_SCAN) {
            keyNum = scanCode - this.LMMS_NOTE_LEFT_MIN_SCAN + 1;
            keyNum = keyNum + (keyNum - 1);
        } else if (scanCode > this.LMMS_NOTE_LEFT_MAX_SCAN && scanCode <= this.LMMS_NOTE_LEFT_CROSS_MAX_SCAN) {
            keyNum = scanCode - this.LMMS_NOTE_LEFT_MAX_SCAN + (this.LMMS_NOTE_LEFT_MAX_SCAN - this.LMMS_NOTE_LEFT_MIN_SCAN) + 1;
            keyNum = keyNum + (keyNum - 1);
        } else if (scanCode >= this.LMMS_ACCENT_RIGHT_MIN_SCAN && scanCode <= this.LMMS_ACCENT_RIGHT_MAX_SCAN) {
            keyNum = scanCode - this.LMMS_ACCENT_RIGHT_MIN_SCAN + (this.LMMS_ACCENT_LEFT_MAX_SCAN - this.LMMS_ACCENT_LEFT_MIN_SCAN) + 1;
            keyNum = keyNum * 2;
        } else if (scanCode >= this.LMMS_NOTE_RIGHT_MIN_SCAN && scanCode <= this.LMMS_NOTE_RIGHT_MAX_SCAN) {
            keyNum = scanCode - this.LMMS_NOTE_RIGHT_MIN_SCAN + (this.LMMS_NOTE_LEFT_MAX_SCAN - this.LMMS_NOTE_LEFT_MIN_SCAN) + 2;
            keyNum = keyNum + (keyNum - 1);
        }
        if (keyNum != null) {
            Byte result = this.keyNumToMidiNote(keyNum);
            return result;
        }
        return null;
    }

    private Byte getMidiNoteFromScanCode_MIMI(Integer scanCode) {
        Integer keyNum = null;
        if (scanCode >= this.MIMI_ACCENT_LEFT_MIN_SCAN && scanCode <= this.MIMI_ACCENT_LEFT_MAX_SCAN) {
            keyNum = scanCode - this.MIMI_ACCENT_LEFT_MIN_SCAN + 1;
            keyNum = keyNum * 2;
        } else if (scanCode >= this.MIMI_NOTE_LEFT_MIN_SCAN && scanCode <= this.MIMI_NOTE_LEFT_MAX_SCAN) {
            keyNum = scanCode - this.MIMI_NOTE_LEFT_MIN_SCAN + 1;
            keyNum = keyNum + (keyNum - 1);
        } else if (scanCode >= this.MIMI_ACCENT_RIGHT_MIN_SCAN && scanCode <= this.MIMI_ACCENT_RIGHT_MAX_SCAN) {
            keyNum = scanCode - this.MIMI_ACCENT_RIGHT_MIN_SCAN + (this.MIMI_ACCENT_LEFT_MAX_SCAN - this.MIMI_ACCENT_LEFT_MIN_SCAN) + 1;
            keyNum = keyNum * 2;
        } else if (scanCode >= this.MIMI_NOTE_RIGHT_MIN_SCAN && scanCode <= this.MIMI_NOTE_RIGHT_MAX_SCAN) {
            keyNum = scanCode - this.MIMI_NOTE_RIGHT_MIN_SCAN + (this.MIMI_NOTE_LEFT_MAX_SCAN - this.MIMI_NOTE_LEFT_MIN_SCAN) + 2;
            keyNum = keyNum + (keyNum - 1);
        }
        if (keyNum != null) {
            Byte result = this.keyNumToMidiNote(keyNum);
            return result;
        }
        return null;
    }

    private Byte getMidiNoteFromScanCode_VPiano(Integer scanCode, Boolean modifier) {
        Integer midiInt = this.VPianoMidiMap.get(scanCode * (modifier != false ? -1 : 1));
        return midiInt != null ? Byte.valueOf(Integer.valueOf(24 + midiInt).byteValue()) : null;
    }

    @Override
    protected GuiGraphics renderGraphics(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Integer keyboardTextureShift = this.visibleNoteShift % (NOTE_WIDTH / 2) * NOTE_WIDTH;
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + NOTE_OFFSET_X - 1, this.START_Y + NOTE_OFFSET_Y - 1, keyboardTextureShift.intValue(), 276.0f, 308, 128, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        if (ConfigProxy.KEYBOARD_LAYOUTS.MIMI.equals((Object)ConfigProxy.getKeyboardLayout())) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + NOTE_OFFSET_X - 1, this.START_Y + NOTE_OFFSET_Y + 70, 0.0f, 457.0f, 308, 53, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        } else if (ConfigProxy.KEYBOARD_LAYOUTS.LMMS.equals((Object)ConfigProxy.getKeyboardLayout())) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + NOTE_OFFSET_X - 1, this.START_Y + NOTE_OFFSET_Y + 70, 0.0f, 510.0f, 308, 53, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        } else if (ConfigProxy.KEYBOARD_LAYOUTS.VPiano.equals((Object)ConfigProxy.getKeyboardLayout())) {
            if (this.visibleNoteShift < this.V_PIANO_MIN_SHIFT) {
                Integer widthShift = (this.V_PIANO_MIN_SHIFT - this.visibleNoteShift) * NOTE_WIDTH;
                this.blitAbsolute(graphics, this.guiTexture, this.START_X + NOTE_OFFSET_X - 1 + widthShift, this.START_Y + NOTE_OFFSET_Y + 70, 0.0f, 404.0f, 308 - widthShift, 53, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
            } else if (this.visibleNoteShift >= this.V_PIANO_MIN_SHIFT && this.visibleNoteShift <= this.V_PIANO_MAX_SHIFT) {
                this.blitAbsolute(graphics, this.guiTexture, this.START_X + NOTE_OFFSET_X - 1, this.START_Y + NOTE_OFFSET_Y + 70, (this.visibleNoteShift - this.V_PIANO_MIN_SHIFT) * NOTE_WIDTH, 404.0f, 308, 53, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
            } else if (this.visibleNoteShift <= this.V_PIANO_MAX_NOTE) {
                Integer widthShift = (this.V_PIANO_MAX_SHIFT - this.visibleNoteShift) * -NOTE_WIDTH.intValue();
                this.blitAbsolute(graphics, this.guiTexture, this.START_X + NOTE_OFFSET_X - 1, this.START_Y + NOTE_OFFSET_Y + 70, (this.visibleNoteShift - this.V_PIANO_MIN_SHIFT) * NOTE_WIDTH, 404.0f, 308 - widthShift, 53, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
            }
        }
        if (this.visibleNoteShift == 0) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + NOTE_OFFSET_X, this.START_Y + NOTE_OFFSET_Y, 392.0f, 276.0f, 6, 86, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        } else if (this.visibleNoteShift == MAX_NOTE_SHIFT) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 311, this.START_Y + NOTE_OFFSET_Y, 392.0f, 276.0f, 6, 86, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        }
        graphics = this.renderAndCleanNoteSet(graphics, this.heldNotes, 5000, true, entry -> this.onGuiNoteRelease((Byte)entry.getKey()));
        graphics = this.renderAndCleanNoteSet(graphics, this.releasedNotes, 1000, false, entry -> this.releasedNotes.remove(entry.getKey()));
        CommonGuiUtils.setAlpha(1.0f);
        this.blitAbsolute(graphics, this.guiTexture, this.START_X, this.START_Y, 0.0f, 0.0f, this.GUI_WIDTH, this.GUI_HEIGHT, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + NOTE_OFFSET_X - 1, this.START_Y + NOTE_OFFSET_Y + 55, keyboardTextureShift.intValue(), 250.0f, 308, 26, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        if (this.editMode.booleanValue()) {
            CommonGuiUtils.pushLayer(graphics);
            CommonGuiUtils.rotateLayer(graphics, Float.valueOf(90.0f));
            this.blitAbsolute(graphics, this.guiTexture, -(this.START_Y + 29 + 126), this.START_X + 11, 404.0f, 0.0f, 126, 306, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
            CommonGuiUtils.popLayer(graphics);
            if (MidiNbtDataUtils.getSysInput(this.instrumentStack).booleanValue()) {
                this.blitAbsolute(graphics, this.guiTexture, this.START_X + 127, this.START_Y + 91, 329.0f, 42.0f, 3, 3, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
            }
            this.midiChannelToggle.renderGraphics(graphics, mouseX, mouseY);
            this.transmitSource.renderGraphics(graphics, mouseX, mouseY);
        }
        return graphics;
    }

    private GuiGraphics renderAndCleanNoteSet(GuiGraphics graphics, ConcurrentHashMap<Byte, Instant> noteMap, Integer sustainMillis, Boolean held, Consumer<Map.Entry<Byte, Instant>> removeHandler) {
        ArrayList<Map.Entry<Byte, Instant>> notesToRemove = new ArrayList<Map.Entry<Byte, Instant>>();
        if (!noteMap.isEmpty()) {
            for (Map.Entry<Byte, Instant> entry2 : noteMap.entrySet()) {
                if (Math.abs(ChronoUnit.MILLIS.between(Instant.now(), entry2.getValue())) > (long)sustainMillis.intValue()) {
                    notesToRemove.add(entry2);
                }
                graphics = this.renderNote(graphics, entry2.getKey(), held, entry2.getValue());
            }
            notesToRemove.forEach(entry -> removeHandler.accept((Map.Entry<Byte, Instant>)entry));
        }
        return graphics;
    }

    private GuiGraphics renderNote(GuiGraphics graphics, Byte note, Boolean held, Instant releaseTime) {
        Float alpha = Float.valueOf(1.0f);
        Integer keyNum = this.midiNoteToKeyNum(note);
        if (keyNum == null) {
            return graphics;
        }
        if (!held.booleanValue()) {
            alpha = Float.valueOf(alpha.floatValue() - Math.min((float)Math.abs(ChronoUnit.MILLIS.between(Instant.now(), releaseTime)) / 1000.0f, 1.0f));
        }
        CommonGuiUtils.setAlpha(alpha.floatValue());
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + NOTE_OFFSET_X + (keyNum - 1) * NOTE_WIDTH / 2, this.START_Y + NOTE_OFFSET_Y + 43 + keyNum % 2 * 42, 342 - keyNum % 2 * 13, 0.0f, 12, 41, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        return graphics;
    }

    @Override
    protected GuiGraphics renderText(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawStringAbsolute(graphics, this.font, this.instrumentNameString, this.START_X + 198, this.START_Y + 13, -16718336);
        if (!this.settingsOnly.booleanValue()) {
            this.drawStringAbsolute(graphics, this.font, this.noteIdString.split(",")[0], this.START_X + 102, this.START_Y + 165, -16718336);
            this.drawStringAbsolute(graphics, this.font, this.noteIdString.split(",")[1], this.START_X + 143, this.START_Y + 165, -16718336);
            this.drawStringAbsolute(graphics, this.font, this.noteIdString.split(",")[2], this.START_X + 198, this.START_Y + 165, -16718336);
        }
        if (this.editMode.booleanValue()) {
            this.midiChannelToggle.renderText(graphics, this.font, mouseX, mouseY);
            this.transmitSource.renderText(graphics, this.font, mouseX, mouseY);
            this.drawStringAbsolute(graphics, this.font, MidiNbtDataUtils.getInstrumentVolume(this.instrumentStack).toString(), this.START_X + 88, this.START_Y + 66, -16718336);
        }
        if (this.editMode.booleanValue()) {
            this.drawStringAbsolute(graphics, this.font, ConfigProxy.getKeyboardLayout().toString(), this.START_X + 264, this.START_Y + 35, -16763392);
        } else {
            this.drawStringAbsolute(graphics, this.font, ConfigProxy.getKeyboardLayout().toString(), this.START_X + 264, this.START_Y + 35, -16718336);
        }
        return graphics;
    }

    private String buildNoteIdString() {
        Object result = "";
        result = (String)result + this.noteLetterFromNum(this.visibleNoteShift % 7) + Integer.valueOf(this.visibleNoteShift / 7).toString();
        result = (String)result + "," + this.noteLetterFromNum((this.visibleNoteShift + 10) % 7) + Integer.valueOf((this.visibleNoteShift + 10) / 7).toString();
        result = (String)result + " | " + this.noteLetterFromNum((this.visibleNoteShift + 11) % 7) + Integer.valueOf((this.visibleNoteShift + 11) / 7).toString();
        result = (String)result + "," + this.noteLetterFromNum((this.visibleNoteShift + 21) % 7) + Integer.valueOf((this.visibleNoteShift + 21) / 7).toString();
        return result;
    }

    private String noteLetterFromNum(Integer octaveNoteNum) {
        switch (octaveNoteNum) {
            case 0: {
                return "C";
            }
            case 1: {
                return "D";
            }
            case 2: {
                return "E";
            }
            case 3: {
                return "F";
            }
            case 4: {
                return "G";
            }
            case 5: {
                return "A";
            }
            case 6: {
                return "B";
            }
        }
        return "";
    }
}

