/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.HoldTicksWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.InvertSignalWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.NoteFilterWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.TriggerModeWidget;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.network.ConfigurableMidiTileSyncPacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuiListener
extends BaseGui {
    private static final Vector2Int NOTE_FILTER_WIDGET_COORDS = new Vector2Int(180, 26);
    private static final Vector2Int TRIGGER_MODE_WIDGET_COORDS = new Vector2Int(6, 59);
    private static final Vector2Int HOLD_TICKS_WIDGET_COORDS = new Vector2Int(180, 59);
    private static final Vector2Int FILTER_INSTRUMENT_PREV_BUTTON_COORDS = new Vector2Int(9, 40);
    private static final Vector2Int FILTER_INSTRUMENT_NEXT_BUTTON_COORDS = new Vector2Int(161, 40);
    private static final Vector2Int INVERT_POWER_WIDGET_COORDS = new Vector2Int(281, 5);
    private NoteFilterWidget noteFilter;
    private InvertSignalWidget invertSignal;
    private TriggerModeWidget triggerMode;
    private HoldTicksWidget holdTicks;
    protected List<Byte> INSTRUMENT_ID_LIST;
    protected Integer filterInstrumentIndex = 0;
    private final ItemStack listenerStack;
    private final BlockPos tilePos;
    private final InteractionHand handIn;

    public GuiListener(BlockPos tilePos, InteractionHand handIn, ItemStack listenerStack) {
        super(302, 86, 302, "textures/gui/container_listener.png", "item.MIMIMod.gui_listener");
        if (listenerStack == null || listenerStack.isEmpty()) {
            MIMIMod.LOGGER.error("Listener stack is null or empty. Force closing GUI!");
            Minecraft.getInstance().forceSetScreen((Screen)null);
            this.listenerStack = null;
            this.tilePos = null;
            this.handIn = null;
            return;
        }
        this.tilePos = tilePos;
        this.handIn = handIn;
        this.listenerStack = new ItemStack((ItemLike)listenerStack.getItem(), listenerStack.getCount());
        this.listenerStack.applyComponents(listenerStack.getComponents());
    }

    @Override
    public void init() {
        super.init();
        this.filterInstrumentIndex = this.INSTRUMENT_ID_LIST().indexOf(MidiNbtDataUtils.getFilterInstrument(this.listenerStack));
        this.noteFilter = new NoteFilterWidget(this.listenerStack, new Vector2Int(this.START_X, this.START_Y), NOTE_FILTER_WIDGET_COORDS);
        this.invertSignal = new InvertSignalWidget(this.listenerStack, new Vector2Int(this.START_X, this.START_Y), INVERT_POWER_WIDGET_COORDS);
        this.triggerMode = new TriggerModeWidget(this.listenerStack, new Vector2Int(this.START_X, this.START_Y), TRIGGER_MODE_WIDGET_COORDS);
        this.holdTicks = new HoldTicksWidget(this.listenerStack, new Vector2Int(this.START_X, this.START_Y), HOLD_TICKS_WIDGET_COORDS);
    }

    public void syncListenerToServer() {
        NetworkProxy.sendToServer(new ConfigurableMidiTileSyncPacket(this.listenerStack, this.tilePos, this.handIn));
    }

    public boolean mouseClicked(double dmouseX, double dmouseY, int mouseButton) {
        int imouseX = (int)Math.round(dmouseX);
        int imouseY = (int)Math.round(dmouseY);
        if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(FILTER_INSTRUMENT_PREV_BUTTON_COORDS)).booleanValue()) {
            this.shiftInstrumentId(false);
            this.syncListenerToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(FILTER_INSTRUMENT_NEXT_BUTTON_COORDS)).booleanValue()) {
            this.shiftInstrumentId(true);
            this.syncListenerToServer();
        } else if (this.noteFilter.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        } else if (this.invertSignal.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        } else if (this.triggerMode.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        } else if (this.holdTicks.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        }
        return super.mouseClicked(dmouseX, dmouseY, mouseButton);
    }

    @Override
    protected GuiGraphics renderGraphics(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.blitAbsolute(graphics, this.guiTexture, this.START_X, this.START_Y, 0.0f, 0.0f, this.GUI_WIDTH, this.GUI_HEIGHT, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        this.noteFilter.renderGraphics(graphics, mouseX, mouseY);
        this.invertSignal.renderGraphics(graphics, mouseX, mouseY);
        this.triggerMode.renderGraphics(graphics, mouseX, mouseY);
        this.holdTicks.renderGraphics(graphics, mouseX, mouseY);
        return graphics;
    }

    @Override
    protected GuiGraphics renderText(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawStringAbsolute(graphics, this.font, MidiNbtDataUtils.getInstrumentName(MidiNbtDataUtils.getFilterInstrument(this.listenerStack)), this.START_X + 30, this.START_Y + 44, -16718336);
        this.noteFilter.renderText(graphics, this.font, mouseX, mouseY);
        this.invertSignal.renderText(graphics, this.font, mouseX, mouseY);
        this.triggerMode.renderText(graphics, this.font, mouseX, mouseY);
        this.holdTicks.renderText(graphics, this.font, mouseX, mouseY);
        return graphics;
    }

    public List<Byte> INSTRUMENT_ID_LIST() {
        if (this.INSTRUMENT_ID_LIST == null) {
            this.INSTRUMENT_ID_LIST = MidiNbtDataUtils.INSTRUMENT_NAME_MAP().keySet().stream().sorted().collect(Collectors.toList());
        }
        return this.INSTRUMENT_ID_LIST;
    }

    public void shiftInstrumentId(Boolean up) {
        if (up.booleanValue()) {
            if (this.filterInstrumentIndex < this.INSTRUMENT_ID_LIST().size() - 1) {
                Integer n = this.filterInstrumentIndex;
                this.filterInstrumentIndex = this.filterInstrumentIndex + 1;
            } else {
                this.filterInstrumentIndex = 0;
            }
        } else if (this.filterInstrumentIndex > 0) {
            Integer n = this.filterInstrumentIndex;
            this.filterInstrumentIndex = this.filterInstrumentIndex - 1;
        } else {
            this.filterInstrumentIndex = this.INSTRUMENT_ID_LIST().size() - 1;
        }
        MidiNbtDataUtils.setFilterInstrument(this.listenerStack, this.INSTRUMENT_ID_LIST().get(this.filterInstrumentIndex));
    }
}

