/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.midi.BasicMidiInfo;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerSongListPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerStatusPacket;
import io.github.tofodroid.mods.mimi.common.network.TransmitterControlPacket;
import io.github.tofodroid.mods.mimi.server.midi.playlist.APlaylistHandler;
import io.github.tofodroid.mods.mimi.util.MidiFileUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class GuiTransmitterBlock
extends BaseGui {
    protected static final Integer UPDATE_STATUS_EVERY_TICKS = 10;
    protected static final Integer UPDATE_LIST_EVERY_TICKS = 40;
    protected static final Integer ANIM_FRAME_EVERY_TICKS = 3;
    protected static final Integer LOADING_ANIMATION_FRAMES = 4;
    protected static final Vector2Int FAVORITE_FILTER_BUTTON = new Vector2Int(300, 32);
    protected static final Vector2Int FAVORITE_FILTER_SCREEN = new Vector2Int(318, 33);
    protected static final Vector2Int REFRESH_SONGS_BUTTON = new Vector2Int(335, 32);
    protected static final Vector2Int OPEN_LOCAL_FOLDER_BUTTON = new Vector2Int(10, 32);
    protected static final Vector2Int TOGGLE_FAVORITE_BUTTON = new Vector2Int(335, 118);
    protected static final Vector2Int PREVIOUS_BUTTON = new Vector2Int(10, 231);
    protected static final Vector2Int STOP_BUTTON = new Vector2Int(29, 231);
    protected static final Vector2Int PLAY_PAUSE_BUTTON = new Vector2Int(48, 231);
    protected static final Vector2Int NEXT_BUTTON = new Vector2Int(67, 231);
    protected static final Vector2Int LOOP_BUTTON = new Vector2Int(86, 231);
    protected static final Vector2Int LOOP_SCREEN = new Vector2Int(104, 232);
    protected static final Vector2Int SHUFFLE_BUTTON = new Vector2Int(121, 231);
    protected static final Vector2Int SHUFFLE_SCREEN = new Vector2Int(139, 232);
    protected static final Integer SLIDE_MIN_Y = 230;
    protected static final Integer SLIDE_MAX_Y = 247;
    protected static final Integer SLIDE_MIN_X = 166;
    protected static final Integer SLIDE_MAX_X = 335;
    protected static final Integer SLIDE_WIDTH = SLIDE_MAX_X - SLIDE_MIN_X;
    protected static final Integer SLIDE_HEIGHT = SLIDE_MAX_Y - SLIDE_MIN_Y;
    protected static final Vector2Int SLIDE_CLICK_START = new Vector2Int(SLIDE_MIN_X - 4, SLIDE_MIN_Y);
    protected static final Vector2Int SLIDE_CLICK_SIZE = new Vector2Int(SLIDE_WIDTH + 8, SLIDE_HEIGHT);
    protected Integer ticksSinceUpdateStat = 0;
    protected Integer ticksSinceUpdateList = 0;
    protected Integer ticksSinceAnimFrame = 0;
    protected Integer loadingAnimationFrame = 0;
    protected UUID musicPlayerId;
    protected ServerMusicPlayerStatusPacket musicStatus;
    protected ServerMusicPlayerSongListPacket songList;
    protected Boolean awaitRefresh = true;

    public GuiTransmitterBlock(UUID musicPlayerId) {
        super(360, 255, 360, "textures/gui/container_transmitter.png", "item.MIMIMod.gui_transmitter");
        this.musicPlayerId = musicPlayerId;
        this.musicStatus = new ServerMusicPlayerStatusPacket(musicPlayerId);
        this.songList = new ServerMusicPlayerSongListPacket(musicPlayerId);
    }

    public UUID getMusicPlayerId() {
        return this.musicPlayerId;
    }

    @Override
    public void init() {
        super.init();
        this.startRefreshPlayerStatus();
        this.startRefreshSongList();
    }

    public void tick() {
        Integer n;
        if (this.ticksSinceUpdateStat >= UPDATE_STATUS_EVERY_TICKS) {
            this.startRefreshPlayerStatus();
            this.ticksSinceUpdateStat = 0;
        } else {
            n = this.ticksSinceUpdateStat;
            this.ticksSinceUpdateStat = this.ticksSinceUpdateStat + 1;
        }
        if (this.ticksSinceUpdateList >= UPDATE_LIST_EVERY_TICKS) {
            this.startRefreshSongList();
            this.ticksSinceUpdateList = 0;
        } else {
            n = this.ticksSinceUpdateList;
            this.ticksSinceUpdateList = this.ticksSinceUpdateList + 1;
        }
        if (this.ticksSinceAnimFrame >= ANIM_FRAME_EVERY_TICKS) {
            this.ticksSinceAnimFrame = 0;
            if (this.loadingAnimationFrame < LOADING_ANIMATION_FRAMES - 1) {
                n = this.loadingAnimationFrame;
                this.loadingAnimationFrame = this.loadingAnimationFrame + 1;
            } else {
                this.loadingAnimationFrame = 0;
            }
        } else {
            n = this.ticksSinceAnimFrame;
            this.ticksSinceAnimFrame = this.ticksSinceAnimFrame + 1;
        }
    }

    public void handleMusicPlayerStatusPacket(ServerMusicPlayerStatusPacket packet) {
        this.musicStatus = packet;
    }

    public void handleMusicplayerSongListPacket(ServerMusicPlayerSongListPacket packet) {
        this.songList = packet;
        this.awaitRefresh = false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int imouseX = (int)Math.round(mouseX);
        int imouseY = (int)Math.round(mouseY);
        if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(FAVORITE_FILTER_BUTTON)).booleanValue()) {
            this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.FAVE_M);
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(OPEN_LOCAL_FOLDER_BUTTON)).booleanValue() && this.isSinglePlayerOrLANHost().booleanValue()) {
            Util.getPlatform().openUri(Path.of(MIMIMod.getProxy().serverMidiFiles().getCurrentFolderPath(), new String[0]).toUri());
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(REFRESH_SONGS_BUTTON)).booleanValue()) {
            this.onRefreshClick();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(TOGGLE_FAVORITE_BUTTON)).booleanValue()) {
            this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.MARKFAVE);
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(PREVIOUS_BUTTON)).booleanValue()) {
            Double slidePercentage = null;
            if (this.musicStatus.songPositionSeconds != null && this.musicStatus.songLengthSeconds != null && this.musicStatus.songLengthSeconds > 0) {
                slidePercentage = Double.valueOf(this.musicStatus.songPositionSeconds.intValue()) / Double.valueOf(this.musicStatus.songLengthSeconds.intValue());
            }
            if (slidePercentage != null && slidePercentage >= 0.25) {
                this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.RESTART);
            } else {
                this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.PREV);
            }
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(STOP_BUTTON)).booleanValue()) {
            this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.STOP);
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(PLAY_PAUSE_BUTTON)).booleanValue()) {
            if (this.musicStatus.isPlaying.booleanValue()) {
                this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.PAUSE);
            } else {
                this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.PLAY);
            }
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(NEXT_BUTTON)).booleanValue()) {
            this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.NEXT);
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(LOOP_BUTTON)).booleanValue()) {
            this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.LOOP_M);
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SHUFFLE_BUTTON)).booleanValue()) {
            this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.SHUFFLE);
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SLIDE_CLICK_START), SLIDE_CLICK_SIZE).booleanValue()) {
            Integer percent = Double.valueOf(Math.floor(1000.0 * (Double.valueOf(imouseX - 4 - SLIDE_MIN_X - this.START_X) / Double.valueOf(SLIDE_WIDTH.intValue())))).intValue();
            percent = percent < 0 ? 0 : (percent > 1000 ? 1000 : percent);
            this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.SEEK, percent);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void onRefreshClick() {
        this.startRefreshSongList();
    }

    public Boolean isSinglePlayerOrLANHost() {
        return Minecraft.getInstance().player != null && Minecraft.getInstance().hasSingleplayerServer();
    }

    @Override
    protected GuiGraphics renderGraphics(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.blitAbsolute(graphics, this.guiTexture, this.START_X, this.START_Y, 0.0f, 0.0f, this.GUI_WIDTH, this.GUI_HEIGHT, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        if (!this.songList.infos.isEmpty() && this.musicStatus.fileIndex != null && !this.awaitRefresh.booleanValue()) {
            Integer songOffset = this.getSongBoxOffset();
            Integer boxY = this.getFirstSongY() - 2 + 11 * songOffset;
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 10, this.START_Y + boxY, 1.0f, 257.0f, 340, 11, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        }
        if (!this.musicStatus.isLoading.booleanValue()) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 49, this.START_Y + 232, this.musicStatus.isPlaying != false ? 14.0f : 1.0f, 283.0f, 13, 13, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        } else {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 49, this.START_Y + 232, 1 + this.loadingAnimationFrame * 13, 312.0f, 13, 13, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        }
        if (this.isSinglePlayerOrLANHost().booleanValue()) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 9, this.START_Y + 31, 173.0f, 269.0f, 17, 17, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        }
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + 336, this.START_Y + 117, this.musicStatus.isFileFavorite != false ? 40.0f : 27.0f, 283.0f, 13, 13, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + FAVORITE_FILTER_SCREEN.x(), this.START_Y + FAVORITE_FILTER_SCREEN.y(), 66 + 13 * this.musicStatus.favoriteMode.ordinal(), 269.0f, 13, 13, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + LOOP_SCREEN.x(), this.START_Y + LOOP_SCREEN.y(), 1 + 13 * this.musicStatus.loopMode.ordinal(), 269.0f, 13, 13, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + SHUFFLE_SCREEN.x(), this.START_Y + SHUFFLE_SCREEN.y(), 40 + 13 * (this.musicStatus.isShuffled != false ? 1 : 0), 269.0f, 13, 13, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        Integer slideOffset = 0;
        if (this.musicStatus.songPositionSeconds != null && this.musicStatus.songLengthSeconds != null && this.musicStatus.songLengthSeconds > 0) {
            Integer slideLength = this.musicStatus.songLengthSeconds;
            Integer slideProgress = this.musicStatus.songPositionSeconds;
            Double slidePercentage = Double.valueOf(slideProgress.intValue()) / Double.valueOf(slideLength.intValue());
            slideOffset = Double.valueOf(Math.floor(slidePercentage * (double)SLIDE_WIDTH.intValue())).intValue();
        }
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + SLIDE_MIN_X + slideOffset, this.START_Y + SLIDE_MIN_Y, 352.0f, 257.0f, 7, 17, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        return graphics;
    }

    @Override
    protected GuiGraphics renderText(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.songList.infos.isEmpty() && !this.awaitRefresh.booleanValue()) {
            Integer minSong = this.getMinSong();
            for (int i = 0; i < this.getVisibleSongs() && this.songList.infos.size() > minSong + i; ++i) {
                BasicMidiInfo info = this.songList.infos.get(minSong + i);
                this.drawStringAbsolute(graphics, this.font, CommonGuiUtils.truncateString(this.font, (minSong + i < 9 ? "0" : "") + (minSong + i + 1) + "). " + info.fileName, this.maxPlaylistSongTitleWidth()), this.START_X + 12, this.START_Y + this.getFirstSongY() + i * 11, -16718336);
                this.renderPlaylistSongBadges(graphics, info, i, minSong);
            }
        } else {
            this.drawStringAbsolute(graphics, this.font, this.awaitRefresh != false ? "Loading..." : "No songs found", this.START_X + 12, this.START_Y + this.getFirstSongY(), -16718336);
        }
        if (!this.musicStatus.isLoading.booleanValue() && this.musicStatus.isLoadFailed.booleanValue()) {
            this.drawStringAbsolute(graphics, this.font, "Song failed to load:", this.START_X + 12, this.START_Y + 153, -16718336);
            this.drawStringAbsolute(graphics, this.font, "It may be invalid or may have been deleted. Refresh the", this.START_X + 12, this.START_Y + 159, -16718336);
            this.drawStringAbsolute(graphics, this.font, "list with the button in the top right and select a new song.", this.START_X + 12, this.START_Y + 169, -16718336);
        } else if (this.musicStatus.fileIndex != null && this.musicStatus.fileIndex >= 0 && this.musicStatus.fileIndex < this.songList.infos.size()) {
            BasicMidiInfo info = this.songList.infos.get(this.musicStatus.fileIndex);
            this.drawStringAbsolute(graphics, this.font, CommonGuiUtils.truncateString(this.font, info.fileName, 264), this.START_X + 66, this.START_Y + 120, -16718336);
            if (this.musicStatus.isLoading.booleanValue()) {
                this.drawStringAbsolute(graphics, this.font, "Channel Instrument Assignments: Loading...", this.START_X + 12, this.START_Y + 135, -16718336);
            } else if (this.musicStatus.channelMapping != null) {
                Integer n;
                String name;
                Map<Integer, String> instrumentMapping = MidiFileUtils.getInstrumentMapping(this.musicStatus.channelMapping);
                this.drawStringAbsolute(graphics, this.font, "Channel Instrument Assignments: ", this.START_X + 12, this.START_Y + 135, -16718336);
                Integer index = 0;
                Integer i = 0;
                while (i < 16) {
                    name = instrumentMapping.get(i) == null ? "None" : instrumentMapping.get(i);
                    this.drawStringAbsolute(graphics, this.font, (i < 9 ? "0" : "") + (i + 1) + ": " + name, this.START_X + 12, this.START_Y + 149 + 10 * index, -16718336);
                    n = index;
                    index = index + 1;
                    i = i + 2;
                }
                index = 0;
                i = 1;
                while (i < 16) {
                    name = instrumentMapping.get(i) == null ? "None" : instrumentMapping.get(i);
                    this.drawStringAbsolute(graphics, this.font, (i < 9 ? "0" : "") + (i + 1) + ": " + name, this.START_X + 180, this.START_Y + 149 + 10 * index, -16718336);
                    n = index;
                    index = index + 1;
                    i = i + 2;
                }
            }
        }
        return graphics;
    }

    protected Integer maxPlaylistSongTitleWidth() {
        return 324;
    }

    protected GuiGraphics renderPlaylistSongBadges(GuiGraphics graphics, BasicMidiInfo info, Integer songIndex, Integer minSong) {
        if (this.musicStatus.favoriteMode != APlaylistHandler.FavoriteMode.NOT_FAVORITE && (this.musicStatus.favoriteMode == APlaylistHandler.FavoriteMode.FAVORITE || this.songList.favoriteIndicies.contains(minSong + songIndex))) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 339, this.START_Y + this.getFirstSongY() - 1 + songIndex * 11, 145.0f, 269.0f, 9, 9, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        }
        return graphics;
    }

    protected Integer getVisibleSongs() {
        return 5;
    }

    protected Integer getFirstSongY() {
        return 52;
    }

    protected Integer getMinSong() {
        if (this.songList.infos.size() <= this.getVisibleSongs() || this.musicStatus.fileIndex == null || this.musicStatus.fileIndex < 2) {
            return 0;
        }
        if (this.musicStatus.fileIndex >= this.songList.infos.size() - 2) {
            return this.songList.infos.size() - this.getVisibleSongs();
        }
        return this.musicStatus.fileIndex - 2;
    }

    protected Integer getSongBoxOffset() {
        if (this.musicStatus.fileIndex != null && (this.songList.infos.size() <= this.getVisibleSongs() || this.musicStatus.fileIndex < 2)) {
            return this.musicStatus.fileIndex;
        }
        if (this.musicStatus.fileIndex != null && this.musicStatus.fileIndex >= this.songList.infos.size() - 2) {
            return this.getVisibleSongs() - (this.songList.infos.size() - this.musicStatus.fileIndex);
        }
        return 2;
    }

    protected void sendTransmitterCommand(TransmitterControlPacket.CONTROL control, Integer data) {
        NetworkProxy.sendToServer(new TransmitterControlPacket(this.musicPlayerId, control, data));
    }

    protected void sendTransmitterCommand(TransmitterControlPacket.CONTROL control) {
        NetworkProxy.sendToServer(new TransmitterControlPacket(this.musicPlayerId, control));
    }

    protected void startRefreshPlayerStatus() {
        NetworkProxy.sendToServer(new ServerMusicPlayerStatusPacket(this.musicPlayerId));
    }

    protected void startRefreshSongList() {
        NetworkProxy.sendToServer(new ServerMusicPlayerSongListPacket(this.musicPlayerId));
    }
}

