/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AudioOutputDeviceManager {
    private static final Integer[] IDEAL_CHANNELS = new Integer[]{2, 1};
    private static final Integer[] IDEAL_BIT_RATES = new Integer[]{16, 8, 4};
    private static final Float[] IDEAL_SAMPLE_RATES = new Float[]{Float.valueOf(48000.0f), Float.valueOf(44100.0f), Float.valueOf(22050.0f), Float.valueOf(16000.0f), Float.valueOf(11025.0f), Float.valueOf(8000.0f)};
    private Mixer currentDevice = null;
    private Pair<String, Integer> targetDeviceId = ImmutablePair.of(null, (Object)0);
    private AudioFormat currentFormat = null;
    private DataLine.Info currentLine = null;

    public AudioOutputDeviceManager() {
        this.refreshDevice();
    }

    public Pair<AudioFormat, SourceDataLine> getOutputFormatLine() {
        if (this.currentDevice != null && this.currentLine != null) {
            try {
                return ImmutablePair.of((Object)this.currentFormat, (Object)AudioSystem.getSourceDataLine(this.currentFormat, this.currentDevice.getMixerInfo()));
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to open target data line on target device: ", (Throwable)e);
                this.currentFormat = null;
                this.currentLine = null;
            }
        }
        return ImmutablePair.of(null, null);
    }

    public void refreshDevice() {
        AudioFormat targetFormat;
        Pair<AudioFormat, DataLine.Info> outputLineInfo;
        this.currentLine = null;
        this.currentFormat = null;
        this.targetDeviceId = AudioOutputDeviceManager.getTargetDeviceId();
        this.currentDevice = this.getTargetDevice();
        if (this.currentDevice != null && (outputLineInfo = AudioOutputDeviceManager.getBestFormatLine(this.currentDevice, targetFormat = new AudioFormat(ConfigProxy.getSynthSampleRate().intValue(), ConfigProxy.getSynthBitRate(), 2, true, false))).getLeft() != null && outputLineInfo.getRight() != null) {
            this.currentLine = (DataLine.Info)outputLineInfo.getRight();
            this.currentFormat = (AudioFormat)outputLineInfo.getLeft();
        }
    }

    public void setAutomaticDevice() {
        ConfigProxy.setAutomaticAudioDevice(true);
        ConfigProxy.setAudioOutputDevice("");
        this.refreshDevice();
    }

    public void setDevice(String deviceName) {
        ConfigProxy.setAutomaticAudioDevice(false);
        ConfigProxy.setAudioOutputDevice(deviceName.trim());
        this.refreshDevice();
    }

    public String getCurrentDeviceName() {
        if (ConfigProxy.getAutomaticAudioDevice().booleanValue()) {
            return "Auto: " + (String)(((String)this.targetDeviceId.getLeft()).isBlank() ? "Default" : (String)this.targetDeviceId.getLeft() + (String)((Integer)this.targetDeviceId.getRight() > 0 ? " #" + ((Integer)this.targetDeviceId.getRight() + 1) : ""));
        }
        return "Set: " + ConfigProxy.getAudioOutputDevice();
    }

    public String getCurrentDeviceStatus() {
        if (ConfigProxy.getAutomaticAudioDevice().booleanValue()) {
            if (this.currentDevice != null) {
                if (this.currentLine == null) {
                    return "Device encountered an error. Outputting to system-provided device.";
                }
                if (((String)this.targetDeviceId.getLeft()).isBlank() || this.currentDevice.getMixerInfo().getName().equals(this.targetDeviceId.getLeft())) {
                    return "Connected.";
                }
                return "Failed to connect to device. Outputting to system-provided device.";
            }
            return "Failed to find device. Outputting to system-provided device.";
        }
        if (this.currentDevice != null) {
            if (this.currentLine == null) {
                return "Device encountered an error. Outputting to system-provided device.";
            }
            return "Connected.";
        }
        return "Failed to find device. Outputting to system-provided device.";
    }

    public Mixer getTargetDevice() {
        if (this.targetDeviceId.getLeft() != null) {
            return this.getOutputDeviceByNameAndNumber((String)this.targetDeviceId.getLeft(), (Integer)this.targetDeviceId.getRight());
        }
        return null;
    }

    public static Pair<String, Integer> getTargetDeviceId() {
        String targetDeviceName = null;
        Integer targetDeviceMatchNumber = 0;
        if (ConfigProxy.getAutomaticAudioDevice().booleanValue()) {
            targetDeviceName = AudioOutputDeviceManager.getMinecraftOutputDeviceName();
            if (targetDeviceName.toLowerCase().matches(".* #[0-9][0-9]*$")) {
                targetDeviceMatchNumber = Integer.parseInt(targetDeviceName.substring(targetDeviceName.lastIndexOf("#") + 1).trim()) - 1;
                targetDeviceName = targetDeviceName.substring(0, targetDeviceName.lastIndexOf("#")).trim();
            }
        } else if (!ConfigProxy.getAudioOutputDevice().isBlank() && (targetDeviceName = ConfigProxy.getAudioOutputDevice().trim()).toLowerCase().matches(".* #[0-9][0-9]*$")) {
            targetDeviceMatchNumber = Integer.parseInt(targetDeviceName.substring(targetDeviceName.lastIndexOf("#") + 1).trim()) - 1;
            targetDeviceName = targetDeviceName.substring(0, targetDeviceName.lastIndexOf("#")).trim();
        }
        return ImmutablePair.of((Object)targetDeviceName, (Object)targetDeviceMatchNumber);
    }

    public List<Mixer> getAvailableOutputDevices() {
        ArrayList<Mixer> outputDevices = new ArrayList<Mixer>();
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(info);
            if (AudioOutputDeviceManager.scanMaxChannels(mixer.getSourceLineInfo()) <= 0) continue;
            outputDevices.add(mixer);
        }
        return outputDevices;
    }

    public Mixer getOutputDeviceByNameAndNumber(String deviceName, Integer matchNumber) {
        Mixer target;
        List<Mixer> outputDevices = this.getAvailableOutputDevices();
        ArrayList<Mixer> matchingDevices = new ArrayList<Mixer>();
        if (deviceName.isEmpty()) {
            if (!outputDevices.isEmpty()) {
                if (outputDevices.size() > matchNumber) {
                    Mixer device = outputDevices.get(matchNumber);
                    MIMIMod.LOGGER.info("Opened Target Device: " + device.getMixerInfo().getName() + " (" + matchNumber + ")");
                    return device;
                }
                Mixer device = outputDevices.get(0);
                MIMIMod.LOGGER.warn("Expected to find at least " + matchNumber + " devices but only found " + matchingDevices.size() + ". Using first found device (System Default).");
                MIMIMod.LOGGER.info("Opened Target Device: " + device.getMixerInfo().getName() + " (" + matchNumber + ")");
                return device;
            }
        } else {
            for (Mixer device : outputDevices) {
                if (!device.getMixerInfo().getName().equals(deviceName)) continue;
                matchingDevices.add(device);
            }
        }
        if (matchingDevices.size() > matchNumber) {
            target = (Mixer)matchingDevices.get(matchNumber);
            MIMIMod.LOGGER.info("Opened Target Device: " + target.getMixerInfo().getName() + " (" + matchNumber + ")");
            return target;
        }
        if (!matchingDevices.isEmpty()) {
            target = (Mixer)matchingDevices.get(0);
            MIMIMod.LOGGER.warn("Expected to find at least " + matchNumber + " devices with name '" + deviceName + "' but only found " + matchingDevices.size() + ". Using first found device.");
            MIMIMod.LOGGER.info("Opened Target Device: " + target.getMixerInfo().getName() + " (" + matchNumber + ")");
            return target;
        }
        return null;
    }

    private static String getMinecraftOutputDeviceName() {
        String mcDevice = Minecraft.getInstance().getSoundManager().soundEngine.library.getCurrentDeviceName();
        if (mcDevice.toLowerCase().indexOf(" on ") >= 0) {
            mcDevice = mcDevice.substring(mcDevice.toLowerCase().indexOf(" on ") + 4).trim();
        }
        return mcDevice;
    }

    public static List<String> getDeviceDisplayNames(List<Mixer> devices) {
        HashMap<String, Integer> nameCounter = new HashMap<String, Integer>();
        ArrayList<String> outputNames = new ArrayList<String>();
        for (Mixer device : devices) {
            Integer count = nameCounter.computeIfAbsent(device.getMixerInfo().getName(), m -> 0) + 1;
            nameCounter.put(device.getMixerInfo().getName(), count);
            outputNames.add(device.getMixerInfo().getName() + (String)(count > 1 ? " #" + count : ""));
        }
        return outputNames;
    }

    private static AudioFormat getBestFormatForLine(AudioFormat targetFormat, DataLine.Info lineInfo) {
        List linesFormats = Arrays.asList(lineInfo.getFormats()).stream().filter(format -> format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)).collect(Collectors.toList());
        AudioFormat bestFormat = null;
        if (lineInfo.isFormatSupported(targetFormat)) {
            return targetFormat;
        }
        for (AudioFormat format2 : linesFormats) {
            for (Integer channels : IDEAL_CHANNELS) {
                for (Integer bitRate : IDEAL_BIT_RATES) {
                    for (Float sampleRate : IDEAL_SAMPLE_RATES) {
                        if (format2.getSampleSizeInBits() > targetFormat.getSampleSizeInBits() || !(format2.getSampleRate() <= targetFormat.getSampleRate()) || format2.getChannels() != channels.intValue() && format2.getChannels() != -1 || format2.getSampleSizeInBits() != bitRate.intValue() && format2.getSampleSizeInBits() != -1 || format2.getSampleRate() != sampleRate.floatValue() && format2.getSampleRate() != -1.0f) continue;
                        bestFormat = format2;
                    }
                }
            }
        }
        return bestFormat;
    }

    private static Pair<AudioFormat, DataLine.Info> getBestFormatLine(Mixer outputDevice, AudioFormat targetFormat) {
        AudioFormat bestFormat = null;
        DataLine.Info bestLine = null;
        if (outputDevice != null) {
            List idealLines = Arrays.asList(outputDevice.getSourceLineInfo()).stream().filter(line -> line.getLineClass() == SourceDataLine.class).map(line -> (DataLine.Info)line).collect(Collectors.toList());
            for (DataLine.Info lineInfo : idealLines) {
                if (lineInfo.isFormatSupported(targetFormat)) {
                    return ImmutablePair.of((Object)targetFormat, (Object)lineInfo);
                }
                AudioFormat bestLineFormat = AudioOutputDeviceManager.getBestFormatForLine(targetFormat, lineInfo);
                if (bestLineFormat == null) continue;
                if (bestFormat == null) {
                    bestFormat = bestLineFormat;
                    bestLine = lineInfo;
                    continue;
                }
                if (bestLineFormat.getChannels() < bestFormat.getChannels() || bestLineFormat.getSampleSizeInBits() < bestFormat.getSampleSizeInBits() || !(bestLineFormat.getSampleRate() >= bestFormat.getSampleRate())) continue;
                bestFormat = bestLineFormat;
                bestLine = lineInfo;
            }
            if (bestLine != null) {
                return ImmutablePair.of(bestFormat, bestLine);
            }
        }
        MIMIMod.LOGGER.warn("Failed to find any supported Audio Output Devices. Attempting fallback to System Default.");
        return null;
    }

    private static int scanMaxChannels(Line.Info[] lines) {
        int maxChannels = 0;
        for (Line.Info line : lines) {
            int numChannels;
            if (!(line instanceof DataLine.Info) || (numChannels = AudioOutputDeviceManager.scanMaxChannels((DataLine.Info)line)) <= maxChannels) continue;
            maxChannels = numChannels;
        }
        return maxChannels;
    }

    private static int scanMaxChannels(DataLine.Info info) {
        int maxChannels = 0;
        for (AudioFormat format : info.getFormats()) {
            int numChannels = format.getChannels();
            if (numChannels <= maxChannels) continue;
            maxChannels = numChannels;
        }
        return maxChannels;
    }
}

