/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import io.github.tofodroid.mods.mimi.client.midi.MidiInputDeviceManager;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerStatusPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;

public class MidiDataManager {
    public static final Integer UPDATE_MUSIC_PLAYER_STATUS_EVERY_TICKS = 10;
    public final MidiInputDeviceManager inputDeviceManager = new MidiInputDeviceManager();
    private ServerMusicPlayerStatusPacket playerTransmitterStatusPacket;
    private Integer updateTickCount = 0;

    public void setPlayerStatusPakcet(ServerMusicPlayerStatusPacket packet) {
        this.playerTransmitterStatusPacket = this.connectedToServer() != false ? packet : null;
    }

    public Boolean hasPlayerStatus() {
        return this.connectedToServer() != false && this.playerTransmitterStatusPacket != null;
    }

    public ServerMusicPlayerStatusPacket getPlayerStatusPacket() {
        if (this.connectedToServer().booleanValue()) {
            return this.playerTransmitterStatusPacket;
        }
        return null;
    }

    public Boolean connectedToServer() {
        return Minecraft.getInstance().player != null && (Minecraft.getInstance().hasSingleplayerServer() || Minecraft.getInstance().getCurrentServer() != null);
    }

    public void handleClientTick() {
        if (!this.connectedToServer().booleanValue()) {
            return;
        }
        if (this.updateTickCount >= UPDATE_MUSIC_PLAYER_STATUS_EVERY_TICKS) {
            this.updateTickCount = 0;
            NetworkProxy.sendToServer(new ServerMusicPlayerStatusPacket(Minecraft.getInstance().player.getUUID()));
        } else {
            Integer n = this.updateTickCount;
            this.updateTickCount = this.updateTickCount + 1;
        }
    }

    public void handlePlayerTick(Player player) {
        this.inputDeviceManager.handlePlayerTick(player);
    }

    public void handleLoginLogout() {
        this.playerTransmitterStatusPacket = null;
        this.updateTickCount = 0;
    }
}

