/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import io.github.tofodroid.mods.mimi.client.midi.MidiDeviceInputReceiver;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrumentHandheld;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class MidiInputDeviceManager {
    private List<Pair<InteractionHand, ItemStack>> localInstrumentsToPlay = new ArrayList<Pair<InteractionHand, ItemStack>>();
    protected Receiver activeReceiver = null;
    protected Transmitter activeTransmitter = null;
    protected MidiDevice activeDevice = null;
    private Boolean transmitMidiInput = false;
    private String selectedDeviceName = "";
    private String midiDeviceError = null;

    public MidiInputDeviceManager() {
        final MidiInputDeviceManager self = this;
        Runtime.getRuntime().addShutdownHook(new Thread(this){

            @Override
            public void run() {
                MIMIMod.LOGGER.info("Closing selected MIDI device...");
                ExecutorService ex = Executors.newSingleThreadExecutor();
                Future<?> future = ex.submit(() -> self.close());
                try {
                    future.get(10000L, TimeUnit.MILLISECONDS);
                    ex.shutdownNow();
                    ex = null;
                    this.interrupt();
                }
                catch (Exception e) {
                    MIMIMod.LOGGER.error("Java ran into an error closing the selected MIDI device. Error: " + e.getMessage());
                    if (!future.isDone()) {
                        future.cancel(true);
                    }
                    try {
                        ex.shutdownNow();
                        ex = null;
                        this.interrupt();
                    }
                    catch (Exception e2) {
                        MIMIMod.LOGGER.error("Failed to stop executor: " + e2.getMessage());
                        ex = null;
                        this.interrupt();
                    }
                }
            }
        });
    }

    public Boolean isDeviceError() {
        return this.midiDeviceError != null;
    }

    public Boolean isDeviceSelected() {
        return this.selectedDeviceName != null && !this.selectedDeviceName.trim().isEmpty();
    }

    public Boolean isDeviceAvailable() {
        return this.activeTransmitter != null;
    }

    public String getSelectedDeviceName() {
        return this.selectedDeviceName;
    }

    public String getSelectedDeviceError() {
        return this.midiDeviceError;
    }

    public Boolean getTransmitMidiInput() {
        return this.transmitMidiInput;
    }

    public void toggleTransmitMidiInput() {
        this.transmitMidiInput = this.transmitMidiInput == false;
    }

    public void setTransmitMidiInput(Boolean transmitMidiInput) {
        this.transmitMidiInput = transmitMidiInput;
    }

    public void saveDeviceSelection(MidiDevice device) {
        if (this.activeTransmitter == null) {
            this.selectedDeviceName = device.getDeviceInfo().getName();
            this.open();
        }
    }

    public List<MidiDevice> getAvailableDevices() {
        List<MidiDevice> devices = new ArrayList<MidiDevice>();
        for (int i = 0; i < MidiSystem.getMidiDeviceInfo().length; ++i) {
            try {
                devices.add(MidiSystem.getMidiDevice(MidiSystem.getMidiDeviceInfo()[i]));
                continue;
            }
            catch (MidiUnavailableException e) {
                MIMIMod.LOGGER.warn("Midi Device Error. Device will be skipped. Error: ", (Throwable)e);
            }
        }
        MIMIMod.LOGGER.info("Detected MIDI Input Devices: ");
        if (!devices.isEmpty()) {
            devices = devices.stream().filter(d -> d.getClass().getName().equals("com.sun.media.sound.MidiInDevice")).map(d -> {
                MIMIMod.LOGGER.info("    " + d.getDeviceInfo().getName() + "(" + d.getClass().getName().toString() + ")");
                return d;
            }).collect(Collectors.toList());
        }
        return devices;
    }

    public void handlePlayerTick(Player player) {
        if (!player.getUUID().equals(Minecraft.getInstance().player.getUUID())) {
            return;
        }
        if (player.isAlive() && player.isAddedToWorld()) {
            this.localInstrumentsToPlay = this.localInstrumentsToPlay(player);
        } else {
            this.localInstrumentsToPlay.clear();
        }
    }

    protected List<Pair<InteractionHand, ItemStack>> localInstrumentsToPlay(Player player) {
        ItemStack offHand;
        ItemStack mainHand;
        ArrayList<Pair<InteractionHand, ItemStack>> result = new ArrayList<Pair<InteractionHand, ItemStack>>();
        TileInstrument instrumentEntity = BlockInstrument.getTileInstrumentForEntity((LivingEntity)player);
        if (instrumentEntity != null) {
            result.add(Pair.of(null, (Object)instrumentEntity.getSourceStack()));
        }
        if ((mainHand = ItemInstrumentHandheld.getEntityHeldInstrumentStack((LivingEntity)player, InteractionHand.MAIN_HAND)) != null) {
            result.add(Pair.of((Object)InteractionHand.MAIN_HAND, (Object)mainHand));
        }
        if ((offHand = ItemInstrumentHandheld.getEntityHeldInstrumentStack((LivingEntity)player, InteractionHand.OFF_HAND)) != null) {
            result.add((Pair<InteractionHand, ItemStack>)Pair.of((Object)InteractionHand.OFF_HAND, (Object)offHand));
        }
        return result;
    }

    public List<Pair<InteractionHand, ItemStack>> getLocalInstrumentsForMidiDevice(Player player, Byte channel) {
        return this.localInstrumentsToPlay.stream().filter(instrumentStack -> MidiNbtDataUtils.getSysInput((ItemStack)instrumentStack.getRight()) != false && MidiNbtDataUtils.isChannelEnabled((ItemStack)instrumentStack.getRight(), channel) != false).collect(Collectors.toList());
    }

    protected void openTransmitter() {
        MIMIMod.LOGGER.info("Opening MIDI Input Device: '" + this.selectedDeviceName + "'");
        for (MidiDevice device : this.getAvailableDevices()) {
            if (!device.getDeviceInfo().getName().equals(this.selectedDeviceName) || this.activeDevice != null) continue;
            MIMIMod.LOGGER.info("Found matching MIDI Input Device: '" + device.getDeviceInfo().getName() + "'");
            try {
                if (device == null) continue;
                MIMIMod.LOGGER.info("Retrieved device: " + device.getDeviceInfo().getName() + "(" + device.getClass().getName().toString() + "): " + device.getTransmitters().size() + " / " + device.getMaxTransmitters());
                if (device.getMaxTransmitters() != 0 && (device.getMaxTransmitters() == -1 || device.getTransmitters().size() < device.getMaxTransmitters())) {
                    MIMIMod.LOGGER.info("Successfully retrieved device from MIDI system. Opening...");
                    this.activeDevice = device;
                    this.activeDevice.open();
                    this.activeTransmitter = device.getTransmitter();
                    this.activeReceiver = new MidiDeviceInputReceiver();
                    this.activeTransmitter.setReceiver(this.activeReceiver);
                    MIMIMod.LOGGER.info("Successfully opened MIDI Input Device.");
                    continue;
                }
                MIMIMod.LOGGER.error("Device is already in use or cannot support any Transmitters.");
                this.midiDeviceError = "Device in use.";
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to open MIDI Input Device: '" + this.selectedDeviceName + "'. Error: " + e.getMessage());
                this.midiDeviceError = e.getMessage();
                this.close();
            }
        }
        if (!this.isDeviceAvailable().booleanValue()) {
            MIMIMod.LOGGER.error("Failed to open MIDI Input Device: '" + this.selectedDeviceName + "'. Error: Device not found.");
            this.midiDeviceError = "Device not found";
        }
    }

    public void open() {
        if (this.isDeviceSelected().booleanValue() && this.activeTransmitter == null) {
            this.openTransmitter();
        }
    }

    public void close() {
        try {
            if (this.activeReceiver != null) {
                MIMIMod.LOGGER.info("Attempting to close MIDI Input Device Receiver: " + this.selectedDeviceName);
                this.activeReceiver.close();
                this.activeReceiver = null;
                MIMIMod.LOGGER.info("Receiver closed.");
            }
        }
        catch (Exception e) {
            MIMIMod.LOGGER.error("Failed to close MIDI Input Device Receiver. Error: " + e.getMessage());
            this.activeReceiver = null;
        }
        try {
            if (this.activeTransmitter != null) {
                MIMIMod.LOGGER.info("Attempting to close MIDI Input Device Transmitter: " + this.selectedDeviceName);
                this.activeTransmitter.close();
                this.activeTransmitter = null;
                MIMIMod.LOGGER.info("Transmitter closed.");
            }
        }
        catch (Exception e) {
            MIMIMod.LOGGER.error("Failed to close MIDI Input Device Transmitter. Error: " + e.getMessage());
            this.activeTransmitter = null;
        }
        try {
            if (this.activeDevice != null) {
                MIMIMod.LOGGER.info("Attempting to close MIDI Input Device: " + this.selectedDeviceName);
                this.activeDevice.close();
                this.activeDevice = null;
                MIMIMod.LOGGER.info("Device closed.");
            }
        }
        catch (Exception e) {
            MIMIMod.LOGGER.error("Failed to close MIDI Input Device. Error: " + e.getMessage());
            this.activeDevice = null;
        }
    }
}

