/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi.synth;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.tofodroid.com.sun.media.sound.SoftSynthesizer;
import io.github.tofodroid.mods.mimi.client.midi.synth.MIMIChannel;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentConfig;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.util.TimeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.world.entity.player.Player;

public abstract class AMIMISynth<T extends MIMIChannel>
implements AutoCloseable {
    protected SoftSynthesizer internalSynth;
    protected Receiver internalSynthReceiver;
    protected Boolean closing = false;
    protected final ImmutableList<T> midiChannelSet;
    protected final BiMap<T, String> channelAssignmentMap;

    public AMIMISynth(AudioFormat format, SourceDataLine dataLine, Boolean jitterCorrection, Integer latency, Soundbank sounds) {
        try {
            this.internalSynth = AMIMISynth.createSynth(format, dataLine, jitterCorrection, false, latency, sounds);
            if (this.internalSynth == null || !this.internalSynth.isOpen()) {
                throw new MidiUnavailableException("Synthesizer failed to open but did not produce an error.");
            }
            this.internalSynthReceiver = this.internalSynth.getReceiver();
        }
        catch (Exception e) {
            MIMIMod.LOGGER.error("Failed to initialize MIDI Synthesizer: ", (Throwable)e);
            this.internalSynth = null;
            this.internalSynth.getVoiceStatus();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.internalSynth != null) {
            for (int i = 0; i < this.internalSynth.getChannels().length; ++i) {
                builder.add(this.createChannel(i, this.internalSynth.getChannels()[i]));
            }
            this.midiChannelSet = builder.build();
            this.channelAssignmentMap = HashBiMap.create((int)this.midiChannelSet.size());
        } else {
            this.midiChannelSet = builder.build();
            this.channelAssignmentMap = HashBiMap.create((int)0);
            this.close();
        }
    }

    public abstract Boolean tick(Player var1);

    protected abstract T createChannel(Integer var1, MidiChannel var2);

    protected abstract String createChannelId(NoteEventPacket var1);

    @Override
    public void close() {
        this.closing = true;
        if (this.internalSynth != null && this.internalSynth.isOpen()) {
            this.reset();
            if (this.internalSynthReceiver != null) {
                this.internalSynthReceiver.close();
            }
            this.internalSynth.close();
        }
    }

    public long getSynthEventTimestamp(Long systemEventMillis) {
        Long synthOffsetMicros = this.internalSynth.getMicrosecondPosition() - TimeUtils.getNowTime() * 1000L;
        return Math.max(systemEventMillis * 1000L + synthOffsetMicros, this.internalSynth.getMicrosecondPosition());
    }

    public void noteOn(NoteEventPacket message, Long timestamp) {
        if (this.channelAssignmentMap == null || this.closing.booleanValue()) {
            return;
        }
        InstrumentSpec instrument = InstrumentConfig.getBydId(message.instrumentId);
        MIMIChannel channel = (MIMIChannel)this.channelAssignmentMap.inverse().get((Object)this.createChannelId(message));
        if (channel == null) {
            ArrayList remainingChannels = new ArrayList(Lists.newArrayList(this.midiChannelSet));
            remainingChannels.removeAll(this.channelAssignmentMap.keySet());
            if (!remainingChannels.isEmpty()) {
                channel = (MIMIChannel)remainingChannels.get(0);
                channel.setInstrument(instrument);
                this.channelAssignmentMap.put((Object)channel, (Object)this.createChannelId(message));
            }
        }
        if (channel != null) {
            try {
                channel.noteOn(message.pos);
                this.internalSynthReceiver.send(new ShortMessage(144, channel.getChannelNumber(), message.data1.byteValue(), message.data2.byteValue()), this.getSynthEventTimestamp(timestamp));
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to handle note on: ", (Throwable)e);
            }
        }
    }

    public void noteOff(NoteEventPacket message, Long timestamp) {
        if (this.channelAssignmentMap == null || this.closing.booleanValue()) {
            return;
        }
        MIMIChannel channel = (MIMIChannel)this.channelAssignmentMap.inverse().get((Object)this.createChannelId(message));
        if (channel != null) {
            try {
                this.internalSynthReceiver.send(new ShortMessage(128, channel.getChannelNumber(), message.data1.byteValue(), 0), this.getSynthEventTimestamp(timestamp));
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to handle note off: ", (Throwable)e);
            }
        }
    }

    public void reset() {
        if (this.internalSynth != null) {
            for (MIMIChannel channel : this.channelAssignmentMap.keySet()) {
                channel.reset();
                if (this.internalSynth == null || !this.internalSynth.isOpen() || this.internalSynth.getMainMixer() == null) continue;
                this.internalSynth.getMainMixer().clearQueuedChannelEvents(channel.getChannelNumber());
            }
        }
    }

    public void controlChange(NoteEventPacket message, Long timestamp) {
        MIMIChannel channel = (MIMIChannel)this.channelAssignmentMap.inverse().get((Object)this.createChannelId(message));
        if (channel != null) {
            try {
                this.internalSynthReceiver.send(new ShortMessage(176, channel.getChannelNumber(), message.data1.byteValue(), message.data2.byteValue()), this.getSynthEventTimestamp(timestamp));
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to handle control change. Packet: " + message.data1 + " | " + message.data2, (Throwable)e);
            }
        }
    }

    public void pitchBend(NoteEventPacket message, Long timestamp) {
        MIMIChannel channel = (MIMIChannel)this.channelAssignmentMap.inverse().get((Object)this.createChannelId(message));
        if (channel != null) {
            try {
                this.internalSynthReceiver.send(new ShortMessage(224, channel.getChannelNumber(), message.data1.byteValue(), message.data2.byteValue()), this.getSynthEventTimestamp(timestamp));
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to handle pitch bend. Packet: " + message.data1 + " | " + message.data2, (Throwable)e);
            }
        }
    }

    public static SoftSynthesizer createSynth(AudioFormat format, SourceDataLine dataLine, Boolean jitterCorrection, Boolean limitChannel10, Integer latency, Soundbank sounds) throws MidiUnavailableException, LineUnavailableException {
        SoftSynthesizer midiSynth = new SoftSynthesizer();
        if (midiSynth.getMaxReceivers() != 0) {
            midiSynth.open();
            midiSynth.close();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("jitter correction", jitterCorrection);
            params.put("limit channel 10", limitChannel10);
            params.put("latency", latency * 1000);
            if (format != null && dataLine != null) {
                MIMIMod.LOGGER.info("Opened data line on device: " + format.toString());
                params.put("format", format);
                midiSynth.open(dataLine, params);
            } else {
                MIMIMod.LOGGER.warn("Opening fallback device.");
                midiSynth.open(null, params);
            }
            if (sounds != null && midiSynth.isSoundbankSupported(sounds)) {
                midiSynth.loadAllInstruments(sounds);
            }
            midiSynth.getReceiver();
            return midiSynth;
        }
        throw new MidiUnavailableException("Midi Synth '" + midiSynth.getDeviceInfo().getName() + "' cannot support any receivers.");
    }
}

